/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.pattern;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenHandler;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultAllNodeStep;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultCommentNodeStep;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultFilterExpr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultNameStep;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultProcessingInstructionNodeStep;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultStep;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultTextNodeStep;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultXPathFactory;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.FilterExpr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.LocationPath;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Predicate;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Step;
import org.xmlpull.v1.builder.xpath.jaxen.expr.UnionExpr;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.LocationPathPattern;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NameTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NamespaceTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NodeTypeTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.Pattern;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.TextNodeTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.UnionPattern;
import org.xmlpull.v1.builder.xpath.saxpath.SAXPathException;
import org.xmlpull.v1.builder.xpath.saxpath.XPathReader;
import org.xmlpull.v1.builder.xpath.saxpath.helpers.XPathReaderFactory;

public class PatternParser {
    private static final boolean TRACE = false;
    private static final boolean USE_HANDLER = false;
    static /* synthetic */ Class class$org$xmlpull$v1$builder$xpath$jaxen$expr$DefaultStep;

    public static Pattern parse(String text) throws JaxenException, SAXPathException {
        XPathReader reader = XPathReaderFactory.createReader();
        JaxenHandler handler = new JaxenHandler();
        handler.setXPathFactory(new DefaultXPathFactory());
        reader.setXPathHandler(handler);
        reader.parse(text);
        Pattern pattern = PatternParser.convertExpr(handler.getXPathExpr().getRootExpr());
        return pattern.simplify();
    }

    protected static Pattern convertExpr(Expr expr) throws JaxenException {
        if (expr instanceof LocationPath) {
            return PatternParser.convertExpr((LocationPath)expr);
        }
        if (expr instanceof FilterExpr) {
            LocationPathPattern answer = new LocationPathPattern();
            answer.addFilter((FilterExpr)expr);
            return answer;
        }
        if (expr instanceof UnionExpr) {
            UnionExpr unionExpr = (UnionExpr)expr;
            Pattern lhs = PatternParser.convertExpr(unionExpr.getLHS());
            Pattern rhs = PatternParser.convertExpr(unionExpr.getRHS());
            return new UnionPattern(lhs, rhs);
        }
        LocationPathPattern answer = new LocationPathPattern();
        answer.addFilter(new DefaultFilterExpr(expr));
        return answer;
    }

    protected static LocationPathPattern convertExpr(LocationPath locationPath) throws JaxenException {
        LocationPathPattern answer = new LocationPathPattern();
        List steps = locationPath.getSteps();
        LocationPathPattern path = answer;
        boolean first = true;
        ListIterator iter = steps.listIterator(steps.size());
        while (iter.hasPrevious()) {
            Step step = (Step)iter.previous();
            if (first) {
                first = false;
                path = PatternParser.convertStep(path, step);
                continue;
            }
            if (PatternParser.navigationStep(step)) {
                LocationPathPattern parent = new LocationPathPattern();
                int axis = step.getAxis();
                if (axis == 2 || axis == 12) {
                    path.setAncestorPattern(parent);
                } else {
                    path.setParentPattern(parent);
                }
                path = parent;
            }
            path = PatternParser.convertStep(path, step);
        }
        if (locationPath.isAbsolute()) {
            LocationPathPattern parent = new LocationPathPattern(NodeTypeTest.DOCUMENT_TEST);
            path.setParentPattern(parent);
        }
        return answer;
    }

    protected static LocationPathPattern convertStep(LocationPathPattern path, Step step) throws JaxenException {
        if (step instanceof DefaultAllNodeStep) {
            int axis = step.getAxis();
            if (axis == 9) {
                path.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
            } else {
                path.setNodeTest(NodeTypeTest.ELEMENT_TEST);
            }
        } else if (step instanceof DefaultCommentNodeStep) {
            path.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else if (step instanceof DefaultProcessingInstructionNodeStep) {
            path.setNodeTest(NodeTypeTest.PROCESSING_INSTRUCTION_TEST);
        } else if (step instanceof DefaultTextNodeStep) {
            path.setNodeTest(TextNodeTest.SINGLETON);
        } else if (step instanceof DefaultCommentNodeStep) {
            path.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else {
            if (step instanceof DefaultNameStep) {
                DefaultNameStep nameStep = (DefaultNameStep)step;
                String localName = nameStep.getLocalName();
                String prefix = nameStep.getPrefix();
                int axis = nameStep.getAxis();
                short nodeType = 1;
                if (axis == 9) {
                    nodeType = 2;
                }
                if (nameStep.isMatchesAnyName()) {
                    if (prefix.length() == 0 || prefix.equals("*")) {
                        if (axis == 9) {
                            path.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
                        } else {
                            path.setNodeTest(NodeTypeTest.ELEMENT_TEST);
                        }
                    } else {
                        path.setNodeTest(new NamespaceTest(prefix, nodeType));
                    }
                } else {
                    path.setNodeTest(new NameTest(localName, nodeType));
                }
                return PatternParser.convertDefaultStep(path, nameStep);
            }
            if (step instanceof DefaultStep) {
                return PatternParser.convertDefaultStep(path, (DefaultStep)step);
            }
            throw new JaxenException("Cannot convert: " + step + " to a Pattern");
        }
        return path;
    }

    protected static LocationPathPattern convertDefaultStep(LocationPathPattern path, DefaultStep step) throws JaxenException {
        List predicates = step.getPredicates();
        if (!predicates.isEmpty()) {
            DefaultFilterExpr filter = new DefaultFilterExpr();
            Iterator iter = predicates.iterator();
            while (iter.hasNext()) {
                filter.addPredicate((Predicate)iter.next());
            }
            path.addFilter(filter);
        }
        return path;
    }

    protected static boolean navigationStep(Step step) {
        if (step instanceof DefaultNameStep) {
            return true;
        }
        if (step.getClass().equals(class$org$xmlpull$v1$builder$xpath$jaxen$expr$DefaultStep == null ? (class$org$xmlpull$v1$builder$xpath$jaxen$expr$DefaultStep = PatternParser.class$("org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultStep")) : class$org$xmlpull$v1$builder$xpath$jaxen$expr$DefaultStep)) {
            DefaultStep defaultStep = (DefaultStep)step;
            return !step.getPredicates().isEmpty();
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

