/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class FileWagon
extends StreamWagon {
    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        Resource resource = inputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        if (!file.exists()) {
            throw new ResourceDoesNotExistException("File: " + file + " does not exist");
        }
        try {
            FileInputStream in = new FileInputStream(file);
            inputData.setInputStream(in);
            resource.setContentLength(file.length());
            resource.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException("Could not read from file: " + file.getAbsolutePath(), e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        this.createParentDirectories(file);
        LazyFileOutputStream outputStream = new LazyFileOutputStream(file);
        outputData.setOutputStream(outputStream);
    }

    public void openConnection() {
    }

    public void closeConnection() {
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        File path = (destinationDirectory = StringUtils.replace(destinationDirectory, "\\", "/")).equals(".") ? new File(basedir) : new File(basedir, destinationDirectory);
        path.mkdirs();
        if (!path.exists() || !path.isDirectory()) {
            throw new TransferFailedException("Could not make directory '" + path.getAbsolutePath() + "'.");
        }
        try {
            FileUtils.copyDirectoryStructure(sourceDirectory, path);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error copying directory structure", e);
        }
    }
}

