/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Contains
extends CollatingFunction {
    public static final int CONTAINS = 0;
    public static final int STARTSWITH = 1;
    public static final int ENDSWITH = 2;
    public static final int AFTER = 3;
    public static final int BEFORE = 4;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        Comparator comparator = this.getCollator(2, xPathContext, false);
        AtomicValue atomicValue2 = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            atomicValue2 = StringValue.EMPTY_STRING;
        }
        if ((atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext)) == null) {
            atomicValue = StringValue.EMPTY_STRING;
        }
        String string = atomicValue2.getStringValue();
        String string2 = atomicValue.getStringValue();
        if (comparator instanceof CodepointCollator) {
            switch (this.operation) {
                case 0: {
                    return BooleanValue.get(string.indexOf(string2) >= 0);
                }
                case 1: {
                    return BooleanValue.get(string.startsWith(string2));
                }
                case 2: {
                    return BooleanValue.get(string.endsWith(string2));
                }
                case 3: {
                    int n = string.indexOf(string2);
                    if (n < 0) {
                        return StringValue.EMPTY_STRING;
                    }
                    return new StringValue(string.substring(n + string2.length()));
                }
                case 4: {
                    int n = string.indexOf(string2);
                    if (n < 0) {
                        return StringValue.EMPTY_STRING;
                    }
                    return new StringValue(string.substring(0, n));
                }
            }
            throw new UnsupportedOperationException("Unknown operation " + this.operation);
        }
        if (!(comparator instanceof RuleBasedCollator)) {
            this.dynamicError("The collation for " + this.getName() + " must be a RuleBaseCollator");
            return null;
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)comparator;
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = ruleBasedCollator.getCollationElementIterator(string2);
        switch (this.operation) {
            case 1: {
                return BooleanValue.get(this.collationStartsWith(collationElementIterator, collationElementIterator2));
            }
            case 0: 
            case 2: {
                return BooleanValue.get(this.collationContains(collationElementIterator, collationElementIterator2, null));
            }
            case 3: {
                int[] nArray = new int[2];
                boolean bl = this.collationContains(collationElementIterator, collationElementIterator2, nArray);
                if (bl) {
                    return new StringValue(string.substring(nArray[1]));
                }
                return StringValue.EMPTY_STRING;
            }
            case 4: {
                int[] nArray = new int[2];
                boolean bl = this.collationContains(collationElementIterator, collationElementIterator2, nArray);
                if (bl) {
                    return new StringValue(string.substring(0, nArray[0]));
                }
                return StringValue.EMPTY_STRING;
            }
        }
        throw new UnsupportedOperationException("Unknown operation " + this.operation);
    }

    private boolean collationStartsWith(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2) {
        int n;
        int n2;
        do {
            if ((n = collationElementIterator2.next()) != -1) continue;
            return true;
        } while ((n2 = collationElementIterator.next()) == n);
        return false;
    }

    private boolean collationContains(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2, int[] nArray) {
        int n = collationElementIterator2.next();
        if (n == -1) {
            return true;
        }
        int n2 = -1;
        while (true) {
            if (n2 != n) {
                n2 = collationElementIterator.next();
                if (n2 != -1) continue;
                return false;
            }
            int n3 = collationElementIterator.getOffset();
            if (this.collationStartsWith(collationElementIterator, collationElementIterator2)) {
                if (this.operation != 2) {
                    if (nArray != null) {
                        nArray[0] = n3 - 1;
                        nArray[1] = collationElementIterator.getOffset();
                    }
                    return true;
                }
                if (collationElementIterator.next() == -1) {
                    return true;
                }
            }
            collationElementIterator.setOffset(n3);
            if (collationElementIterator.getOffset() != n3) {
                collationElementIterator.next();
            }
            collationElementIterator2.reset();
            n2 = -1;
            n = collationElementIterator2.next();
        }
    }
}

