/* @(#)utils.h	1.11 2/12/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _UTILS_H
#define _UTILS_H

/* utility functions */

#define TYPE_STRICT(OBJ, TYPE)\
{\
    if (CLASS((OBJ)) != (TYPE))\
	errorPrint(BadClass, "%O is not of type %O", (OBJ), typeSym((TYPE)));\
}

#define TYPE_CHECK(OBJ, TYPE)\
{\
    if (!objIsClass((OBJ), (TYPE)))\
	errorPrint(BadClass, "%O is not of type %O", (OBJ), typeSym((TYPE)));\
}

#ifdef INLINE

/* inline type check routines */

#define typeStrict(OBJ, TYPE)\
{ register Obj _obj = (OBJ); TYPE_STRICT(_obj, (TYPE)); }

#define typeCheck(OBJ, TYPE)\
{ register Obj _obj = (OBJ); TYPE_CHECK(_obj, (TYPE)); }

#else

#define typeStrict(OBJ, TYPE) _typeStrict((OBJ), (TYPE))
#define typeCheck(OBJ, TYPE) _typeCheck((OBJ), (TYPE))

#endif /* defined(INLINE) */

#ifdef __STDC__

/* Evaluate expression in scope defined by frame and return the result, which
 * is placed in the current gc. */
extern Obj objEval(Obj expr, Obj frame);

/* Apply proc (user or prim) to arg and return the result, which is
 * placed in the current gc. */
extern Obj objApply1(Obj proc, Obj arg);

/* Apply proc (user or prim) to args (list) and return the result, which is
 * placed in the current gc. */
extern Obj objApply(Obj proc, Obj args);

/* standard exit */
extern void FATAL(char *mesg);

/* Start a read-eval-print loop. Expressions are read from fin and
 * evaluated in the current package.  Results are sent to fout
 * if not NULL.  If prompt is TRUE then prompts are sent to stdout.
 * An error terminates the loop. */
extern void repLoop(Obj fin, FILE *fout, Boolean prompt);

/* Expand leading ~ or ~username in fn.  Returns a static array. */
extern char *expandFilename(char *fn);

/* Load fn into current package.  If script is set, then the first line
 * is stripped.  The current package, if changed, will be restored.
 * The result of evaluating each expression is echoed if verbose is TRUE.
 * If fn does not exist and toplevel is TRUE then exit.  Otherwise call
 * errorPrint. */
extern void loadFile(char *fn, Boolean script, Boolean verbose,
		     Boolean toplevel);

/* Convert vector to list. */
extern Obj vectorToList(Obj vec);

/* Convert list to vector.  If list isn't really a list, then return NULL. */
extern Obj listToVector(Obj list);

/* Append two lists together destructively. */
extern Obj objAppendList(Obj a, Obj b);

/* Append a list of b to a destructively. */
extern Obj objAppendObj(Obj a, Obj b);

/* Return the list (op arg). */
extern Obj objOp1(Obj op, Obj arg);

/* Return the list (op arg1 arg2). */
extern Obj objOp2(Obj op, Obj arg1, Obj arg2);

/* Get argn from the list (arg0 arg1 ...) or NULL if n is too large. */
extern Obj objGetArg(Obj exp, int argnum);

/* if obj is not type then generate an error */
extern void _typeStrict(Obj obj, Class type);

/* if obj is not type or a subclass of type then generate an error */
extern void _typeCheck(Obj obj, Class type);

/* wrapper for objPrint that prints strings and characters with any escapes */
extern void objDisplay(Obj obj, FILE *port);

/* make a string that is a representation of obj
 *
 * prnt is a function of two arguments (obj, file) that sends the
 * representation of obj to file.  The output to file is returned
 * as a C string.
 * If obj has cycles then NULL is returned. */
extern char *objAsString(Obj obj, F_VOID prnt);

/* clear all the MARK bits of pairs, vectors, or boxes in obj
 *
 * Assumes that only pairs, vectors, or boxes can have cycles. */
extern void clearMarks(Obj obj);

/* return TRUE if obj is cyclic
 *
 * Assumes that the only pairs or vectors can have cycles. */
extern Boolean objHasCycle(Obj obj);

#else

extern Obj objEval();
extern Obj objApply1();
extern Obj objApply();
extern void FATAL();
extern void repLoop();
extern char *expandFilename();
extern void loadFile();
extern Obj vectorToList();
extern Obj listToVector();
extern Obj objAppendList();
extern Obj objAppendObj();
extern Obj objOp1();
extern Obj objOp2();
extern Obj objGetArg();
extern void _typeStrict();
extern void _typeCheck();
extern void objDisplay();
extern char *objAsString();
extern void clearMarks();
extern Boolean objHasCycle();

#endif /* defined(__STDC__) */

#endif /* !defined(_UTILS_H) */
