/* special forms */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include "utils.h"
#include "prim.h"
#include "codegen.h"
#include "sforms.h"

#ifndef lint
static char SccsId[] = "@(#)sforms.c	1.13 2/23/90";
#endif

static Obj lambdaForm;

/* return the symbol portion of the binding */
static Obj unbindSymbol(sym)
     Obj sym;
{
    if (objIsClass(sym, Binding)) return objCar(sym);
    return sym;
}

/* assert that sym is a symbol (converted during scope-binding to a binding)
 *
 * If sym is not a binding an error occurs. */
static void typeSymbol(sym)
     Obj sym;
{
    if (!objIsClass(sym, Binding))
	errorPrint(BadClass, "%O is not a symbol", sym);
}

/* Compiler for generic specials of the form (sform symbol expr).
 *
 * func is a pointer to the form's run-time evaluator.  func
 * is invoked by code_cfunc so takes args as specified by the
 * SF_EVAL macro.
 *
 * unbind determines whether the binding information for symbol
 * should be kept.  When FALSE the binding information is pushed
 * otherwise the symbol. */
static void compStub1(func, argv, gen, unbind, opt)
     F_OBJ func;
     Obj *argv;
     CodeGen gen;
     Boolean unbind;
     optInfo_t *opt;
{
    typeSymbol(argv[0]);
    codePush((unbind ? unbindSymbol(argv[0]) : argv[0]), gen);
    compExpr(argv[1], gen, FALSE, opt);
    codeInst(code_cfunc, gen);
    codeFcnOp(func, gen);
    codeOp(2, gen);
}

SF_COMP(compIf)
{
    Label_t *toelse, *fallthrough;

    if (argc > 3)
	errorPrint(BadArgs, "to if (expects two or three)");
    fallthrough = labelNew(gen);
    compExpr(argv[0], gen, FALSE, opt);
    if (argc == 2) {
	codeBranch(code_branch_save, fallthrough, gen);
	codePop(gen);
	compExpr(argv[1], gen, tail, opt);
    }
    else {
	toelse = labelNew(gen);
	codeBranch(code_branch, toelse, gen);
	compExpr(argv[1], gen, tail, opt);
	if (tail) codeInst(code_call_return, gen);
	else codeBranch(code_goto, fallthrough, gen);
	labelDefine(toelse, gen);
	compExpr(argv[2], gen, tail, opt);
    }
    labelDefine(fallthrough, gen);
}

SF_COMP(compSequence)
{
    if (argc == 0) codePush(NilSymb, gen);
    else {
	while (--argc > 0) {
	    compExpr(*(argv++), gen, FALSE, opt);
	    codePop(gen);
	}
	compExpr(*argv, gen, tail, opt);
    }
}

/* evaluate the expressions in sequence returning the value of the first
 *
 * The entire expression is tail recursive only if there is one expression. */
SF_COMP(compBegin1)
{
    if (argc == 0) codePush(NilSymb, gen);
    else {
	compExpr(*(argv++), gen, tail && argc == 1, opt);
	while (--argc > 0) {
	    compExpr(*(argv++), gen, FALSE, opt);
	    codePop(gen);
	}
    }
}

SF_EVAL1(sfLambda1)
{
    return newUser(gcNew, vec[0].num, vec[1].num, vec[2].num,
		   argv[0], callframe);
}

/*ARGSUSED*/
/* after scope binding lambda forms are converted to
 * (lambda numfixed numargs mask lexpr fp body) */
SF_COMP(compLambda)
{
    CodeGen lgen;
    Callback_t cb;
    optInfo_t ropt;
    int numargs, numfixed, status;

    lgen = codeNew(&cb);
    numfixed = objInteger(argv[0]);
    numargs = objInteger(argv[1]);
    status = objInteger(argv[2]);
    DEF_OPT(ropt);
    if (opt->top == (Label_t *)NULL) ropt.id = opt->id;
    ropt.top = labelNew(lgen);
    ropt.numargs = numargs;
    ropt.optarg = status & OPTARG;
    labelDefine(ropt.top, lgen);
    compExpr(argv[5], lgen, TRUE, &ropt);
    codeInst(code_call_return, lgen);

    codePush(newCodevec(gcNew, lgen, argv[4], argv[3]), gen);
    codeInst(code_cfuncN, gen);
    codeFcnOp(sfLambda1, gen);
    codeOp(1, gen);
    codeOp(3, gen);
    codeOp(numfixed, gen);
    codeOp(numargs, gen);
    codeOp(status, gen);
}


/* handle links for internal defines */
static void
internalDefine(proc, callframe)
     Obj proc, callframe;
{
    if (objIsClass(proc, User)
	&& callframe == DATA(proc, frame, userInst)
	&& !checkCond(proc, INTERNAL)) {
	--DATA(callframe, rc, basicInst);
	setCond(proc, INTERNAL);
    }
}

SF_EVAL(sfDefine)
{
    Obj sym, val = argv[1];

    sym = objCar(argv[0]);
    objSetBinding(argv[0], val, callframe, FALSE);
    if (objIsClass(val, Proc)) {
	if (DATA(val, name, procInst) == (char *)NULL)
	    DATA(val, name, procInst) = objString(sym);
	internalDefine(val, callframe);
    }
    return sym;
}

SF_EVAL1(sfDefine1)
{
    Obj *fixed, proc = argv[0];

    fixed = DATA(callframe, fixed, frameInst) + vec[0].num;
    if (*fixed) objUnlink(*fixed);
    objLink(*fixed = proc);
    internalDefine(proc, callframe);
    return proc;
}

SF_COMP(compDefine)
{
    optInfo_t ropt;

    ASSERT(objIsClass(argv[0], Binding));
    typeSymbol(argv[0]);
    ropt = *opt;
    if (CLASS(argv[1]) == Pair && objCar(argv[1]) == lambdaForm) {
	/* set id and remove top label */
	ropt.id = argv[0];
	ropt.top = (Label_t *)NULL;
    }

    if (CLASS(argv[0]) == Binding) {
	codePush(argv[0], gen);
	compExpr(argv[1], gen, FALSE, &ropt);
	codeInst(code_cfunc, gen);
	codeFcnOp(sfDefine, gen);
	codeOp(2, gen);
    }
    else {
	compExpr(argv[1], gen, FALSE, &ropt);
	codeInst(code_cfuncN, gen);
	codeFcnOp(sfDefine1, gen);
	codeOp(1, gen);
	codeOp(1, gen);
	codeOp(DATA(argv[0], offset, fbindInst), gen);
    }
}

SF_COMP(compQuote)
{
    ASSERT(argc == 1);
    codePush(argv[0], gen);
}


SF_EVAL(sfSetq)
{
    objSetBinding(argv[0], argv[1], callframe, TRUE);
    return argv[1];
}

SF_COMP(compSetq)
{
    compStub1(sfSetq, argv, gen, FALSE, opt);
}

SF_EVAL(sfDefineMacro)
{
    Obj sym = argv[0], macro = argv[1];

    ASSERT(CLASS(sym) = Symbol);
    typeCheck(sym, Symbol);
    typeCheck(macro, Proc);
    objSetMacro(sym, macro);
    if (DATA(macro, name, procInst) == (char *)NULL)
	DATA(macro, name, procInst) = objString(sym);
    return sym;
}

SF_COMP(compDefineMacro)
{
    compStub1(sfDefineMacro, argv, gen, TRUE, opt);
}

SF_COMP(compAnd)
{
    Label_t *fallthrough;

    if (argc == 0) codePush(TrueSymb, gen);
    else {
	fallthrough = labelNew(gen);
	while (--argc > 0) {
	    compExpr(*(argv++), gen, FALSE, opt);
	    codeBranch(code_branch_save, fallthrough, gen);
	    codePop(gen);
	}
	compExpr(*argv, gen, tail, opt);
	labelDefine(fallthrough, gen);
    }
}

SF_COMP(compOr)
{
    Label_t *fallthrough;

    if (argc == 0) codePush(FalseSymb, gen);
    else {
	fallthrough = labelNew(gen);
	while (--argc > 0) {
	    compExpr(*(argv++), gen, FALSE, opt);
	    codeBranch(code_tbranch_save, fallthrough, gen);
	    codePop(gen);
	}
	compExpr(*argv, gen, tail, opt);
	labelDefine(fallthrough, gen);
    }
}

SF_EVAL(sfTheEnvironment)
{
    return callframe;
}

SF_COMP(compTheEnvironment)
{
    ASSERT(argc == 0);
    codeInst(code_cfunc, gen);
    codeFcnOp(sfTheEnvironment, gen);
    codeOp(0, gen);
}

/* call-with-current-continuation */
SF_COMP(compCallCC)
{
    ASSERT(argc == 1);
    compExpr(argv[0], gen, FALSE, opt);
    codeInst(code_call_cc, gen);
}

SF_COMP(compApply)
{
    ASSERT(argc == 2);
    compExpr(argv[0], gen, FALSE, opt);
    compExpr(argv[1], gen, FALSE, opt);
    codeInst(tail ? code_tail_apply : code_apply, gen);
}

struct sform_s {
    char *name;
    F_VOID compiler;
    int opts, args;
} sforms[] = {
    /* name		compiler		opts		args */

    { "lambda",		compLambda,		NOEXPAND|OPTARG, 1 },
    { "if",		compIf,			OPTARG,		2 },
    { "and",		compAnd,		OPTARG,		0 },
    { "or",		compOr,			OPTARG,		0 },
    { "sequence",	compSequence,		OPTARG,		0 },
    { "begin",		compSequence,		OPTARG,		0 },
    { "begin1",		compBegin1,		OPTARG,		0 },
    { "define",		compDefine,		0,		2 },
    { "define-macro",	compDefineMacro,	0,		2 },
    { "set!",		compSetq,		0,		2 },
    { "quote",		compQuote,		NOEXPAND,	1 },
    { "the-environment", compTheEnvironment,	0,		0 },
    { "call-with-current-continuation", compCallCC, 0,		1 },
    { "apply",		compApply,		0,		2 },
};

#define NUMFORMS (sizeof (sforms) / sizeof (struct sform_s))

/* make the special forms */
void sfInit()
{
    int i;

    for (i = 0; i < NUMFORMS; i++)
	(void)newSpecial(gcNew, sforms[i].name, sforms[i].compiler,
			 sforms[i].opts, sforms[i].args);
    lambdaForm = objSForm(LambdaSymb);
}
