/* @(#)parser.h	1.6 2/12/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _PARSER_H
#define _PARSER_H

/* token types */
typedef enum token_e {
    tNone = 0, tEOF, tNum, tLpar, tRpar, tLbrace, tRbrace, tString,
    tPsymbol, tSymbol, tQuote, tBquote, tUnquote, tSplice, tVector,
    tLbracket, tRbracket, tChar, tInt, tBox, tSpace,
} Token;

#define PROMPT_LEN 32
extern char parsePrompt1[PROMPT_LEN], parsePrompt2[PROMPT_LEN];

#define LEXBUF 508

/* parser info */
typedef struct par_info_s {
    enum token_e state;
    char text[ LEXBUF ];
} parInfo_t;

/* parser info allocator */
extern Mem parInfoAlloc;

#ifdef __STDC__

/* intialize the parser */
extern void parseInit(void);

/* read one object from the input stream st
 *
 * NULL is returned on EOF
 * prompts are sent to wfile (if NULL then no prompting occurs) */
extern Obj parseObj(Obj st, FILE *wfile);

/* convert str into an integer */
extern Obj parseInteger(char *str);

/* convert integer of radix base in str to a number
 *
 * number is stored in out
 * and TRUE is returned if str contains only valid digits */
extern Boolean str2num(char *str, int base, double *out);

/* convert num to string with radix base */
extern char *num2str(long num, int base);

#else

extern void parseInit();
extern Obj parseObj();
extern Obj parseInteger();
extern Boolean str2num();
extern char *num2str();

#endif /* __STDC__ */

#endif /* _PARSER_H */
