/* @(#)gc.h	1.3 9/23/89 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifdef __STDC__

/* initialize the garbage collector */
extern void gcInit(void);

/* Begin a gc level in which all objects that are allocated during this
 * period and remain unused can be destroyed by gcEnd. It is possible to
 * nest gc levels but not overlap them. */
extern void gcBegin(void);

/* End (free all unused) objects created during the current gc level. */
extern void gcEnd(void);

/* Insert object into the current gc level.  Assumes obj has an extra link. */
extern void gcInsert(Obj obj);

/* Get a new object that will not be free'd by gcEnd. */
extern Obj gcNew(Class objclass);

/* Get a new object that will be free'd by the next gcEnd unless linked. */
extern Obj gcTemp(Class objclass);

/* free obj */
extern void gcFree(Obj obj);

/* Return a list that can be used locally and is freed by gcListFree or
 * an error.  */
extern List gcListNew(Callback_t *cb);

/* Free the list allocated by gcListNew.  Since callbacks are placed on
 * a stack, the lists must be free'd in the reverse order in which they
 * were created. */
extern void gcListFree(List list);

#else

extern void gcInit();
extern void gcBegin();
extern void gcEnd();
extern void gcInsert();
extern Obj gcNew();
extern Obj gcTemp();
extern void gcFree();
extern List gcListNew();
extern void gcListFree();

#endif /* __STDC__ */
