/* @(#)String.h	1.10 3/2/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef STRING_HDR
#define STRING_HDR

/* string instance */
typedef struct stringInst_s {
   basicInst_t inherit;
   char *string;
   int maxsize;
} stringInst_t, *stringInst;

/* string/symbol status flags */
#define MACRO		BIT(0)	/* macro */
#define SFORM		BIT(1)	/* special form */
#define NOEXPAND	BIT(2)	/* form can't be macro expanded */
#define STATIC		BIT(3)	/* string was statically allocated */

extern basicClass_t protoString;
#define String ((Class)&protoString)

/* symbol instance */
typedef struct symbolInst_s {
    stringInst_t inherit;
} symbolInst_t, *symbolInst;

extern basicClass_t protoSymbol;
#define Symbol ((Class)&protoSymbol)

#define objString(str) DATA((str), string, stringInst)

#ifdef __STDC__

	/* strings */

/* create a new string object */
extern Obj newString(F_OBJ alloc, char *string);
extern Obj newString1(F_OBJ alloc, int len);

	/* symbols */

/* set macro expander for sym */
extern void objSetMacro(Obj sym, Obj macro);

/* get macro expander for sym */
extern Obj objMacro(Obj sym);

/* set special form for sym */
extern void objSetSForm(Obj sym, Obj sform);

/* get special form for sym */
extern Obj objSForm(Obj sym);

/* return unique symbol corresponding to name */
extern Obj objIntern(char *name, int status);

/* get property for sym from tree */
extern Obj objGetProp(Obj sym, Tree tree);

/* set property for sym to data (unlink previous contents if dest is set) */
extern void objSetProp(Obj sym, Obj data, Tree tree, Boolean dest);

#else

extern Obj newString();
extern Obj newString1();

extern void objSetMacro();
extern Obj objMacro();
extern void objSetSForm();
extern Obj objSForm();

extern Obj objIntern();

extern Obj objGetProp();
extern void objSetProp();

#endif /* __STDC__ */

#endif /* _STRING_H */
