/* procedure class */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include "codegen.h"

#ifndef lint
static char SccsId[] = "@(#)Proc.c	1.7 1/16/90";
#endif

/* send the print representation of proc to file */
static void procPrint(proc, file)
     Obj proc;
     FILE *file;
{
    char *name;

    if (name = DATA(proc, name, procInst))
	(void)fprintf(file, "#<%s %s>", CLASS(proc)->type, name);
    else (void)fprintf(file, "#<%s %#lx>", CLASS(proc)->type, (long)proc);
}

/* procedure class struct */

basicClass_t protoProc =
    DEFBASIC(Basic, procInst_t, procPrint, (F_VOID)NULL, "procedure");

/* primitive procedures */

/* make a new primitive for func and bind it to name in env */
Obj newPrim(alloc, name, func, env, status, numargs)
     F_OBJ alloc;
     char *name;
     F_OBJ func;
     Obj env;
     int status, numargs;
{
    Obj new;

    new = (*alloc)(Prim);
    DATA(new, name, procInst) = name;
    DATA(new, numargs, procInst) = numargs;
    DATA(new, cfunc, primInst) = func;
    setCond(new, status);
    (void)objPut(objIntern(name, STATIC), new, env);

    return new;
}

/* primitive proc struct */
basicClass_t protoPrim =
    DEFBASIC(Proc, primInst_t, procPrint, (F_VOID)NULL, "primitive");

/* special forms */

/* register a new special form compiler for the symbol corresponding to name */
Obj newSpecial(alloc, name, comp, status, numargs)
     F_OBJ alloc;
     char *name;
     F_VOID comp;
     int status, numargs;
{
    Obj new;

    new = (*alloc)(Special);
    DATA(new, name, procInst) = name;
    DATA(new, compiler, specialInst) = comp;
    DATA(new, numargs, procInst) = numargs;
    setCond(new, status);
    objSetSForm(objIntern(name, STATIC), new);

    return new;
}

/* special form struct */
basicClass_t protoSpecial =
    DEFBASIC(Proc, specialInst_t, procPrint, (F_VOID)NULL, "special");

/* user (lambda) procedures */

/* return a new local frame for proc */
Obj objFrame(proc)
     Obj proc;
{
    Obj frame;
    
    ASSERT(CLASS(proc) == User);

    frame = newFrame(gcNew, DATA(proc, frame, userInst));

    DATA(frame, numfixed, frameInst) = DATA(proc, numfixed, userInst);
    objLink(DATA(frame, formals, frameInst) = objFormals(proc));
    setCond(frame, checkCond(proc, STABLE|LEAF));

    return frame;
}
    
/* create a new user procedure */
Obj newUser(alloc, numfixed, numargs, status, code, parent)
     F_OBJ alloc;
     int status, numargs, numfixed;
     Obj code, parent;
{
    Obj new;

    ASSERT(parent != (Obj)NULL);

    new = (*alloc)(User);
    DATA(new, code, userInst) = code;
    objLink(code);
    /* defining frame is not linked in order to avoid cycles */
    DATA(new, frame, userInst) = parent;

    DATA(new, numfixed, userInst) = numfixed;
    setCond(new, status);
    DATA(new, numargs, procInst) = numargs;

    return new;
}

/* unlink lambda formals and body and parent frame */
static void userDestroy(proc)
     Obj proc;
{
    objUnlink(objCode(proc));
    /* defining frame should be in the process of destroying itself */
}

/* user proc struct */
basicClass_t protoUser =
    DEFBASIC(Proc, userInst_t, procPrint, userDestroy, "lambda");
