/* @(#)Pair.h	1.5 1/16/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

/* pair instance */
typedef struct pairInst_s {
    basicInst_t inherit;
    Obj car, cdr;
} pairInst_t, *pairInst;

/* A binding is a list of possible values of a variable threaded through
 * non-stable frames to allow redefinition. */

/* A fixed binding holds the offset into the fixed vector of the a frame
 * and the number of parent links to follow to find the frame for a given
 * variable. */

/* fixed binding instance */
typedef struct fbindInst_t {
    basicInst_t inherit;
    Obj car;
    short links, offset;
} fbindInst_t, *fbindInst;

extern basicClass_t protoPair;
extern basicClass_t protoBinding;
extern basicClass_t protoFBinding;

#define Pair ((Class)&protoPair)
#define Binding ((Class)&protoBinding)
#define FBinding ((Class)&protoFBinding)

/* list printing limits */
extern int ListDepth, ListBreadth; /* -1 means unlimited */

/* reference the car or cdr portions of pair */
#define objCar(pair) DATA((pair), car, pairInst)
#define objCdr(pair) DATA((pair), cdr, pairInst)

#ifdef __STDC__

/* set the car of pair */
extern void objSetCar(Obj pair, Obj car);

/* set the cdr of pair */
extern void objSetCdr(Obj pair, Obj cdr);

/* create a new pair */
extern Obj newPair(F_OBJ alloc, Obj car, Obj cdr);

/* Return the value of binding or NULL if undefined. */
extern Obj objUnbind(Obj binding, Obj frame);

/* set the value of the binding
 *
 * If bot is TRUE then set the bottom binding otherwise the top. */
extern void objSetBinding(Obj binding, Obj val, Obj frame, Boolean bot);

/* create a new binding */
extern Obj newBinding(F_OBJ alloc, Obj key, Obj val);

/* create a new fixed binding */
extern Obj newFBinding(F_OBJ alloc, Obj key, short links, short offset);

#else

extern void objSetCar();
extern void objSetCdr();
extern Obj newPair();

extern Obj objUnbind();
extern void objSetBinding();
extern Obj newBinding();
extern Obj newFBinding();

#endif /* __STDC__ */
