/* @(#)Number.h	1.5 1/16/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _NUMBER_H
#define _NUMBER_H

/* number status flags */
#define EXACT		BIT(0) /* exactness */
#define NEGATIVE	BIT(1) /* sign bit for integers */

/* number class */
typedef struct numberClass_s {
    basicClass_t inherit;
    double (*num)();
} numberClass_t, *numberClass;

#define DEFNUMBER(basic, num) { basic, num }

/* number instance */
typedef struct numberInst_s {
    basicInst_t inherit;
    double num;
} numberInst_t, *numberInst;

extern numberClass_t protoNumber;
#define Number ((Class)&protoNumber)

extern char numberFormat[ 32 ], integerFormat[ 32 ];

/* integers */

typedef struct intClass_s {
    numberClass_t inherit;
    long (*integer)();
} intClass_t, *intClass;

#define DEFINT(num, integer) { num, integer }

typedef struct intInst_s {
    basicInst_t inherit;
    long integer;
} intInst_t, *intInst;

extern intClass_t protoInt;
#define Integer ((Class)&protoInt)

extern intClass_t protoChar;
#define Character ((Class)&protoChar)

/* format to use for printing out numbers */
extern char numberFormat[];

#ifdef __STDC__

/* get value of num */
extern double objNum(Obj num);
extern long objInteger(Obj integer);

/* constructors */
extern Obj newNumber(F_OBJ alloc, double val);
extern Obj newInteger(F_OBJ alloc, long val);
extern Obj newChar(F_OBJ alloc, char val);

#else

extern double objNum();
extern long objInteger();
extern Obj newNumber();
extern Obj newInteger();
extern Obj newChar();

#endif /* defined(__STDC__) */

#endif /* !defined(_NUMBER_H) */
