/* number objects */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include <ctype.h>

#ifndef lint
static char SccsId[] = "@(#)Number.c	1.8 1/16/90";
#endif

/* print formats for numbers and integers */

char numberFormat[ 32 ] = "%g";
char integerFormat[ 32 ] = "%d";

double objNum(obj)
     Obj obj;
{
    ASSERT(objIsClass(obj, Number));
    return PROC(obj, num, numberClass)(obj);
}

static double numNum(obj)
     Obj obj;
{
    return DATA(obj, num, numberInst);
}

Obj newNumber(alloc, val)
     F_OBJ alloc;
     double val;
{
    Obj new;

    new = (*alloc)(Number);
    DATA(new, num, numberInst) = val;

    return new;
}

static void numberPrint(obj, out)
     Obj obj;
     FILE *out;
{
    (void)fprintf(out, numberFormat, objNum(obj));
}

numberClass_t protoNumber =
    DEFNUMBER(DEFBASIC(Basic, numberInst_t, numberPrint, (F_VOID)NULL,
		       "number"),
	      numNum);
    
static double intNum(obj)
     Obj obj;
{
    return (double)DATA(obj, integer, intInst);
}

long objInteger(obj)
     Obj obj;
{
    ASSERT(objIsClass(obj, Integer));
    return PROC(obj, integer, intClass)(obj);
}

static long intInteger(obj)
     Obj obj;
{
    ASSERT(objIsClass(obj, Integer));
    return DATA(obj, integer, intInst);
}

static void intPrint(obj, file)
     Obj obj;
     FILE *file;
{
    (void)fprintf(file, integerFormat, intInteger(obj));
}

#define INTINST(val) { { Integer, EXACT, 1 }, (long)val }

static intInst_t permInts[] = 
{
    INTINST(-10), INTINST(-9), INTINST(-8), INTINST(-7), INTINST(-6),
    INTINST(-5), INTINST(-4), INTINST(-3), INTINST(-2), INTINST(-1),
    INTINST(0),
    INTINST(1), INTINST(2), INTINST(3), INTINST(4), INTINST(5),
    INTINST(6), INTINST(7), INTINST(8), INTINST(9), INTINST(10),
};

Obj newInteger(alloc, val)
     F_OBJ alloc;
     long val;
{
    Obj new;

    if (val >= -10 && val <= 10)
	return (Obj)&permInts[ val + 10 ];

    new = (*alloc)(Integer);
    DATA(new, integer, intInst) = val;
    setCond(new, EXACT);
    return new;
}

intClass_t protoInt =
    DEFINT(DEFNUMBER(DEFBASIC(Number, intInst_t, intPrint, (F_VOID)NULL,
			      "integer"),
		     intNum),
	   intInteger);

static void charPrint(obj, file)
     Obj obj;
     FILE *file;
{
    int c;
    char *rep = (char *)NULL;

    fputc('#', file); fputc('\\', file);
    switch (c = DATA(obj, integer, intInst)) {
    case ' ':
	rep = "space";
	break ;
    case '\n':
	rep = "newline";
	break ;
    case '\t':
	rep = "tab";
	break ;
    default:
	if (!isascii(c) || !isprint(c)) {
	    (void)fprintf(file, "x%.2x", c & 0xff);
	    return ;
	}
	break ;
    }

    if (rep) fputs(rep, file);
    else putc(c, file);
}

Obj newChar(alloc, val)
     F_OBJ alloc;
     char val;
{
    Obj new;

    new = (*alloc)(Character);
    DATA(new, integer, intInst) = val;
    setCond(new, EXACT);
    return new;
}

intClass_t protoChar =
    DEFINT(DEFNUMBER(DEFBASIC(Integer, intInst_t, charPrint, (F_VOID)NULL,
			      "character"),
		     intNum),
	   intInteger);
