 /*
  * Khoros: $Id: raw.c,v 1.2 1991/07/15 06:06:46 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: raw.c,v 1.2 1991/07/15 06:06:46 khoros Exp $";
#endif

 /*
  * $Log: raw.c,v $
 * Revision 1.2  1991/07/15  06:06:46  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	raw.c
# 
# AUTHORS:	Mark Young & Tom Sauer
#
# 
# DATE:		11/10/89
# 
# DESCRIPTION:
#	RAW data utilites, for read and writing raw data.
#
# 
# MODIFICATIONS:
# 
*/

#include "unmcopyright.h"	 
#include "vinclude.h"	 	

/**************************************************************
*
* MODULE NAME: 	read_raw
*
*     PURPOSE:
*
*       INPUT:
*	fid		file descriptor pointing to the stream in
*			which the raw floating point data is located
*	points		returns the number of points found in the raw
*			floating point data file
*	mach_type 	the machine dependancy type (IEEE, NSORDER, DECORDER)
*		        if  = -1 then no conversion is attempted.
*
*      OUTPUT:
*
*	data		returns the data points found in the raw file
*
* CALLED FROM: main
*
* ROUTINES CALLED:
*
**************************************************************/

#define ALLOCSIZE 50000

float	*read_raw(fid, offset, points, type, mach_type)

int 	fid, type, offset;
int 	*points, mach_type;
{
	int	num_bytes, num, size;
	char	*data;
	float	*temp, *convert_raw_data();

	/* allocate memory space for data */
	size =  ALLOCSIZE;
	data = (char *) malloc ((unsigned int) size);

	/* read data and determine number of points */
	num_bytes = 0;

	do
	{
	   if (num_bytes == size)
	   {
	      size += ALLOCSIZE;
	      if (!(data = (char *) realloc(data, (unsigned) size)))
	      {
	         (void) fprintf(stderr,"Not enough memory!  Tried to malloc %d \
bytes.", size);
	         return (NULL);
	      }
	   }

	   if ((num = block_read(fid, (char *) (data + num_bytes),
			(size - num_bytes))) > 0)
	   {
	      num_bytes += num;
	   }
	} while (num > 0);

	if (offset > 0)
	{
	   num_bytes -= offset;
	   temp = convert_raw_data(&data[offset], type, num_bytes, points, mach_type);
	}
	else
	   temp = convert_raw_data(data, type, num_bytes, points, mach_type);

	free(data);
	return(temp);
}



float *convert_raw_data(data, type, num_bytes, num_points, mach_type)

char	*data;
int	type, num_bytes, *num_points, mach_type;
{
	int	i, size, unit_size, source_machine, current_machine;
	float	*temp;

	short	*sptr, *s;
	int	*iptr, *l;
	float	*fptr, *f;
	unsigned char *bptr, *cptr, c;

	switch (type)
	{
	   case VFF_TYP_BIT:
		bptr = (unsigned char *) data;
		unit_size = -1;
		size = (int) (num_bytes * 8);
		break;

	   case VFF_TYP_1_BYTE:
		cptr = (unsigned char *) data;
		unit_size = sizeof(char);
		size = (int) (num_bytes / unit_size);
		break;

	   case VFF_TYP_2_BYTE:
		sptr = (short *) data;
		unit_size = sizeof(short);
		size = (int) (num_bytes / unit_size);
		break;

	   case VFF_TYP_4_BYTE:
		iptr = (int *) data;
		unit_size = sizeof(int);
		size = (int) (num_bytes / unit_size);
		break;

	   case VFF_TYP_FLOAT:
	   case VFF_TYP_COMPLEX:
		fptr = (float *) data;
		unit_size = sizeof(float);
		size = (int) (num_bytes / unit_size);
		break;
	}
	*num_points = size;

	/*
	 *  Round down to the nearest float.  Warn the user if the last point
	 *  is not a complete float.
	 */
	if (((num_bytes % unit_size) != 0) && (unit_size > 1))
	{
	   (void) fprintf(stderr,"lraw2viff: Warning!  Last point in the file\
 was an incomplete.\n(%d out of %d bytes found)\n", (num_bytes % unit_size),
 unit_size);
	}

	if (mach_type != -1)
	{
	   current_machine = machtype(NULL);
           source_machine = mach_type;
           if (current_machine != source_machine)
             {
               switch(type)
                 {
                   case VFF_TYP_BIT:
                     break;
                   case VFF_TYP_1_BYTE:
                     break;
                   case VFF_TYP_2_BYTE:
                     s = (short *)data;
                     if (current_machine == VFF_DEP_IEEEORDER &&
                         source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size; i++) { dectoieees(s); s++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size; i++) { ieeetodecs(s); s++; }
                       }
                     else if (current_machine == VFF_DEP_IEEEORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size; i++) { nstoieees(s); s++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size; i++) { ieeetonss(s); s++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size; i++) { dectonss(s); s++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size; i++) { nstodecs(s); s++; }
                       }
                     else
                       {
                         fprintf(stderr,"\nread_raw: Unknown machine type!\n");
		         free(data);
                         return(NULL);
                       }
                     break;
                   case VFF_TYP_4_BYTE:
                     l = (int *)data;
                     if (current_machine == VFF_DEP_IEEEORDER &&
                         source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size; i++) { dectoieeel(l); l++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size; i++) { ieeetodecl(l); l++; }
                       }
                     else if (current_machine == VFF_DEP_IEEEORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size; i++) { nstoieeel(l); l++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size; i++) { ieeetonsl(l); l++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size; i++) { dectonsl(l); l++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size; i++) { nstodecl(l); l++; }
                       }
                     else
                       {
                         fprintf(stderr,"\nread_raw: Unknown machine type!\n");
		         free(data);
                         return(NULL);
                       }
                     break;
                   case VFF_TYP_DOUBLE:
                     fprintf(stderr,"\nread_raw: Unknown machine type!\n");
                     free(data);
                     return(NULL);
                     break;
                   case VFF_TYP_FLOAT:
                     f = (float *)data;
                     if (current_machine == VFF_DEP_IEEEORDER &&
                         source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size; i++) { dectoieeef(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size; i++) { ieeetodecf(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_IEEEORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size; i++) { nstoieeef(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size; i++) { ieeetonsf(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size; i++) { dectonsf(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size; i++) { nstodecf(f); f++; }
                       }
                     else
                       {
                         fprintf(stderr,"\nread_raw: Unknown machine type!\n");
		         free(data);
                         return(NULL);
                       }
                     break;
                   case VFF_TYP_COMPLEX:
                     f = (float *)data;
                     if (current_machine == VFF_DEP_IEEEORDER &&
                         source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size*2; i++) { dectoieeef(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size*2; i++) { ieeetodecf(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_IEEEORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size*2; i++) { nstoieeef(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_IEEEORDER)
                       {
                         for (i=0; i<size*2; i++) { ieeetonsf(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_NSORDER &&
                              source_machine  == VFF_DEP_DECORDER)
                       {
                         for (i=0; i<size*2; i++) { dectonsf(f); f++; }
                       }
                     else if (current_machine == VFF_DEP_DECORDER &&
                              source_machine  == VFF_DEP_NSORDER)
                       {
                         for (i=0; i<size*2; i++) { nstodecf(f); f++; }
                       }
                     else
                       {
                         fprintf(stderr,"\nread_raw: Unknown machine type!\n");
		         free(data);
                         return(NULL);
                       }
                     break;
                   default:
                     free(data);
                     return(NULL);
                     break;
                 }
            }
       }


	/*
	 *  Finished reading the data points from the file.  Try to malloc
	 *  the final array with the exact number of points.  If we don't
	 *  have enough size then we return data, otherwise we copy data
	 *  to temp, free data, and return temp as the points in the file.
	 */
	if (!(temp = (float *) malloc((unsigned int) size * sizeof(float))))
	{
	   return(NULL);
	}


	switch (type)
	{
	   case VFF_TYP_BIT:
		for (i = 0; i < size; i++)
		{
		    c = (1 << (i % 8));
		    temp[i] = (float) (c & (*bptr));

		    if ((i % 8) == 7)
		       bptr++;
		}
		break;

	   case VFF_TYP_1_BYTE:
		for (i = 0; i < size; i++)
		    temp[i] = (float) cptr[i];
		break;

	   case VFF_TYP_2_BYTE:
		for (i = 0; i < size; i++)
		    temp[i] = (float) sptr[i];
		break;

	   case VFF_TYP_4_BYTE:
		for (i = 0; i < size; i++)
		    temp[i] = (float) iptr[i];
		break;

	   case VFF_TYP_FLOAT:
	   case VFF_TYP_COMPLEX:
		for (i = 0; i < size; i++)
		    temp[i] = (float) fptr[i];
		break;
	}
	return(temp);
}



/**************************************************************
*
* MODULE NAME: 	write_raw
*
*     PURPOSE:  This routine writes a raw data array to the
*		desired file, specified by fid.
*
*		Note:  This routine is really not necessary since
*		       all it does is write the data to the fid.
*		       But it is hoped that others will use this
*		       routine so that at a later time there will
*		       be only one routine to change.  For example,
*		       if data caching is to be added to khoros then
*		       this routine would be converted to write data
*		       to shared memory or sockets, not just file
*		       descriptors.
*
*
*       INPUT:
*
*	fid		file descriptor pointing to the stream in
*			which the raw floating point data is located
*
*	data		the raw data array to written to fid
*
*	num_bytes	number of bytes found in the raw data array
*
*      OUTPUT:	Outputs the raw data to the desired file.
*
* CALLED FROM: main
*
* ROUTINES CALLED:
*
**************************************************************/

int	write_raw(fid, data, num_bytes)

int	fid, num_bytes;
char	*data;
{
	int	num;

	num = write(fid, data, num_bytes);
	if (num != num_bytes)
	{
	   (void) fprintf(stderr, "\nwrite_raw:\n");
	   (void) fprintf(stderr, "Write failed!  Only able to write %d out of\
 %d bytes to disk.\n");
	   return(0);
	}
	return(1);
}
