/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.SimpleNode;

public class ASTLiteral
extends SimpleNode {
    public Object value;

    ASTLiteral(int n) {
        super(n);
    }

    public void charSetup(String string) {
        char c = string.charAt(0);
        if (c == '\\') {
            c = string.charAt(1);
            c = Character.isDigit(c) ? (char)Integer.parseInt(string.substring(1), 8) : this.getEscapeChar(c);
        }
        this.value = new Primitive(new Character(c));
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        return this.value;
    }

    private char getEscapeChar(char c) {
        switch (c) {
            case 'b': {
                c = (char)8;
                break;
            }
            case 't': {
                c = (char)9;
                break;
            }
            case 'n': {
                c = (char)10;
                break;
            }
            case 'f': {
                c = (char)12;
                break;
            }
            case 'r': {
                c = (char)13;
                break;
            }
        }
        return c;
    }

    public void stringSetup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                if (Character.isDigit(c = string.charAt(++n))) {
                    int n2 = n;
                    while (n2 < n + 2) {
                        if (!Character.isDigit(string.charAt(n2 + 1))) break;
                        ++n2;
                    }
                    c = (char)Integer.parseInt(string.substring(n, n2 + 1), 8);
                    n = n2;
                } else {
                    c = this.getEscapeChar(c);
                }
            }
            stringBuffer.append(c);
            ++n;
        }
        this.value = stringBuffer.toString();
    }
}

