/*
   This file is part of Challenger
   Copyright (C) 2025 Taler Systems SA

   Challenger is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   Challenger is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   Challenger; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file challengerdb/pg_address_get.c
 * @brief Implementation of the address_get function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_address_get.h"
#include "pg_helper.h"

enum GNUNET_DB_QueryStatus
CH_PG_address_get (void *cls,
                   const struct CHALLENGER_ValidationNonceP *nonce,
                   json_t **address)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_auto_from_type (nonce),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_allow_null (
      TALER_PQ_result_spec_json ("address",
                                 address),
      NULL),
    GNUNET_PQ_result_spec_end
  };

  *address = NULL;
  PREPARE (pg,
           "address_get",
           "SELECT "
           "  address"
           " FROM validations"
           " WHERE nonce=$1");
  return GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                   "address_get",
                                                   params,
                                                   rs);
}
