#ifndef _MAXON_49HX_H_
#define _MAXON_49HX_H_

#include <qwidget.h>

#include <VrTypes.h>

template<class oType> class VrAR5000Source;
template<class iType> class VrComplexFIRfilter;
template<class Type> class VrSquelch;
template<class iType, class oType> class VrRealFIRfilter;
template<class oType> class VrQuadratureDemod;
template<class iType> class VrAudioSink;

class QwtKnob;
class QButtonGroup;
class Tuner;

class Maxon49HX : public QWidget
{
  Q_OBJECT

  VrAR5000Source<char> *source;
  VrComplexFIRfilter<char> *chanFilter;
  VrSquelch<complex> *squelch;
  VrQuadratureDemod<float> *demod;
  VrRealFIRfilter<float, short> *ifFilter;
  VrAudioSink<short> *audio;

  QButtonGroup *buttons;
  QwtKnob *vol;
  QwtKnob *sq;
  Tuner *tuner;

  bool on;

public:
  Maxon49HX(VrAR5000Source<char> *source,
	    QWidget *parent = 0, const char *name = 0);
  ~Maxon49HX();

  virtual QSize sizeHint() const;
  
private slots:
  void buttonClicked(int id);
  void run();

public slots:
  void setChannel(int channel);
  void setVolume(double volume);
  void setSquelch(double thresh);
};

#endif
