/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <atsc_types.h>
#include <atsc_pnXXX.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>


// mapping of binary values to 1 of 8 levels
static const int bin_map[2] = { 1, 6 };

void 
build_field_sync_seg (atsc_data_segment &seg,
		      int which,				// 1 or 2
		      const atsc_data_segment &prev)
{
  int	i = 0;
  
  if (which == 1)
    seg.pli.set_field_sync1 ();
  else
    seg.pli.set_field_sync2 ();
  
  seg.data[i++] = bin_map[1];	// magic sync pattern
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];

  for (int j = 0; j < 511; j++)
    seg.data[i++] = bin_map[atsc_pn511[j]];

  for (int j = 0; j < 63; j++)
    seg.data[i++] = bin_map[atsc_pn63[j]];
  
  int toggle = which == 1 ? 0 : 1;	// useless differentiation btwn field 1 and 2
  for (int j = 0; j < 63; j++)
    seg.data[i++] = bin_map[toggle ^ atsc_pn63[j]];

  for (int j = 0; j < 63; j++)
    seg.data[i++] = bin_map[atsc_pn63[j]];
  
  // 24 bits that id's this as 8-VSB

  seg.data[i++] = bin_map[0];		// VSB8 mode identifier
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[0];

  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[0];

  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];

  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[1];

  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];

  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];
  seg.data[i++] = bin_map[0];


  // 92 more bits...
  
  for (int j = 0; j < 92; j++)
    seg.data[i++] = bin_map[atsc_pn63[j % 63]];
  

  // precode, using the last 12 symbols of the previous segment

  for (int j = 0; j < 12; j++){
    seg.data[i] = prev.data[i];
    i++;
  }

  assert (i == ATSC_DATA_SEGMENT_LENGTH);
}

void 
build_random_seg (atsc_data_segment &seg)
{
  int	i = 0;
  
  seg.data[i++] = bin_map[1];	// magic sync pattern
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[0];
  seg.data[i++] = bin_map[1];

  for (; i < ATSC_DATA_SEGMENT_LENGTH; i++)
    seg.data[i] = (random () >> 4) & 0x7;
}
  
void
write_seg (const atsc_data_segment &seg)
{
  //  if (fwrite (seg.data, sizeof (seg.data), 1, stdout) != 1){
  if (fwrite (&seg, sizeof (seg), 1, stdout) != 1){
    perror ("fwrite");
    exit (1);
  }
}

void
usage (char *name)
{
  fprintf (stderr, "usage: %s [-F]\n", name);
  exit (1);
}

int 
main (int argc, char **argv)
{
  atsc_data_segment	seg;
  atsc_data_segment	last_seg;
  int			i;
  int			c;

  bool field_syncs_only_p = false;
  
  while ((c = getopt (argc, argv, "F")) != EOF){
    switch (c){
    case 'F':	// field syncs only
      field_syncs_only_p = true;
      break;
    default:
      usage (argv[0]);
    }
  }

  
  srandom (0);	// we want the same sequence each time

  memset (&last_seg, 0, sizeof (last_seg));

  if (field_syncs_only_p){
    for (i = 0; i < 313; i++){
      build_field_sync_seg (seg, 1, last_seg);
      write_seg (seg);
      last_seg = seg;

      build_field_sync_seg (seg, 2, last_seg);
      write_seg (seg);
      last_seg = seg;
    }
  }

  else {
    build_field_sync_seg (seg, 1, last_seg);
    write_seg (seg);
    last_seg = seg;

    for (i = 0; i < 312; i++){
      build_random_seg (seg);
      seg.pli.set_regular_seg (false, i);
      write_seg (seg);
      last_seg = seg;
    }

    build_field_sync_seg (seg, 2, last_seg);
    write_seg (seg);
    last_seg = seg;

    for (i = 0; i < 312; i++){
      build_random_seg (seg);
      seg.pli.set_regular_seg (true, i);
      write_seg (seg);
      last_seg = seg;
    }
  }

  return 0;
}
