/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: common routine	 	      		*/
/*		file	: rps_token.h		       			*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/

/* define keyword for configurion */

#define MAX_NUM_CONFIG_CHARACTER	32

#define T_CONFIG_UNKNOWN		0
#define	T_CONFIG_ROUTER			1
#define	T_CONFIG_PROTOCOL		2
#define	T_CONFIG_INTERFACE		3
#define T_CONFIG_NEIGHBOR		4
#define T_CONFIG_HOLDTIME		5
#define T_CONFIG_VERSION		6
#define T_CONFIG_HELLO			7
#define	T_CONFIG_ROUTERDEAD		8
#define T_CONFIG_PRIORITY		9
#define T_CONFIG_STUB			10
#define T_CONFIG_STUB_COST		11
#define T_CONFIG_VIRTUAL		12
#define T_CONFIG_ROUTERTYPE		13
#define T_CONFIG_AUTHTYPE		14
#define T_CONFIG_AUTHKEY		15
#define T_CONFIG_MULTICAST		16

#define T_AUTHTYPE_NONE			0
#define T_AUTHTYPE_SIMPLE		1

#define T_PROTO_UNKNOWN			0
#define T_PROTO_BGP			1
#define T_PROTO_OSPF			2
#define T_PROTO_ICMP			3
#define T_PROTO_IP			4

#define T_ERRCONF_UNKNOWN		0
#define T_ERRCONF_ROUTER        	1
#define T_ERRCONF_PROTOCOL		2
#define T_ERRCONF_INTERFACE		3
#define T_ERRCONF_VALUE			4
#define T_ERRCONF_MISSING		5

/* define keyword for network case */

#define MAX_NUM_CASE_CHARACTER		32

#define T_CASE_UNKNOWN			0
#define T_CASE_AS			1
#define T_CASE_AREA			2
#define T_CASE_NETWORK			3
#define T_CASE_MASK			4
#define T_CASE_ROUTER			5
#define T_CASE_INTERFACE		6
#define T_CASE_COST			7

#define T_ERRCASE_UNKNOWN		0
#define T_ERRCASE_ROUTER      		1
#define T_ERRCASE_MISSING		2

/* define keyword for sequence command */

#define MAX_NUM_CMD_CHARACTER		32

#define T_CMD_UNKNOWN			0
#define T_CMD_START			1
#define T_CMD_END			2
#define T_CMD_ROUTERUP			3
#define T_CMD_ROUTERDOWN		4
#define T_CMD_INTFUP			5
#define T_CMD_INTFDOWN			6
#define T_CMD_MSGSEND			7
#define T_CMD_MSGRECV			8
#define T_CMD_BGPOPENSEND		9
#define T_CMD_BGPOPENRECV		10
#define T_CMD_BGPKEEPSEND		11
#define T_CMD_BGPKEEPRECV		12
#define T_CMD_BGPUPDATESEND		13
#define T_CMD_BGPUPDATERECV		14
#define T_CMD_BGPNOTIFYSEND		15
#define T_CMD_BGPNOTIFYRECV		16
#define T_CMD_OSPFHELLOSEND		17
#define T_CMD_OSPFHELLORECV		18
#define T_CMD_OSPFDBSEND		19
#define T_CMD_OSPFDBRECV		20
#define T_CMD_OSPFREQSEND		21
#define T_CMD_OSPFREQRECV		22
#define T_CMD_OSPFUPDATESEND		23
#define T_CMD_OSPFUPDATERECV		24
#define T_CMD_OSPFACKSEND		25
#define T_CMD_OSPFACKRECV		26
#define T_CMD_TABLEMAKE			27
#define T_CMD_ROUTEADD			28
#define T_CMD_ROUTEDELETE		29
#define T_CMD_CASELOAD			30
#define T_CMD_CONFIGLOAD		31

#define T_CMD_ASLIST_DUMP		32
#define T_CMD_RTLIST_DUMP		33
#define T_CMD_LINK_DUMP			34
#define T_CMD_LSDB_DUMP			35
#define T_CMD_LS_RT_DUMP		36
#define T_CMD_LS_NET_DUMP		37
#define T_CMD_LS_SUM_NET_DUMP		38
#define T_CMD_LS_SUM_ASBR_DUMP		39
#define T_CMD_LS_ASE_DUMP		40
#define T_CMD_ROUTER_DUMP		41

#define T_CMD_TRACE_ON			42
#define T_CMD_TRACE_OFF			43

#define T_CMD_WAIT			44

#define T_CMD_HOP_UP			45
#define T_CMD_HOP_DOWN			46

#define T_CMD_DISPLAY_ON		47
#define T_CMD_DISPLAY_OFF		48

#define T_CMD_ROUTE_FLUSH		49
#define T_CMD_TABLE_LOAD                50

#define T_CMD_NET_UP                    51
#define T_CMD_NET_DOWN                  52
#define T_CMD_AREA_UP                   53
#define T_CMD_AREA_DOWN                 54
#define T_CMD_AS_UP                     55
#define T_CMD_AS_DOWN                   56
#define T_CMD_EXEC			57

#define T_RIGHT_PUNC			')'
#define T_LEFT_PUNC			'('

#define ARG_SYMBOL			','

#define NOCOMMAND			99

#define T_MSG_BGP_UNKNOWN      		0
#define T_MSG_BGP_OPEN			1
#define T_MSG_BGP_KEEPALIVE	       	2
#define T_MSG_BGP_UPDATE	      	3
#define T_MSG_BGP_NOTIFY		4

#define T_MSG_OSPF_UNKNOWN	       	0
#define T_MSG_OSPF_HELLO		1
#define T_MSG_OSPF_DATABASE	       	2
#define T_MSG_OSPF_REQUEST	       	3
#define T_MSG_OSPF_UPDATE	       	4
#define T_MSG_OSPF_ACK			5

#define T_MSG_ICMP_ECHORPLY		0
#define T_MSG_ICMP_UNREACH		3
#define T_MSG_ICMP_SRCQUENCH		4
#define T_MSG_ICMP_REDIRECT		5
#define T_MSG_ICMP_ECHO			8
#define T_MSG_ICMP_TIMEEXCEED		11
#define T_MSG_ICMP_PRAMPROB		12
#define T_MSG_ICMP_TSTAMP		13
#define T_MSG_ICMP_TSTAMPREPLY		14

/* define keyword for syntax */

#define T_CLAUSE_BEGIN			"{"
#define T_CLAUSE_END			"}"
#define T_STATEMENT_END			";"

#define T_ERROR_NOTHING			0
#define T_ERROR_SYNTAX			1
#define T_ERROR_BEGIN_CLAUSE		2
#define T_ERROR_END_CLAUSE		3
#define T_ERROR_END_STATEMENT		4
#define T_ERROR_END_OF_FILE		5

#define ERR_SYNTAX              T_ERROR_SYNTAX,common_error
#define ERR_BEGIN_CLAUSE        T_ERROR_BEGIN_CLAUSE,common_error
#define ERR_END_CLAUSE          T_ERROR_END_CLAUSE,common_error
#define ERR_END_STATEMENT       T_ERROR_END_STATEMENT,common_error
#define ERR_END_OF_FILE         T_ERROR_END_OF_FILE ,common_error


struct	token {
	int    no;
	char  *name;
};

  
#define	CR				0x0a
#define SPACE   		0x20
#define TAB				'\t'
#define COMMENT			'#'


#define TERM_CHECK(c)	(c != CR && c != SPACE && c != TAB ? 1 : 0)
/*#define SYNTAX_SYMBOL_CHECK(c)	(c != T_CLAUSE_BEGIN && c != T_CLAUSE_END && c != T_STATEMENT_END ? 1 : 0)
*/
#define SYNTAX_SYMBOL_CHECK(c)	(c != '{' && c != '}' && c != ';' ? 1 : 0)
#define READ_SKIP(fp,term_sym) while(getc(fp) != term_sym)

#define GET_TOKEN_EOF(fp,token) \
   ( get_token(fp,token) == EOF )

#define GET_TOKEN(fp,token,msglist) \
	{ \
   		if(GET_TOKEN_EOF(fp,token)) { \
        		error_print(msglist); \
        		return 0; \
   		}\
	 }

#define GET_CLAUSE_BEGIN(fp,token) \
   ( get_token(fp,token) != EOF && !strcmp(token,T_CLAUSE_BEGIN) )

#define GET_CLAUSE_END(fp,token) \
   ( get_token(fp,token) != EOF && !strcmp(token,T_CLAUSE_END) )  

#define GET_STATEMENT_END(fp,token) \
  ( get_token(fp,token) != EOF && !strcmp(token,T_STATEMENT_END) )

#define BEGIN_CLAUSE(fp,token,msglist) \
{ \
   if(!GET_CLAUSE_BEGIN(fp,token)) { \
       error_print(msglist); \
       return 0; \
   }\
 }
      
#define END_CLAUSE(fp,token,msglist) \
{ \
  if(!GET_CLAUSE_END(fp,token)) { \
       error_print(msglist); \
       return 0; \
   }\
 }

#define END_STATEMENT(fp,token,msglist) \
{ \
   if(!GET_STATEMENT_END(fp,token)) { \
       error_print(msglist); \
       return 0; \
   } \
 }











