/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: main routine				       	*/
/*		file	: rps_cmd.c	       				*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*	1996.6.20       Add new command  				*/
/*                          networkUP/DOWN, areaUP/DOWN, asUP/DOWN      */
/************************************************************************/
static char copyright[]=
  "@(#)Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,Ltd.\n All rights researved.\n";

#ifdef VXWORKS

#include "stdioLib.h"
#include "types.h"
#include "ioLib.h"

#else

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>

#endif

#include "rps_token.h"

#define LOG_FILE	"rps_run.log"
#define EXECTIMEOUT	10

struct token cmd_token[] =
{
    {T_CMD_UNKNOWN,		"unknown-command"},
    {T_CMD_START,		"start"},
    {T_CMD_END,			"end"},
    {T_CMD_ROUTERUP,		"routerUP"},
    {T_CMD_ROUTERDOWN,	        "routerDOWN"},
    {T_CMD_INTFUP,		"interfaceUP"},
    {T_CMD_INTFDOWN,		"interfaceDOWN"},
    {T_CMD_MSGSEND,		"messageSEND"},
    {T_CMD_MSGRECV,		"messageRECV"},
    {T_CMD_BGPOPENSEND,		"bgpOpenSEND"},
    {T_CMD_BGPOPENRECV,		"bgpOpenRECV"},
    {T_CMD_BGPKEEPSEND,		"bgpKeepAliveSEND"},
    {T_CMD_BGPKEEPRECV,		"bgpKeepAliveRECV"},
    {T_CMD_BGPUPDATESEND,	"bgpUpdateSEND"},
    {T_CMD_BGPUPDATERECV,	"bgpUpdateRECV"},
    {T_CMD_BGPNOTIFYSEND,	"bgpNotifySEND"},
    {T_CMD_BGPNOTIFYRECV,	"bgpNotifyRECV"},
    {T_CMD_OSPFHELLOSEND,	"ospfHelloSEND"},
    {T_CMD_OSPFHELLORECV,	"ospfHelloRECV"},
    {T_CMD_OSPFDBSEND,		"ospfDatabaseSEND"},
    {T_CMD_OSPFDBRECV,		"ospfDatabaseRECV"},
    {T_CMD_OSPFREQSEND,		"ospfRequestSEND"},
    {T_CMD_OSPFREQRECV,		"ospfRequestRECV"},
    {T_CMD_OSPFUPDATESEND,	"ospfUpdateSEND"},
    {T_CMD_OSPFUPDATERECV,	"ospfUpdateRECV"},
    {T_CMD_OSPFACKSEND,		"ospfAckSEND"},
    {T_CMD_OSPFACKRECV,		"ospfAckRECV"},
    {T_CMD_TABLEMAKE,		"tableMAKE"},
    {T_CMD_ROUTEADD,		"routeADD"},
    {T_CMD_ROUTEDELETE,		"routeDELETE"},
    {T_CMD_CASELOAD,		"caseLOAD"},
    {T_CMD_CONFIGLOAD,		"configLOAD"},
    {T_CMD_ASLIST_DUMP,		"aslistDUMP"},
    {T_CMD_RTLIST_DUMP,		"rtlistDUMP"},
    {T_CMD_LINK_DUMP,		"linkDUMP"},
    {T_CMD_LSDB_DUMP,		"lsdbDUMP"},
    {T_CMD_LS_RT_DUMP,		"lsRtDUMP"},
    {T_CMD_LS_NET_DUMP,		"lsNetDUMP"},
    {T_CMD_LS_SUM_NET_DUMP,	"lsSumnetDUMP"},
    {T_CMD_LS_SUM_ASBR_DUMP,	"lsAsbrDUMP"},
    {T_CMD_LS_ASE_DUMP,		"lsAseDUMP"},
    {T_CMD_ROUTER_DUMP,		"routerDUMP"},
    {T_CMD_TRACE_ON,		"traceON"},
    {T_CMD_TRACE_OFF,		"traceOFF"},
    {T_CMD_WAIT,		"wait"},
    {T_CMD_HOP_UP,		"hopUP"},
    {T_CMD_HOP_DOWN,		"hopDOWN"},
    {T_CMD_DISPLAY_ON,		"displayON"},
    {T_CMD_DISPLAY_OFF,		"displayOFF"},
    {T_CMD_ROUTE_FLUSH,		"routeFLUSH"},
    {T_CMD_TABLE_LOAD,          "tableLOAD"},
    {T_CMD_NET_UP,              "networkUP"},
    {T_CMD_NET_DOWN,            "networkDOWN"},
    {T_CMD_AREA_UP,             "areaUP"},
    {T_CMD_AREA_DOWN,           "areaDOWN"},
    {T_CMD_AS_UP,               "asUP"},
    {T_CMD_AS_DOWN,             "asDOWN"},
    {T_CMD_EXEC,                "exec"},
    {NULL}
};

struct token bgp_token[] =
{
    {T_MSG_BGP_UNKNOWN,		"unknown"},
    {T_MSG_BGP_OPEN,		"OPEN"},
    {T_MSG_BGP_KEEPALIVE,	"KEEPALIVE"},
    {T_MSG_BGP_UPDATE,		"UPDATE"},
    {T_MSG_BGP_NOTIFY,		"NOTIFICATION"},
    {NULL}
};

struct token ospf_token[] =
{
    {T_MSG_OSPF_UNKNOWN,	"unknown"},
    {T_MSG_OSPF_HELLO,		"HELLO"},
    {T_MSG_OSPF_DATABASE,	"DATABASE"},
    {T_MSG_OSPF_REQUEST,	"REQUEST"},
    {T_MSG_OSPF_UPDATE,		"UPDATE"},
    {T_MSG_OSPF_ACK,		"ACK"},
    {NULL}
};

struct token icmp_token[] =
{
    {T_MSG_ICMP_ECHORPLY,       "ECHOREPLY"},
    {T_MSG_ICMP_SRCQUENCH,	"SRCQUENCH"},
    {T_MSG_ICMP_UNREACH,	"UNREACH"},
    {T_MSG_ICMP_REDIRECT,	"REDIRECT"},
    {T_MSG_ICMP_ECHO,		"ECHO"},
    {T_MSG_ICMP_TIMEEXCEED,	"TIMEEXCEED"},
    {T_MSG_ICMP_PRAMPROB,	"PRAMPROB"},
    {T_MSG_ICMP_TSTAMP,		"TIMESTAMP"},
    {T_MSG_ICMP_TSTAMPREPLY,	"TIMESTAMPREPLY"},
    {NULL}
};

struct token cmd_proto_token[] =
{
    {T_PROTO_UNKNOWN,   "unknown"},
    {T_PROTO_BGP,	"BGP"},
    {T_PROTO_OSPF,	"OSPF"},
    {T_PROTO_ICMP,	"ICMP"},
    {T_PROTO_IP,	"IP"},
    {NULL}
};

static int got_alarm;

int get_arg();
void Start();
void End();
void Router_UP();
void Router_DOWN();
void Interface_UP();
void Interface_DOWN();
void Message_SEND();
void Message_RECV();
void Table_Make();

char *get_cmd_file();
char *time_to_char();
char *token_arg();
void LS_rt_dump();
void LS_net_dump();
void LS_sum_net_dump();
void LS_sum_asbr_dump();
void LS_ase_dump();
void Router_dump();
void Trace_on();
void Trace_off();
void Wait();
void Hop_Up();
void Hop_Down();
void Display_On();
void Display_Off();
void Route_Flush();
void Table_Load();
void Network_Up();
void Network_Down();
void Area_Up();
void Area_Down();
void As_Up();
void As_Down();
void Exec();
static void alarm_handler();



/*

  run_command

*/
int run_command(cmd,fp)
char *cmd;
FILE *fp;
{
    char arg[32];
    int rt;

    switch(rt=token_type(cmd_token,cmd)) {
    case T_CMD_START	: Start(fp);
	break;
    case T_CMD_END		: End();
	    			  break;
    case T_CMD_ROUTERUP	: Router_UP(fp);
	    			  break;
    case T_CMD_ROUTERDOWN	: Router_DOWN(fp);
	    			  break;
    case T_CMD_INTFUP	: Interface_UP(fp);
	    			  break;
    case T_CMD_INTFDOWN	: Interface_DOWN(fp);
      	    			  break;
    case T_CMD_MSGSEND	: Message_SEND(fp);
	    			  break;
    case T_CMD_MSGRECV	: Message_RECV(fp);
	    			  break;
    case T_CMD_BGPOPENSEND	: rt = get_arg(fp,arg);
	    			  printf("bgpOpenSEND : %s\n",arg);
	    			  break;
    case T_CMD_BGPOPENRECV	: rt = get_arg(fp,arg);
	    			  printf("bgpOpenRECV : %s\n",arg);
	    			  break;
    case T_CMD_BGPKEEPSEND	: rt = get_arg(fp,arg);
	    			  printf("bgpKeepAliveSEND : %s\n",arg);
	    			  break;
    case T_CMD_BGPKEEPRECV	: rt = get_arg(fp,arg);
	    			  printf("bgpKeepAliveRECV : %s\n",arg);
	    			  break;
    case T_CMD_BGPUPDATESEND  : rt = get_arg(fp,arg);
	    			  printf("bgpUpdateSEND : %s\n",arg);
	    			  break;
    case T_CMD_BGPUPDATERECV	: rt = get_arg(fp,arg);
	    			  printf("bgpUpdateRECV : %s\n",arg);
	    			  break;
    case T_CMD_BGPNOTIFYSEND  : rt = get_arg(fp,arg);
	    			  printf("bgpNotifySEND : %s\n",arg);
	    			  break;
    case T_CMD_BGPNOTIFYRECV	: rt = get_arg(fp,arg);
	    			  printf("bgpNotifyRECV : %s\n",arg);
	    			  break;
    case T_CMD_OSPFHELLOSEND  : rt = get_arg(fp,arg);
	    			  printf("ospfHelloSEND : %s\n",arg);
	    			  break;
    case T_CMD_OSPFHELLORECV	: rt = get_arg(fp,arg);
	    			  printf("osfpHelloRECV : %s\n",arg);
	    			  break;
    case T_CMD_OSPFDBSEND  : rt = get_arg(fp,arg);
	    			  printf("ospfDatabaseSEND : %s\n",arg);
	    			  break;
    case T_CMD_OSPFDBRECV	: rt = get_arg(fp,arg);
	    			  printf("osfpDatabaseRECV : %s\n",arg);
	    			  break;
    case T_CMD_OSPFREQSEND  : rt = get_arg(fp,arg);
	    			  printf("ospfRequestSEND : %s\n",arg);
	    			  break;
    case T_CMD_OSPFREQRECV	: rt = get_arg(fp,arg);
	    			  printf("osfpRequestRECV : %s\n",arg);
	    			  break;
    case T_CMD_OSPFUPDATESEND  : rt = get_arg(fp,arg);
	    			  printf("ospfUpdateSEND : %s\n",arg);
	    			  break;
    case T_CMD_OSPFUPDATERECV	: rt = get_arg(fp,arg);
	    			  printf("osfpUpdateRECV : %s\n",arg);
	    			  break;
    case T_CMD_OSPFACKSEND  : rt = get_arg(fp,arg);
	    			  printf("ospfAckSEND : %s\n",arg);
	    			  break;
    case T_CMD_OSPFACKRECV	: rt = get_arg(fp,arg);
	    			  printf("osfpAckRECV : %s\n",arg);
	    			  break;
    case T_CMD_TABLEMAKE	: Table_Make(fp);
	    			  break;
    case T_CMD_ROUTEADD	: rt = get_arg(fp,arg);
	    			  printf("routeADD : %s\n",arg);
	    			  break;
    case T_CMD_ROUTEDELETE	: rt = get_arg(fp,arg);
	    			  printf("routeDELETE : %s\n",arg);
	    			  break;
    case T_CMD_CASELOAD	: rt = get_arg(fp,arg);
	    			  printf("caseLOAD : %s\n",arg);
	    			  break;
    case T_CMD_CONFIGLOAD	: rt = get_arg(fp,arg);
	    			  printf("configLOAD : %s\n",arg);
	    			  break;
    case T_CMD_ASLIST_DUMP  : as_list_dump();
	    			  break;
    case T_CMD_RTLIST_DUMP  : rt_list_dump();
	    			  break;
    case T_CMD_LINK_DUMP    : link_list_dump();
	    			  break;
    case T_CMD_LSDB_DUMP 	: lsdb_list_dump();
	    break;
    case T_CMD_LS_RT_DUMP   : LS_rt_dump();
	    break;
    case T_CMD_LS_NET_DUMP   : LS_net_dump();
	    break;
    case T_CMD_LS_SUM_NET_DUMP   : LS_sum_net_dump();
	break;
    case T_CMD_LS_SUM_ASBR_DUMP   : LS_sum_asbr_dump();
	    break;
    case T_CMD_LS_ASE_DUMP   	: LS_ase_dump();
	    			  break; 
    case T_CMD_ROUTER_DUMP  	: Router_dump(fp);
	    			  break;
    case T_CMD_TRACE_ON 	: Trace_on(fp);
	    			  break;
    case T_CMD_TRACE_OFF 	: Trace_off(fp);
	    			  break;
    case T_CMD_WAIT		: Wait(fp);
				  break;
    case T_CMD_HOP_UP 		: Hop_Up(fp);
				  break;
    case T_CMD_HOP_DOWN        	: Hop_Down(fp);
				  break;
    case T_CMD_DISPLAY_ON       : Display_On(fp);
			  	  break;
    case T_CMD_DISPLAY_OFF      : Display_Off(fp);
			  	  break;
    case T_CMD_ROUTE_FLUSH      : Route_Flush(fp);
			          break;
    case T_CMD_TABLE_LOAD       : Table_Load(fp);
	                          break;
    case T_CMD_NET_UP           : Network_Up(fp);
	                          break;
    case T_CMD_NET_DOWN         : Network_Down(fp);
	                          break;
    case T_CMD_AREA_UP           : Area_Up(fp);
	                          break;
    case T_CMD_AREA_DOWN         : Area_Down(fp);
	                          break;
    case T_CMD_AS_UP           : As_Up(fp);
	                          break;
    case T_CMD_AS_DOWN         : As_Down(fp);
	                          break;
    case T_CMD_EXEC            : Exec(fp);
	                          break;
      	default			: rt = T_CMD_UNKNOWN;
	    			  break;
    }

    return rt;

}


/*

  start

*/
void Start(fp)
FILE *fp;
{
    char config_file[32];
    char case_file[32];
    char arg[32],*tmp;
    int rtn;
    FILE *log_fp;
    int run_time;
    int fd;
    
    tmp = arg;
    if((rtn = get_arg(fp,tmp)) != EOF) {
       
	strcpy(config_file,token_arg(&tmp,ARG_SYMBOL));
	strcpy(case_file,token_arg(&tmp,ARG_SYMBOL));

	case_load(case_file);
	config_load(config_file);
	protocol_init();
    }

#ifdef LOGGING
    if((log_fp = fopen(LOG_FILE,"a+")) == NULL)
	return;
    
    run_time = get_currnt_time();
    log_trace(log_fp," Rps Run start (%s,%s,%s)  at : %s"
	      ,get_cmd_file(),case_file,config_file,time_to_char(&run_time));

    fclose(log_fp);
#endif

}

/*

  End

*/
void End()
{
    FILE *log_fp;
    int end_time;
    
/*    all_rt_unreachable();
*/    time_term();
    protocol_term();
    all_router_down();
    net_free();
    config_free();

#ifdef LOGGING
    if((log_fp = fopen(LOG_FILE,"a+")) == NULL)
	return;

    end_time = get_currnt_time();
    log_trace(log_fp," Rps Run finish at : %s\n",time_to_char(&end_time));

    fclose(log_fp);
#endif
    
}

/*

  Router_UP

*/
void Router_UP(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long id;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	  router_up(id);
      }
	else
	  log_trace(stderr,"%d is not configure \n",id);
    }
}

/*

  Router_DOWN

*/
void Router_DOWN(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long id;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));	
	if(rt_conf_check(id))
	  router_down(id);
	else
	  log_trace(stderr,"%d is not configure \n",id);	  
    }
}

/*

  Interface_UP

*/
void Interface_UP(fp)
FILE *fp;
{
    char arg[32],*tmp;
    u_long rt_id;
    u_long rt_if;
    int rtn;

    tmp = arg;
    if((rtn = get_arg(fp,tmp)) != EOF) {
       	rt_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	rt_if = convert_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	
	if(rt_if_conf_check(rt_id,rt_if))
	  interface_up(rt_id,rt_if);
	else
	  log_trace(stderr,"%d %s is not configure\n",rt_id,inetaddr_to_char(rt_if));
    }
}

/*

  Interface_DOWN
  
*/
void Interface_DOWN(fp)
FILE *fp;
{
    char arg[32],*tmp;
    u_long rt_id;
    u_long rt_if;
    int rtn;
    
    tmp = arg;
    if((rtn = get_arg(fp,tmp)) != EOF) {
       	rt_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	rt_if = convert_inetaddr(token_arg(&tmp,ARG_SYMBOL));

	if(rt_if_conf_check(rt_id,rt_if))
	  interface_down(rt_id,rt_if);
	else
	  log_trace(stderr,"%d %d is not configure\n",rt_id,rt_if);
    }
}

/*

  Message_SEND()

*/
void Message_SEND(fp)
FILE *fp;
{
    char arg[64],*tmp;
    u_long rt_id;
    u_long rt_if;
    int protocol;
    int type;
    int rtn;
    int num,tmp_num;
    int interval;
    u_long dst;
    
    bzero(arg,sizeof(arg));
    tmp = arg;
    num = 1;
    interval = tmp_num = 0;
    if((rtn = get_arg(fp,tmp)) != NULL) {
       	rt_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	rt_if = convert_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	protocol = token_type(cmd_proto_token,token_arg(&tmp,ARG_SYMBOL));

	
	if(!rt_if_conf_check(rt_id,rt_if)) {
	    log_trace(stderr,"%d %d is not configure\n",rt_id,rt_if);
	    return;
	}
	
	switch(protocol) {
	case T_PROTO_BGP : type = token_type(bgp_token,token_arg(&tmp,ARG_SYMBOL));
	    		break;
	case T_PROTO_OSPF : type = token_type(ospf_token,token_arg(&tmp,ARG_SYMBOL));
	    		break;
	case T_PROTO_ICMP : type = token_type(icmp_token,token_arg(&tmp,ARG_SYMBOL));
	           	dst = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
			    break;
	    defautl :	return;
	    		break;
	}
	
	if(*tmp)
	  tmp_num = asc_to_int(token_arg(&tmp,ARG_SYMBOL));

	if(*tmp) {
	    if(tmp_num) num = tmp_num;
	    interval = asc_to_int(token_arg(&tmp,ARG_SYMBOL));
        }
	else {
	    if(tmp_num) num = tmp_num;
	}
	
/*	printf("num = %d, interval = %d\n",num,interval);*/
	switch(protocol) {
	case T_PROTO_BGP :
        case T_PROTO_OSPF :
	  	message_send(rt_id,rt_if,protocol,type,num,interval);
		break;
	case T_PROTO_ICMP :
	  message_send(rt_id,rt_if,protocol,type,dst,num,interval);
/*	  icmp_message_send(rt_id,type,rt_if,dst,num,interval);*/
		break;
	default : break;
	}
    }
}

/*

  Message_RECV

*/
void Message_RECV(fp)
FILE *fp;
{
    char arg[64],*tmp;
    u_long rt_id;
    u_long rt_if;
    int protocol;
    int type;
    int rtn;
    u_long dst;
    
    tmp = arg;
    if((rtn = get_arg(fp,tmp)) != NULL) {
       	rt_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	rt_if = convert_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	protocol = token_type(cmd_proto_token,token_arg(&tmp,ARG_SYMBOL));
	
	if(!rt_if_conf_check(rt_id,rt_if)) {
	    log_trace(stderr,"%d %d is not configure\n",rt_id,rt_if);
	    return;
	}

	switch(protocol) {
	case T_PROTO_BGP : type = token_type(bgp_token,token_arg(&tmp,ARG_SYMBOL));
	    		break;
	case T_PROTO_OSPF : type = token_type(ospf_token,token_arg(&tmp,ARG_SYMBOL));
	    		break;
	case T_PROTO_ICMP : type = token_type(icmp_token,token_arg(&tmp,ARG_SYMBOL));	    
	    dst = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));

/*			icmp_init(rt_id,rt_if);
	    		icmp_message_recv(rt_id,type,rt_if,dst);
	    		icmp_term(rt_id);*/
	    message_recv(rt_id,rt_if,protocol,type,dst);
	    return;
	defautl :	return;
	    		break;
	}
	
	message_recv(rt_id,rt_if,protocol,type);
    }
}


/*

  Table_Make

*/
void Table_Make(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
       	table_make(char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL)));
    }
}

/*

  Router_dump

*/
void Router_dump(fp)
FILE *fp;
{
    char arg[32],*tmp,dump_file[32];
    u_long id;
    int rtn;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	    strcpy(dump_file,token_arg(&tmp,ARG_SYMBOL));
	    router_dump(id,dump_file);
	}
	else
	  log_trace(stderr,"%d is not configure \n",id);	  
    }
}

/*

  Trace_on

*/
void Trace_on(fp)
FILE *fp;
{
    char arg[32],trace_file[32],*tmp;
    u_long id;
    int rtn;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
       	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	    strcpy(trace_file,token_arg(&tmp,ARG_SYMBOL));
	    router_trace_on(id,trace_file);
	}
	else
	  log_trace(stderr,"%d is not configure \n",id);	  
    }
}    

/*

  Trace_off

*/
void Trace_off(fp)
FILE *fp;
{
    char arg[32],*tmp;
    u_long id;
    int rtn;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
       	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	    router_trace_off(id);
	}
	else
	  log_trace(stderr,"%d is not configure \n",id);	  
    }
}    

/*

  wait

*/
void Wait(fp)
FILE *fp;
{
    char arg[32],*tmp;
    u_long rt_id;
    int rtn,interval;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
       	rt_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(rt_id)) {
	    interval = asc_to_int(token_arg(&tmp,ARG_SYMBOL));
	    router_wait(rt_id,interval);
	}
	else
	  log_trace(stderr,"%d is not configure \n",rt_id);	  
    }
}    

/*

  Hop_Up

*/
void Hop_Up(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long id;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(get_rt_list(id)) {
	  hop_up(id);
      }
	else
	  log_trace(stderr,"%d is not configure \n",id);
    }
}

/*

  Hop_Down

*/
void Hop_Down(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long id;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(get_rt_list(id)) {
	  hop_down(id);
      }
	else
	  log_trace(stderr,"%d is not configure \n",id);
    }
}

/*

  Display_On

*/
void Display_On(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long id;
    u_long rtif;
    int protocol;
    int type;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	rtif = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	protocol = token_type(cmd_proto_token,token_arg(&tmp,ARG_SYMBOL));
	type = token_type(ospf_token,token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	    display_on(id,rtif,protocol,type);
      }
	else
	  log_trace(stderr,"%d is not configure \n",id);
    }
}

/*

  Display_Off

*/
void Display_Off(fp)
FILE *fp;
{
    char arg[48],*tmp;
    int rtn;
    u_long id;
    u_long rtif;
    int protocol;
    int type;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	rtif = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	protocol = token_type(cmd_proto_token,token_arg(&tmp,ARG_SYMBOL));
	type = token_type(ospf_token,token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	    display_off(id,rtif,protocol,type);
	}
	else
	  log_trace(stderr,"%d is not configure \n",id);
    }
}


/*

  Route_Flush

*/
void Route_Flush(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long id;
    
    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
	if(rt_conf_check(id)) {
	  route_flush(id);
      }
	else
	  log_trace(stderr,"%d is not configure \n",id);
    }
}


/*

  Table_Load

*/
void Table_Load(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
       	rtable_load(token_arg(&tmp,ARG_SYMBOL));
    }
}

void Network_Up(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long net_addr;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	net_addr = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
       	network_up(net_addr);
    }
}

void Network_Down(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long net_addr;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	net_addr = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
       	network_down(net_addr);
    }
}

void Area_Up(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long area_id;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	area_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
       	area_up(area_id);
    }
}

void Area_Down(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long area_id;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	area_id = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
       	area_down(area_id);
    }
}

/*

  As_Up

*/
void As_Up(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long as_num;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	as_num = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
       	as_up(as_num);
    }
}

/*

  As_Down

*/
void As_Down(fp)
FILE *fp;
{
    char arg[32],*tmp;
    int rtn;
    u_long as_num;

    tmp = arg;
    if((rtn = get_arg(fp,arg)) != EOF) {
	as_num = char_to_inetaddr(token_arg(&tmp,ARG_SYMBOL));
       	as_down(as_num);
    }
}


/*
Exec a command.  This can be used when the adjacencies
are in FULL.  Wait EXECTIMEOUT for child to return.
*/

void
Exec(fp)
	FILE *fp;
{
	char arg[32];
	int r, st;
	struct sigaction act;

	arg[0] = 0;
	st = got_alarm = 0;

	act.sa_handler = alarm_handler;
	sigemptyset(&(act.sa_mask));
	act.sa_flags = 0;
	sigaction(SIGALRM, &act, NULL);

	if (((r = get_arg(fp, arg) != EOF)) && arg[0]) {
		switch (fork()) {
		case -1:
			fprintf(stderr, "EXEC %s FAILED... exiting.\n", arg);
			exit(1);
			break;
		case 0:
			/* child */
			if (execlp(arg, arg, (char *)NULL) < 0) {
				fprintf(stderr, "EXEC %s FAILED... exiting.\n", arg);
				exit(1);
			}
			break;
		default:
			/* parent */
			sigaction(SIGALRM, &act, NULL);
			alarm(EXECTIMEOUT);
			if (wait(&st) < 0) {
				if (got_alarm)
					fprintf(stderr, "EXEC %s TIMED OUT... exiting.\n", arg);
				else
					perror("EXEC ERROR");
				exit(1);
			}
			act.sa_handler = SIG_IGN;
			sigaction(SIGALRM, &act, NULL);
		}
	}
}

void
alarm_handler(sig)
	int sig;
{
	got_alarm = 1;
}
