/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: router management   				*/
/*		file	: router.h			      		*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/
#include "rps_if.h"

#define MNGID_MAXLENGTH	32

#define IF_DOWN		1
#define IF_UP		2

struct RT_IFCONF {
    struct RT_IFCONF *next;
    char	mng_id[MNGID_MAXLENGTH];
    struct if_addr *local_addr;
    struct if_addr *remote_addr;
    u_short	protocol;
    byte	*rt_table;
    byte	*proto_info;
    u_short 	state;
    struct RT_CONF *self;
};
    
struct RT_CONF {
    struct RT_CONF *next;
    char 	mng_id[MNGID_MAXLENGTH];
    u_long  	router_id;
    u_short  	if_num;
    u_short	trace_flag;
    FILE	*trace_fp;
    struct RT_IFCONF *rt_ifp;
    byte	*rtmng;
};

#define RT_IF_ADDR(rtif)	((rtif)->local_addr->addr->s_addr)



