/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: protocol message procedure			*/
/*		file	: proto_msg.c		       			*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/
static char copyright[]=
  "@(#)Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi.Ltd.\n All rights researved.\n";

#include "rps.h"
#include "rps_token.h"
#include "router.h"
/*#include "rps_bgp.h"*/
#include "ospf_type.h"

#ifdef VXWORKS

typedef char *VA_LIST;

#define VA_DCL int va_alist;
#define VA_START(list) list = (char *)&va_alist;
#define VA_END(list)
#define VA_ARG(list,mode) ((mode *)(list += sizeof(mode)))[-1]

#else

#include <stdio.h>
#include <varargs.h>

#endif

extern struct RT_CONF *router_search();

/*

  message_send

*/
void message_send(va_alist)
#ifdef VXWORKS
VA_DCL
#else
va_dcl
#endif
{
    u_long id;
    u_long intf;
    int protocol;
    int type;
    u_long dst;
    int num;
    int interval;
    struct RT_CONF *rt;
    struct RT_IFCONF *rtifp;
    u_long lcl;

#ifdef VXWORKS

    VA_LIST args;

    VA_START(args);

    id = VA_ARG(args,u_long);
    intf = VA_ARG(args,u_long);
    protocol = VA_ARG(args,int);
    type = VA_ARG(args,int);

    if(protocol == T_PROTO_ICMP)
      dst = VA_ARG(args,u_long);

    num = VA_ARG(args,int);
    interval = VA_ARG(args,int);

    VA_END(args);

#else 

    va_list args;

    va_start(args);

    id = va_arg(args,u_long);
    intf = va_arg(args,u_long);
    protocol = va_arg(args,int);
    type = va_arg(args,int);

    if(protocol == T_PROTO_ICMP)
      dst = va_arg(args,u_long);

    num = va_arg(args,int);
    interval = va_arg(args,int);

    va_end(args);

#endif
    
#ifdef USE_ICMP
    if(protocol == T_PROTO_ICMP) {
	icmp_init(id,intf);
	icmp_message_send(id,type,intf,dst,num,interval);
	return ;
    }
#endif USE_ICMP
    
    rt = router_search(id);
    for(rtifp=rt->rt_ifp;rtifp!=NULL;rtifp=rtifp->next) {
	lcl = RT_IF_ADDR(rtifp);
	
	if(protocol != rtifp->protocol || intf != lcl)
	    continue;
	
	while(num--) {
	    switch(protocol) {
	    case T_PROTO_BGP : /* bgp_message_send(rtifp->proto_info,type); */
		break;
	    case T_PROTO_OSPF : ospf_message_send(rtifp,type);
		break;
#ifdef USE_ICMP
	    case T_PROTO_ICMP : icmp_init(id,intf);
#endif
		break;
	    default: break;
	    }
	    
	    if(interval && num)
	      router_wait(id,interval);
	    
	}
    }
}

/*

  message_recv

*/
void message_recv(va_alist)
#ifdef VXWORKS
VA_DCL
#else
va_dcl
#endif
{
    u_long id;
    u_long intf;
    int protocol;
    int type;
    u_long dst;
    struct RT_CONF *rt;
    struct RT_IFCONF *rtifp;
    u_long lcl;
    
#ifdef VXWORKS

    VA_LIST args;

    VA_START(args);

    id = VA_ARG(args,u_long);
    intf = VA_ARG(args,u_long);
    protocol = VA_ARG(args,int);
    type = VA_ARG(args,int);

    if(protocol == T_PROTO_ICMP)
      dst = VA_ARG(args,u_long);

    VA_END(args);

#else 

    va_list args;

    va_start(args);

    id = va_arg(args,u_long);
    intf = va_arg(args,u_long);
    protocol = va_arg(args,int);
    type = va_arg(args,int);

    if(protocol == T_PROTO_ICMP)
      dst = va_arg(args,u_long);

    va_end(args);

#endif
#ifdef USE_ICMP
    
    if(protocol == T_PROTO_ICMP) {
	icmp_init(id,intf);
	icmp_message_recv(id,type,intf,dst);
	icmp_term(id);
	return ;
    }

#endif /* USE_ICMP */
    
    rt = router_search(id);
    for(rtifp=rt->rt_ifp;rtifp!=NULL;rtifp=rtifp->next) {
	lcl = RT_IF_ADDR(rtifp);
	
	if(protocol != rtifp->protocol || intf != lcl)
	    continue;
	
	switch(protocol) {
	case T_PROTO_BGP : /* bgp_message_send(rtifp->proto_info,type); */
	    break;
	case T_PROTO_OSPF : ospf_message_recv(rtifp,type);
	    break;
	default: break;
	}
    }
}







