#
# This tests an implementation's ability to deal
# with malformed packets at different times.
# The following cases are tested:
#
# - bad HELLO pkts before 1-Way (nbr should not go to init)
# - bad HELLO pkts after Full (nbr should stay at Full)
#  	- tests bad type, length(2), cksum, authtype, and version
# 
# - bad LSUpdate pkts after Full
#	- bad type
#	- self-orig router-LSA ls_id != adv_rtr
#
# (by no means is this test comprehensive.  It is really
#  a test for the last malformed pkt which is a bug in GateD).
#
# naamato@merit.net
#

#
# Start RPS
#
start(1.conf,1.net)
traceON(0.0.0.2,1.log)

#
# Packet hdrs (before adjacency is brought up)
#

# bad type 
exec(hello-badtype)

# bad length (long)
exec(hello-badlength)

# bad length (short)
exec(hello-badlength2)

# bad cksum
exec(hello-badcksum)

# bad authtype
exec(hello-badatype)

# bad version
exec(hello-badver)

#
# Bring up the adjacency
#
routerUP(0.0.0.2)

#
# do the bad hdrs again, make sure adj is still up
#

# bad type 
exec(hello-badtype)

# bad length (long)
exec(hello-badlength)

# bad length (short)
exec(hello-badlength2)

# bad cksum
exec(hello-badcksum)

# bad authtype
exec(hello-badatype)

# bad version
exec(hello-badver)

#
# LSUpdates
#

# bad type
# exec(lsup-badtype)



#
# Send a self-orig router-LSA (ls_id != adv_rtr)
#
# exec(rlsa1)

#
# Let normal protocol operations continue
#
wait(0.0.0.2,20)

#
# Bring everyone down
#
routerDOWN(0.0.0.2)

end
