/************************************************************************/
/*	Routing Protocol Simulator	Relese 1.0	1994/3/17	*/
/*									*/
/*		module 	: common routine				*/
/*		file	: token.c				      	*/
/*									*/
/*   Copyright (c) 1994 by Systems Development Laboratory Hitachi,Ltd.	*/
/*   All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/
static char copyright[]=
  "@(#)Copyright (c) 1994 by Systems Development Laboratory Hitachi,Ltd.\n All rights researved.\n";

#ifdef VXWORKS

#include "stdioLib.h"
#include "rps_token.h"

#else

#include <stdio.h>
#include "rps_token.h"

#endif

#define			ON		1
#define			OFF		0

int	line_num;

struct token common_error[] =
{
    {T_ERROR_NOTHING,		"unknown error" },
    {T_ERROR_SYNTAX,		"syntax error" },
    {T_ERROR_BEGIN_CLAUSE, 	"missing '{'" },
    {T_ERROR_END_CLAUSE, 	"missing '}' " },
    {T_ERROR_END_STATEMENT,	"missing ';' " },
    {T_ERROR_END_OF_FILE,	"end of file" }
};


/*

  init_token

*/
void init_token()
{
    line_num = 1;
}

/*

  get_current_line

*/
int get_current_line()
{
    return(line_num);
}

/*

  get_token - read token

*/
int get_token(fp,token)
FILE *fp;
char *token;
{
    int token_start;
    char c;
    char *buf;

    buf = token;
    token_start = OFF;
    while((c = getc(fp)) != EOF) {
	if(c == COMMENT) {
	    READ_SKIP(fp,CR);
	    buf = token;
	}
	else if(!TERM_CHECK(c)) {
	    if(c == CR) line_num++;
	    if(token_start == ON) break;
	}
	else if(!SYNTAX_SYMBOL_CHECK(c)) {
	    if(token_start == ON) {
		ungetc(c,fp);
		break;
	    }
	    else {
		*buf++ = c;
		token_start = ON;
	    }
	}
	else {
	    if(token_start == OFF) token_start = ON;
	    *buf++ = c;
	}
    }
    *buf = '\0';

    if(c == EOF) return(EOF);
    else {
	return(line_num);
    }
}

/*

  token_chk - get token id

*/
int token_type(list, token)
struct token *list;
char *token;
{
	struct token *p;

	for(p=list; p->name != NULL;p++) {
		if(!strcmp(token,p->name)) {
			return(p->no);
		}
	}

	return(list->no);
}

/*

  get_cmd

*/
int get_cmd(fp,cmd)
FILE *fp;
char *cmd;
{
/*    char cmd[MAX_NUM_CMD_CHARACTER];*/
    char *buf,*tmp;
    int c;

    tmp = buf = cmd;
    while((c = getc(fp)) != EOF) {
	if(!TERM_CHECK(c) || c == T_LEFT_PUNC) {
	    if(tmp != cmd) {
		*tmp = '\0';
		break;
	    }
	}
	else if(c == COMMENT) {
	    READ_SKIP(fp,CR);
	    if(tmp == buf) return NOCOMMAND;
	}
	else {
	    *tmp++ = c;
	}
    }

    if(c == EOF) {
	if(tmp == buf) return NOCOMMAND;
	else return EOF;
    }
    else return 1;
}

/*

  get_arg

*/
int get_arg(fp,arg)
FILE *fp;
char *arg;
{
    char *buf;
    int c;
    
    buf = arg;
    while((c = getc(fp)) != EOF) {
	if(c == T_RIGHT_PUNC) {
	    *buf = '\0';
	    READ_SKIP(fp,CR);
	    break;
	}
	else if(TERM_CHECK(c)) {
	    *buf++ = c;
	}
    }

    if(c == EOF) return EOF;
    return 1;

}

/*

  token_arg

*/
char *token_arg(arg,symbol)
char **arg;
int symbol;
{
    static char buf[32];
    char *tmp;

    tmp = buf;
    while(*(*arg) != symbol && *(*arg) != NULL) {
	*tmp++ = *(*arg)++;
    }

    *tmp = '\0';
    (*arg)++;
    
    return buf;
}
    
  
/*

  error_print - token error print

*/
void error_print(type, msglist)
int type;
struct token *msglist;
{
    log_trace(stderr,"\n ERROR : %s (at line %d)\n\n",(msglist+type)->name,line_num);
}




