/************************************************************************/
/*	Routing Protocol Simulator	Relese 1.0	1994/3/17	*/
/*									*/
/*		module 	: common routine				*/
/*		file	: rps_inet.c				      	*/
/*									*/
/*   Copyright (c) 1994 by Systems Development Laboratory Hitachi,Ltd.	*/
/*   All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/
static char copyright[]=
  "@(#)Copyright (c) 1994 by Systems Development Laboratory Hitachi,Ltd.\n All rights researved.\n";

#include "rps.h"
#include "router.h"
#ifdef VXWORKS

#include "hostLib.h"

#else

#include <netdb.h>

#endif
/*

  char_to_inetaddr - convert dot-notation character to address

*/
u_long char_to_inetaddr(addr)
char *addr;
{
    struct in_addr iaddr;
    struct hostent *haddr;
    char *buf,num[16];
    int i;
    
    i = iaddr.s_addr = 0;

    for(buf = addr;*buf!=NULL;buf++) {
	if(*buf == '.') {
	    num[i] = '\0';
	    iaddr.s_addr <<= 8 ;
	    iaddr.s_addr |= asc_to_int(num);
	    i =0;
	}
	else {
	    num[i++] = *buf;
	}
    }
    num[i] = '\0';
    iaddr.s_addr <<= 8;
    iaddr.s_addr |= asc_to_int(num);
    
    return iaddr.s_addr;
}

/*

  inetaddr_to_char

*/
char *inetaddr_to_char(addr)
u_long addr;
{
    struct in_addr iaddr;
    char *c_addr;
    
    bzero(&iaddr,sizeof(struct in_addr));
    iaddr.s_addr = addr;
    c_addr = inet_ntoa(iaddr);
    
    return(c_addr);
}

/*

  convert_inetaddr

*/
u_long convert_inetaddr(if_addr)
char *if_addr;
{
    u_long iaddr;
    struct hostent *haddr;
    
    if('0' <= *if_addr && '9' >= *if_addr) {
	iaddr = char_to_inetaddr(if_addr);
    }
#ifdef VXWORKS

    else {
	return hostGetByName(if_addr);
    }

#else

    else {
	haddr = gethostbyname(if_addr);
	bcopy(haddr->h_addr,(char *)&iaddr,haddr->h_length);
    }
    
    return iaddr ;

#endif
}

/*

  if_inetaddr

*/
struct in_addr *if_inetaddr(if_addr)
char *if_addr;
{
    struct in_addr *iaddr;
    struct hostent *haddr;
    
    if((iaddr = (struct in_addr *)malloc(sizeof(struct in_addr))) == NULL) {
	return NULL;
    }

    iaddr->s_addr = convert_inetaddr(if_addr);
    
/*    if('0' <= *if_addr && '9' >= *if_addr) {
	iaddr->s_addr = char_to_inetaddr(if_addr);
    }
    else {
	haddr = gethostbyname(if_addr);
	bcopy(haddr->h_addr,(char *)&iaddr->s_addr,haddr->h_length);
    }
*/    
    return iaddr ;

}


/*

  if_addr_dump

*/
void if_addr_dump(fp,ifap)
FILE *fp;
struct if_addr *ifap;
{
    struct in_addr tmpaddr;

    bcopy(ifap->addr,&tmpaddr,sizeof(struct in_addr));
    tmpaddr.s_addr = ntohl(tmpaddr.s_addr);

    if(fp == NULL) fp = stderr;
    
    log_trace(fp,"%s",inet_ntoa(tmpaddr));
}

/*

  if_addr_free

*/
void if_addr_free(ifap)
struct if_addr *ifap;
{
    if(ifap->addr) free((char *)ifap->addr);
    if(ifap->net) free((char *)ifap->net);
    if(ifap->net_mask) free((char *)ifap->net_mask);
    if(ifap->subnet) free((char *)ifap->subnet);
    if(ifap->subnet_mask) free((char *)ifap->subnet_mask);
}








