/* $Id: hello.c,v 1.1 1999/08/23 16:18:31 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include "pim_def.h"

void timer();

char usage[] = "Usage: hello [-i interface] [-s src_addr] [-d dst_addr] [-t type] [-l len] [-v value] [-C count]\n";

int time_expire;

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst;
    u_int type,len,value;
    char *if_name;
    int count;
#ifndef SOLARIS
    struct sigvec sigv;
#endif

    src = dst = 0;
    if_name = NULL;
    type = HELLO_HOLDTIME;
    len = HELLO_HOLDTIME_LEN;
    value = DEFAULT_HOLDTIME;
    count = 1;

    while((opt = getopt(argc,argv,"i:d:t:s:l:v:C:")) != -1) {
        switch(opt) {
	case 'i' : if_name = malloc(8);
	           strcpy(if_name,optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 't' : type = atoi(optarg);
	           break;
	case 'l' : len = atoi(optarg);
	           break;
	case 'v' : value = atoi(optarg);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'C' : count = atoi(optarg);
	           break;
	default:   fprintf(stderr,usage);
	           exit(1);
	}
    }

    interface_init();
    pim_init();

#ifdef SOLARIS
    sighold(SIGALRM);
    sigset(SIGALRM,timer);
#else
    bzero((char *)&sigv, sizeof(sigv));
    sigv.sv_flags = 0;
    sigv.sv_handler = timer;
    sigv.sv_mask = 0;
    sigvec(SIGALRM, &sigv, (struct sigvec *)NULL);
#endif

    time_expire = 1;
    pim_hello_send(if_name,src,dst,type,len,value);
    for(;count>1;count--) {
	sleep(PIM_HELLO_INTERVAL);
	pim_hello_send(if_name,src,dst,type,len,value);
    }

}

void timer()
{
    time_expire = 1;
}
