# --- ${C_BLDDIR}Makefile

if test -n "$B_Makefile"
then

F_define=
F_using=yep

cat <<foo

Building $MAKEFILE...

foo

# configure the needed variables

test -z "$make_probe_done" && . ./config/bz.makeprobe

# just build it!

(exec >$MAKEFILE
cat <<foo
#! /bin/make -f
# Makefile
# architecture-customized Makefile for $VERSION
# for architecture "$arch",
# automagically generated by buildzsh -- do not edit

MAKE=make

AUX=buildzsh

SRC=$SRC

HEADER=$HEADER

PROTO=$PROTO

OBJS=$OBJS

BINDIR=$C_BINDIR
MANDIR=$C_MANDIR

# Debugging flags
DFLAGS=$DFLAGS

CC=$CC

CFLAGS=$CFLAGS

CFLAGS_WO_O=$CFLAGS_WO_O

LD=$LD

LDFLAGS=$LDFLAGS

LIBS=$LIBS

ZSHPATH=${C_BLDDIR}zsh

all: \$(PROTO) \$(ZSHPATH)

.SUFFIXES: .c .o .pro

foo

echo '	...possible notes' 1>&2

echo '	...special rules' 1>&2

# --- notes for various environments (and compilers)

# Past problems: (PLEASE COLLECT PAST PROBLEMS WITH COMPILERS
# HERE: NOT ERRORS/WARNINGS BUT STUFF ABOUT COMPILER CRASHES AND SUCH)
#
# AIX c89 -O -c builtin.c/2.4.60...2.4.2xx used to dump core,
# AIX 3.2.4 fixes the situation, harass your IBM rep until you get the patches.
# (the temporary patch is to use cc on builtin.c)
#
# IRIX cc -ansiposix -O zle_misc.c/2.4.75..2.4.2xx used to dump core,
# later zsh patchlevels do not have this problem
# (the temporary patch was to drop -O on zle_misc.c)
#

if test -n "$AIX"
then
cat <<foo
#	--- AIX notes
#	Note 1:	Pre-3.2.4 AIX c89 -O -c builtin.c dumps core,
#		the temporary cure is to use cc on builtin.c.
#
#	Note 2: 3.2.4-onwards AIX cc -O builtin.c gets stuck (optimizer
#		tries too hard), the temporary cure is to drop -O.
#
# @@@ NOTE: won't work if srcdir != blddir
${C_BLDDIR}builtin.o:     ${C_SRCDIR}builtin.c
	cc \$(CFLAGS_WO_O) \$(DFLAGS) -o builtin.o -c builtin.c

foo
elif test -n "$HPUX"
then
cat <<'foo'
#	--- HPUX notes
#	With c89 you will get warnings ftom
#	from zle_tricky.c: warning 530: Casting from loose to strict alignment.
#	this problem is caused by casting "char *"s to e.g. Cmdnam-
#	structures and then immediately accessing the elements, like this: 
#	char *s;
#	char *cn;
#	{
#	    if (((Cmdnam) cn)->type != DISABLED)
#
foo
elif test -n "$CONVEX"
then
cat <<'foo'
#	--- CONVEX notes
#	cc options NOT used:
#	-std (strict ANSI + POSIX, non-POSIX not recognized, e.g. long long)
#	-str (strict ANSI, UNIX functions not recognized)
#	diagnostics not used (zsh code too "hopeless"):
#	assign_in_condition metrics_file metrics_off
#	negative_to_uns pointer_alignment_efficiency skip_to_char skip_to_eof
#	Note 1: man cc lies that ptr_cvt_truncates is ptr_convert_truncates
#	Note 2: cc notices that init.c:main() never returns
#	Note 3: utils.c:intr() and holdintr() sigvec initializations
#	        are somehow suspicious
#
foo
elif test -n "$SOLARIS"
then
cat <<'foo'
#	--- SOLARIS notes
#	SunSoft cc assumed (CFLAGS derived from this assumption),
#	if you want to use gcc, try 'buildzsh gcc'
foo
elif test -n "$NEXT"
then
cat <<'foo'
#	--- NEXT notes
#	You will get two warnings for each file because
#	/NextDeveloper/Headers/bsd/memory.h:23 contains
#	ANSI-illegal trash after #endif.
#
foo
elif test -n "$UNICOS"
then
cat <<'foo'
#	--- UNICOS notes
#	Note 1: you will get five WARNINGs for each file because of
#	        a) <sys/param.h>, <sys/ioctl.h>:
#		   there is something else than just newline after
#		   directives #endif or #else (Cray's fault)
#	It *is* possible to get more picky by adding '-h port=insx'
#	to the CFLAGS but then a horde of complaints will jump at you:
#	Note 2: a) <stdio.h>:
#		   use bit fields other than signed int or unsigned int
#	        b) <sys/file.h>:
#		   union members have different types
#	        b1) f_uinode and f_udata
#	        b2) f_unext and f_udata
#	        (both of these Cray's fault)
#	Note 3: zsh.h: union members have different types
#	        a1) nam and binnum	a5) arr and val
#	        a2) nam and list		a6) str and val
#	        a3) binnum and list	a7) cfn and ifn
#	        a4) arr and str		a8) ifn and afn
#	        b) cond.c:
#	        pointer is cast to a pointer of another type
#	Note 4: from most of the zsh source files LOTS of:
#	        a) an assignment to a shorter integral type may cause truncation
#	        b) an integral type is cast to  pointer
#	        c) a character pointer cast may result in improprer alignment
#	        d) a "char" assigned to a larger "int" may sign-extend incorrectly
#
foo
# IRIX5 test before IRIX test because IRIX5 is also IRIX but we
# want IRIX5-specific stuff here
elif test -n "$IRIX5"
then
cat <<'foo'
#	-- IRIX5 notes
#	Warnings turned off:
#	799: /usr/include/sgidefs.h, line 141: 'long long' is not standard ANSI. (3.1.1)
#
foo
elif test -n "$IRIX"
then
cat <<'foo'
#	--- IRIX notes
#	Warnings turned off:
#	  2: %s redefinition hides earlier one
#	     (all the static-global c's, sigh...)
#	183: Previous declaration had prototype, this declaration does not(prototype declaration kept)
#	     (ANSI *.pro vs K&R *.c)
#	262: Previous declaration had prototype, this definition does not
#	     (ditto)
#	269: Evaluation gives an intermediate result type difference in ANSI versus K&R C;   int  versus   unsigned int
#	     (all the unsigned staff vs char and int literals, ugh)
#	302: bodyless for statement
#	     (not bad at all, just suspicious)
#	303: bodyless while statement
#	     (not bad at all, just suspicious)
#	309: Only int, signed int, unsigned int bit-fields defined in ANSI C. char, short, and long versions are allowed as an extension (ANSI C 3.5.2.1)
#	     (one of IRIX' own header files is bad in this way...)
#
foo
elif test -n "$TITAN"
then
cat <<'foo'
#	--- TITAN notes
#	Note 1: lots of (about 125) of "argument xxx is not used"
#	Note 2: LOTS of (about 420) of "conversion of xxx (0xyy) loses precision
#	Note 3: couple of (3) of "implied return [blah blah]"
#		(caused by poor flow analysis, not by poor code)
#
foo
fi

echo '	...general rules' 1>&2

if test -n "$ccseparate"
then
  if test -n "$make_groks_VPATH"
  then
    for _b in $BSRC
    do
cat <<foo
$_b.o:	$_b.c
	$ccit -c \$?

foo
    done
  else
    for _b in $BSRC
    do
cat <<foo
$_b.o:	$C_SRCDIR/$_b.c
	$ccit -c \$?

foo
     done
  fi
else	# the simple case
cat <<foo
.c.o:
	$ccit $ccdotc

foo
fi

if test -z "$make_groks_VPATH"
then
  for _proto in $PROTO
  do
    _c=`basename $_proto|sed 's/pro$/c/`
cat <<foo
$_proto:
	sed -n -f makepro.sed $_c > $_proto

foo
  done
else

cat <<foo

.c.pro:
	sed -n -f makepro.sed ${C_SRCDIR}$< > \`basename ${C_BLDDIR}\$@\`

foo
fi

cat <<foo
\$(ZSHPATH): \$(OBJS)
	\$(LD) \$(LDFLAGS) -o \$(ZSHPATH) \$(OBJS) \$(LIBS)
	
\$(PROTO): ${C_SRCDIR}makepro.sed

tags: /tmp
foo
test -z "$F_bld_eq_src" -a -n "$C_SRCDIR" && echo "	cd $C_SRCDIR"
cat <<foo
	ctags *.[cy]

# I hate this next line
\$(OBJS): ${C_BLDDIR}config.h ${C_BLDDIR}signals.h ${C_SRCDIR}zsh.h ${C_SRCDIR}zle.h ${C_SRCDIR}ztype.h ${C_SRCDIR}funcs.h

${C_BLDDIR}params.o: ${C_SRCDIR}version.h

${C_SRCDIR}makepro.sed:
	\$(CO) \$(COFLAGS) ${C_SRCDIR}makepro.sed

install.bin: ${C_BLDDIR}zsh
foo
test -z "$F_bld_eq_src" -a -n "$C_SRCDIR" && echo "	cd $C_SRCDIR"
cat <<foo
	-if [ -f \$(BINDIR)/zsh ]; then mv \$(BINDIR)/zsh \$(BINDIR)/zsh.old; fi
	cp ${C_BLDDIR}zsh \$(BINDIR)
	chmod 755 \$(BINDIR)/zsh

install.man:
	cp ${C_SRCDIR}../doc/zsh.1 \$(MANDIR)
	chmod 644 \$(MANDIR)/zsh.1

install.info:
	cd ${C_SRCDIR}../doc; for f in zsh.info*; do cp \$\$f /usr/local/info; chmod 644 /usr/local/info/\$\$f; done

install: install.bin install.man install.info

clean:
foo
test $C_SRCDIR && echo "	cd $C_SRCDIR"
cat <<'foo'
	rm -f $(OBJS) $(ZSHPATH) core

distclean: clean
foo
test -z "$F_bld_eq_src" -a -n "$C_SRCDIR" && echo "	cd $C_SRCDIR"
cat <<foo
	rm -f \$(PROTO) Makefile ${C_BLDDIR}signals.h ${C_BLDDIR}config.h

foo
)
fi

###
