# This makefile has been automatically generated from the SSLeay distribution.
# This single makefile will build the complete SSLeay distribution and
# by default leave the 'intertesting' output files in .\out and the stuff
# that needs deleting in .\tmp.
# The file was generated by running 'make makefile.one', which
# does a 'make files', which writes all the environment variables from all
# the makefiles to the file call MINFO.  This file is used by
# util\mk1mf.pl to generate makefile.one.
# The 'makefile per directory' system suites me when developing this
# library and also so I can 'distribute' indervidual library sections.
# The one monster makefile better suits building in non-unix
# environments.

INSTALLTOP=\usr\local\ssl

# Set your compiler options
PLATFORM=VC-WIN32
CC=cl
CFLAG= /MD /W3 /WX /G5 /Ox /O2 /Ob2 /Gs0 /GF /Gy /nologo -DWIN32 -DWIN32_LEAN_AND_MEAN -DL_ENDIAN -DBN_ASM -DMD5_ASM -DSHA1_ASM -DRMD160_ASM /Fdout32dll
APP_CFLAG=
LIB_CFLAG= /GD -D_WINDLL -D_DLL
SHLIB_CFLAG=
APP_EX_OBJ=setargv.obj
SHLIB_EX_OBJ=
# add extra libraries to this define, for solaris -lsocket -lnsl would
# be added
EX_LIBS=wsock32.lib user32.lib gdi32.lib

# The SSLeay directory
SRC_D=.

LINK=link
LFLAGS=/nologo /subsystem:console /machine:I386 /opt:ref

BN_ASM_OBJ=crypto\bn\asm\bn-win32.obj
BN_ASM_SRC=crypto\bn\asm\bn-win32.asm
DES_ENC_OBJ=crypto\des\asm\d-win32.obj crypto\des\asm\y-win32.obj
DES_ENC_SRC=crypto\des\asm\d-win32.asm crypto\des\asm\y-win32.asm
BF_ENC_OBJ=crypto\bf\asm\b-win32.obj
BF_ENC_SRC=crypto\bf\asm\b-win32.asm
CAST_ENC_OBJ=crypto\cast\asm\c-win32.obj
CAST_ENC_SRC=crypto\cast\asm\c-win32.asm
RC4_ENC_OBJ=crypto\rc4\asm\r4-win32.obj
RC4_ENC_SRC=crypto\rc4\asm\r4-win32.asm
RC5_ENC_OBJ=crypto\rc5\asm\r5-win32.obj
RC5_ENC_SRC=crypto\rc5\asm\r5-win32.asm
MD5_ASM_OBJ=crypto\md5\asm\m5-win32.obj
MD5_ASM_SRC=crypto\md5\asm\m5-win32.asm
SHA1_ASM_OBJ=crypto\sha\asm\s1-win32.obj
SHA1_ASM_SRC=crypto\sha\asm\s1-win32.asm
RMD160_ASM_OBJ=crypto\ripemd\asm\rm-win32.obj
RMD160_ASM_SRC=crypto\ripemd\asm\rm-win32.asm

# The output directory for everything intersting
OUT_D=out32dll
# The output directory for all the temporary muck
TMP_D=tmp32dll
# The output directory for the header files
INC_D=inc32

CP="copy /b nul+ "
RM=del
RANLIB=
MKDIR=mkdir
MKLIB=lib
MLFLAGS= /nologo /subsystem:console /machine:I386 /opt:ref /dll
ASM=ml /Cp /coff /c /Cx

######################################################
# You should not need to touch anything below this point
######################################################

E_EXE=ssleay
SSL=ssleay32
CRYPTO=libeay32
RSAGLUE=RSAglue

# BIN_D  - Binary output directory
# TEST_D - Binary test file output directory
# LIB_D  - library output directory
BIN_D=$(OUT_D)
TEST_D=$(OUT_D)
LIB_D=$(OUT_D)

# INCL_D - local library directory
# OBJ_D  - temp object file directory
OBJ_D=$(TMP_D)
INCL_D=$(TMP_D)

O_SSL=     $(LIB_D)\$(SSL).dll
O_CRYPTO=  $(LIB_D)\$(CRYPTO).dll
O_RSAGLUE= $(LIB_D)\$(RSAGLUE).lib
SO_SSL=    $(SSL)
SO_CRYPTO= $(CRYPTO)
L_SSL=     $(LIB_D)\$(SSL).lib
L_CRYPTO=  $(LIB_D)\$(CRYPTO).lib

L_LIBS= $(L_SSL) $(L_CRYPTO)
#L_LIBS= $(O_SSL) $(O_RSAGLUE) -lrsaref $(O_CRYPTO)

######################################################
# Don't touch anything below this point
######################################################

INC=-I$(INC_D) -I$(INCL_D)
APP_CFLAGS=$(INC) $(CFLAG) $(APP_CFLAG)
LIB_CFLAGS=$(INC) $(CFLAG) $(LIB_CFLAG)
SHLIB_CFLAGS=$(INC) $(CFLAG) $(LIB_CFLAG) $(SHLIB_CFLAG)
LIBS_DEP=$(O_CRYPTO) $(O_RSAGLUE) $(O_SSL)

#############################################
HEADER=$(INCL_D)\cryptlib.h \
	$(INCL_D)\date.h $(INCL_D)\md5_locl.h $(INCL_D)\sha_locl.h \
	$(INCL_D)\rmd_locl.h $(INCL_D)\rmdconst.h $(INCL_D)\des_locl.h \
	$(INCL_D)\rpc_des.h $(INCL_D)\podd.h $(INCL_D)\sk.h \
	$(INCL_D)\spr.h $(INCL_D)\des_ver.h $(INCL_D)\rc2_locl.h \
	$(INCL_D)\rc4_locl.h $(INCL_D)\rc5_locl.h $(INCL_D)\idea_lcl.h \
	$(INCL_D)\bf_pi.h $(INCL_D)\bf_locl.h $(INCL_D)\cast_s.h \
	$(INCL_D)\cast_lcl.h $(INCL_D)\bn_lcl.h $(INCL_D)\bn_prime.h \
	$(INCL_D)\obj_dat.h $(INCL_D)\conf_lcl.h $(INCL_D)\ssl_locl.h \
	$(INCL_D)\apps.h $(INCL_D)\progs.h $(INCL_D)\s_apps.h \
	$(INCL_D)\testdsa.h $(INCL_D)\testrsa.h

EXHEADER=$(INC_D)\e_os.h \
	$(INC_D)\crypto.h $(INC_D)\cryptall.h $(INC_D)\tmdiff.h \
	$(INC_D)\md2.h $(INC_D)\md5.h $(INC_D)\sha.h \
	$(INC_D)\mdc2.h $(INC_D)\hmac.h $(INC_D)\ripemd.h \
	$(INC_D)\des.h $(INC_D)\rc2.h $(INC_D)\rc4.h \
	$(INC_D)\rc5.h $(INC_D)\idea.h $(INC_D)\blowfish.h \
	$(INC_D)\cast.h $(INC_D)\bn.h $(INC_D)\rsa.h \
	$(INC_D)\dsa.h $(INC_D)\dh.h $(INC_D)\buffer.h \
	$(INC_D)\bio.h $(INC_D)\bss_file.c $(INC_D)\stack.h \
	$(INC_D)\lhash.h $(INC_D)\rand.h $(INC_D)\err.h \
	$(INC_D)\objects.h $(INC_D)\evp.h $(INC_D)\pem.h \
	$(INC_D)\asn1.h $(INC_D)\asn1_mac.h $(INC_D)\x509.h \
	$(INC_D)\x509_vfy.h $(INC_D)\conf.h $(INC_D)\txt_db.h \
	$(INC_D)\pkcs7.h $(INC_D)\comp.h $(INC_D)\ssl.h \
	$(INC_D)\ssl2.h $(INC_D)\ssl3.h $(INC_D)\ssl23.h \
	$(INC_D)\tls1.h $(INC_D)\rsaref.h

T_OBJ=$(OBJ_D)\md2test.obj \
	$(OBJ_D)\md5test.obj $(OBJ_D)\shatest.obj $(OBJ_D)\sha1test.obj \
	$(OBJ_D)\mdc2test.obj $(OBJ_D)\hmactest.obj $(OBJ_D)\rmdtest.obj \
	$(OBJ_D)\destest.obj $(OBJ_D)\rc2test.obj $(OBJ_D)\rc4test.obj \
	$(OBJ_D)\rc5test.obj $(OBJ_D)\ideatest.obj $(OBJ_D)\bftest.obj \
	$(OBJ_D)\casttest.obj $(OBJ_D)\bntest.obj $(OBJ_D)\exptest.obj \
	$(OBJ_D)\dsatest.obj $(OBJ_D)\dhtest.obj $(OBJ_D)\randtest.obj \
	$(OBJ_D)\ssltest.obj

E_OBJ=$(OBJ_D)\verify.obj \
	$(OBJ_D)\asn1pars.obj $(OBJ_D)\req.obj $(OBJ_D)\dgst.obj \
	$(OBJ_D)\dh.obj $(OBJ_D)\enc.obj $(OBJ_D)\gendh.obj \
	$(OBJ_D)\errstr.obj $(OBJ_D)\ca.obj $(OBJ_D)\pkcs7.obj \
	$(OBJ_D)\crl2p7.obj $(OBJ_D)\crl.obj $(OBJ_D)\rsa.obj \
	$(OBJ_D)\dsa.obj $(OBJ_D)\dsaparam.obj $(OBJ_D)\x509.obj \
	$(OBJ_D)\genrsa.obj $(OBJ_D)\s_server.obj $(OBJ_D)\s_client.obj \
	$(OBJ_D)\speed.obj $(OBJ_D)\s_time.obj $(OBJ_D)\apps.obj \
	$(OBJ_D)\s_cb.obj $(OBJ_D)\s_socket.obj $(OBJ_D)\version.obj \
	$(OBJ_D)\sess_id.obj $(OBJ_D)\ciphers.obj $(OBJ_D)\ssleay.obj

CRYPTOOBJ=$(OBJ_D)\cryptlib.obj \
	$(OBJ_D)\mem.obj $(OBJ_D)\cversion.obj $(OBJ_D)\ex_data.obj \
	$(OBJ_D)\tmdiff.obj $(OBJ_D)\cpt_err.obj $(OBJ_D)\md2_dgst.obj \
	$(OBJ_D)\md2_one.obj $(OBJ_D)\md5_dgst.obj $(MD5_ASM_OBJ) \
	$(OBJ_D)\md5_one.obj $(OBJ_D)\sha_dgst.obj $(OBJ_D)\sha1dgst.obj \
	$(SHA1_ASM_OBJ) $(OBJ_D)\sha_one.obj $(OBJ_D)\sha1_one.obj \
	$(OBJ_D)\mdc2dgst.obj $(OBJ_D)\mdc2_one.obj $(OBJ_D)\hmac.obj \
	$(OBJ_D)\rmd_dgst.obj $(RMD160_ASM_OBJ) $(OBJ_D)\rmd_one.obj \
	$(OBJ_D)\set_key.obj $(OBJ_D)\ecb_enc.obj $(OBJ_D)\cbc_enc.obj \
	$(OBJ_D)\ecb3_enc.obj $(OBJ_D)\cfb64enc.obj $(OBJ_D)\cfb64ede.obj \
	$(OBJ_D)\cfb_enc.obj $(OBJ_D)\ofb64ede.obj $(OBJ_D)\enc_read.obj \
	$(OBJ_D)\enc_writ.obj $(OBJ_D)\ofb64enc.obj $(OBJ_D)\ofb_enc.obj \
	$(OBJ_D)\str2key.obj $(OBJ_D)\pcbc_enc.obj $(OBJ_D)\qud_cksm.obj \
	$(OBJ_D)\rand_key.obj $(DES_ENC_OBJ) $(OBJ_D)\read2pwd.obj \
	$(OBJ_D)\fcrypt.obj $(OBJ_D)\xcbc_enc.obj $(OBJ_D)\read_pwd.obj \
	$(OBJ_D)\rpc_enc.obj $(OBJ_D)\cbc_cksm.obj $(OBJ_D)\supp.obj \
	$(OBJ_D)\rc2_ecb.obj $(OBJ_D)\rc2_skey.obj $(OBJ_D)\rc2_cbc.obj \
	$(OBJ_D)\rc2cfb64.obj $(OBJ_D)\rc2ofb64.obj $(OBJ_D)\rc4_skey.obj \
	$(RC4_ENC_OBJ) $(OBJ_D)\rc5_skey.obj $(OBJ_D)\rc5_ecb.obj \
	$(RC5_ENC_OBJ) $(OBJ_D)\rc5cfb64.obj $(OBJ_D)\rc5ofb64.obj \
	$(OBJ_D)\i_cbc.obj $(OBJ_D)\i_cfb64.obj $(OBJ_D)\i_ofb64.obj \
	$(OBJ_D)\i_ecb.obj $(OBJ_D)\i_skey.obj $(OBJ_D)\bf_skey.obj \
	$(OBJ_D)\bf_ecb.obj $(BF_ENC_OBJ) $(OBJ_D)\bf_cfb64.obj \
	$(OBJ_D)\bf_ofb64.obj $(OBJ_D)\c_skey.obj $(OBJ_D)\c_ecb.obj \
	$(CAST_ENC_OBJ) $(OBJ_D)\c_cfb64.obj $(OBJ_D)\c_ofb64.obj \
	$(OBJ_D)\bn_add.obj $(OBJ_D)\bn_div.obj $(OBJ_D)\bn_exp.obj \
	$(OBJ_D)\bn_lib.obj $(OBJ_D)\bn_mul.obj $(OBJ_D)\bn_print.obj \
	$(OBJ_D)\bn_rand.obj $(OBJ_D)\bn_shift.obj $(OBJ_D)\bn_word.obj \
	$(OBJ_D)\bn_blind.obj $(OBJ_D)\bn_gcd.obj $(OBJ_D)\bn_prime.obj \
	$(OBJ_D)\bn_err.obj $(OBJ_D)\bn_sqr.obj $(BN_ASM_OBJ) \
	$(OBJ_D)\bn_recp.obj $(OBJ_D)\bn_mont.obj $(OBJ_D)\bn_mpi.obj \
	$(OBJ_D)\bn_exp2.obj $(OBJ_D)\rsa_eay.obj $(OBJ_D)\rsa_gen.obj \
	$(OBJ_D)\rsa_lib.obj $(OBJ_D)\rsa_sign.obj $(OBJ_D)\rsa_saos.obj \
	$(OBJ_D)\rsa_err.obj $(OBJ_D)\rsa_pk1.obj $(OBJ_D)\rsa_ssl.obj \
	$(OBJ_D)\rsa_none.obj $(OBJ_D)\dsa_gen.obj $(OBJ_D)\dsa_key.obj \
	$(OBJ_D)\dsa_lib.obj $(OBJ_D)\dsa_vrf.obj $(OBJ_D)\dsa_sign.obj \
	$(OBJ_D)\dsa_err.obj $(OBJ_D)\dh_gen.obj $(OBJ_D)\dh_key.obj \
	$(OBJ_D)\dh_lib.obj $(OBJ_D)\dh_check.obj $(OBJ_D)\dh_err.obj \
	$(OBJ_D)\buffer.obj $(OBJ_D)\buf_err.obj $(OBJ_D)\bio_lib.obj \
	$(OBJ_D)\bio_cb.obj $(OBJ_D)\bio_err.obj $(OBJ_D)\bss_mem.obj \
	$(OBJ_D)\bss_null.obj $(OBJ_D)\bss_fd.obj $(OBJ_D)\bss_file.obj \
	$(OBJ_D)\bss_sock.obj $(OBJ_D)\bss_conn.obj $(OBJ_D)\bf_null.obj \
	$(OBJ_D)\bf_buff.obj $(OBJ_D)\b_print.obj $(OBJ_D)\b_dump.obj \
	$(OBJ_D)\b_sock.obj $(OBJ_D)\bss_acpt.obj $(OBJ_D)\bf_nbio.obj \
	$(OBJ_D)\stack.obj $(OBJ_D)\lhash.obj $(OBJ_D)\lh_stats.obj \
	$(OBJ_D)\md_rand.obj $(OBJ_D)\randfile.obj $(OBJ_D)\rand_lib.obj \
	$(OBJ_D)\err.obj $(OBJ_D)\err_all.obj $(OBJ_D)\err_prn.obj \
	$(OBJ_D)\o_names.obj $(OBJ_D)\obj_dat.obj $(OBJ_D)\obj_lib.obj \
	$(OBJ_D)\obj_err.obj $(OBJ_D)\encode.obj $(OBJ_D)\digest.obj \
	$(OBJ_D)\evp_enc.obj $(OBJ_D)\evp_key.obj $(OBJ_D)\e_ecb_d.obj \
	$(OBJ_D)\e_cbc_d.obj $(OBJ_D)\e_cfb_d.obj $(OBJ_D)\e_ofb_d.obj \
	$(OBJ_D)\e_ecb_i.obj $(OBJ_D)\e_cbc_i.obj $(OBJ_D)\e_cfb_i.obj \
	$(OBJ_D)\e_ofb_i.obj $(OBJ_D)\e_ecb_3d.obj $(OBJ_D)\e_cbc_3d.obj \
	$(OBJ_D)\e_rc4.obj $(OBJ_D)\names.obj $(OBJ_D)\e_cfb_3d.obj \
	$(OBJ_D)\e_ofb_3d.obj $(OBJ_D)\e_xcbc_d.obj $(OBJ_D)\e_ecb_r2.obj \
	$(OBJ_D)\e_cbc_r2.obj $(OBJ_D)\e_cfb_r2.obj $(OBJ_D)\e_ofb_r2.obj \
	$(OBJ_D)\e_ecb_bf.obj $(OBJ_D)\e_cbc_bf.obj $(OBJ_D)\e_cfb_bf.obj \
	$(OBJ_D)\e_ofb_bf.obj $(OBJ_D)\e_ecb_c.obj $(OBJ_D)\e_cbc_c.obj \
	$(OBJ_D)\e_cfb_c.obj $(OBJ_D)\e_ofb_c.obj $(OBJ_D)\e_ecb_r5.obj \
	$(OBJ_D)\e_cbc_r5.obj $(OBJ_D)\e_cfb_r5.obj $(OBJ_D)\e_ofb_r5.obj \
	$(OBJ_D)\m_null.obj $(OBJ_D)\m_md2.obj $(OBJ_D)\m_md5.obj \
	$(OBJ_D)\m_sha.obj $(OBJ_D)\m_sha1.obj $(OBJ_D)\m_dss.obj \
	$(OBJ_D)\m_dss1.obj $(OBJ_D)\m_mdc2.obj $(OBJ_D)\m_ripemd.obj \
	$(OBJ_D)\p_open.obj $(OBJ_D)\p_seal.obj $(OBJ_D)\p_sign.obj \
	$(OBJ_D)\p_verify.obj $(OBJ_D)\p_lib.obj $(OBJ_D)\p_enc.obj \
	$(OBJ_D)\p_dec.obj $(OBJ_D)\bio_md.obj $(OBJ_D)\bio_b64.obj \
	$(OBJ_D)\bio_enc.obj $(OBJ_D)\evp_err.obj $(OBJ_D)\e_null.obj \
	$(OBJ_D)\c_all.obj $(OBJ_D)\evp_lib.obj $(OBJ_D)\pem_sign.obj \
	$(OBJ_D)\pem_seal.obj $(OBJ_D)\pem_info.obj $(OBJ_D)\pem_lib.obj \
	$(OBJ_D)\pem_all.obj $(OBJ_D)\pem_err.obj $(OBJ_D)\a_object.obj \
	$(OBJ_D)\a_bitstr.obj $(OBJ_D)\a_utctm.obj $(OBJ_D)\a_int.obj \
	$(OBJ_D)\a_octet.obj $(OBJ_D)\a_print.obj $(OBJ_D)\a_type.obj \
	$(OBJ_D)\a_set.obj $(OBJ_D)\a_dup.obj $(OBJ_D)\a_d2i_fp.obj \
	$(OBJ_D)\a_i2d_fp.obj $(OBJ_D)\a_bmp.obj $(OBJ_D)\a_sign.obj \
	$(OBJ_D)\a_digest.obj $(OBJ_D)\a_verify.obj $(OBJ_D)\x_algor.obj \
	$(OBJ_D)\x_val.obj $(OBJ_D)\x_pubkey.obj $(OBJ_D)\x_sig.obj \
	$(OBJ_D)\x_req.obj $(OBJ_D)\x_attrib.obj $(OBJ_D)\x_name.obj \
	$(OBJ_D)\x_cinf.obj $(OBJ_D)\x_x509.obj $(OBJ_D)\x_crl.obj \
	$(OBJ_D)\x_info.obj $(OBJ_D)\x_spki.obj $(OBJ_D)\d2i_r_pr.obj \
	$(OBJ_D)\i2d_r_pr.obj $(OBJ_D)\d2i_r_pu.obj $(OBJ_D)\i2d_r_pu.obj \
	$(OBJ_D)\d2i_s_pr.obj $(OBJ_D)\i2d_s_pr.obj $(OBJ_D)\d2i_s_pu.obj \
	$(OBJ_D)\i2d_s_pu.obj $(OBJ_D)\d2i_pu.obj $(OBJ_D)\d2i_pr.obj \
	$(OBJ_D)\i2d_pu.obj $(OBJ_D)\i2d_pr.obj $(OBJ_D)\t_req.obj \
	$(OBJ_D)\t_x509.obj $(OBJ_D)\t_pkey.obj $(OBJ_D)\p7_i_s.obj \
	$(OBJ_D)\p7_signi.obj $(OBJ_D)\p7_signd.obj $(OBJ_D)\p7_recip.obj \
	$(OBJ_D)\p7_enc_c.obj $(OBJ_D)\p7_evp.obj $(OBJ_D)\p7_dgst.obj \
	$(OBJ_D)\p7_s_e.obj $(OBJ_D)\p7_enc.obj $(OBJ_D)\p7_lib.obj \
	$(OBJ_D)\f_int.obj $(OBJ_D)\f_string.obj $(OBJ_D)\i2d_dhp.obj \
	$(OBJ_D)\i2d_dsap.obj $(OBJ_D)\d2i_dhp.obj $(OBJ_D)\d2i_dsap.obj \
	$(OBJ_D)\n_pkey.obj $(OBJ_D)\a_hdr.obj $(OBJ_D)\x_pkey.obj \
	$(OBJ_D)\a_bool.obj $(OBJ_D)\x_exten.obj $(OBJ_D)\asn1_par.obj \
	$(OBJ_D)\asn1_lib.obj $(OBJ_D)\asn1_err.obj $(OBJ_D)\a_meth.obj \
	$(OBJ_D)\a_bytes.obj $(OBJ_D)\evp_asn1.obj $(OBJ_D)\x509_def.obj \
	$(OBJ_D)\x509_d2.obj $(OBJ_D)\x509_r2x.obj $(OBJ_D)\x509_cmp.obj \
	$(OBJ_D)\x509_obj.obj $(OBJ_D)\x509_req.obj $(OBJ_D)\x509_vfy.obj \
	$(OBJ_D)\x509_set.obj $(OBJ_D)\x509rset.obj $(OBJ_D)\x509_err.obj \
	$(OBJ_D)\x509name.obj $(OBJ_D)\x509_v3.obj $(OBJ_D)\x509_ext.obj \
	$(OBJ_D)\x509pack.obj $(OBJ_D)\x509type.obj $(OBJ_D)\x509_lu.obj \
	$(OBJ_D)\x_all.obj $(OBJ_D)\x509_txt.obj $(OBJ_D)\by_file.obj \
	$(OBJ_D)\by_dir.obj $(OBJ_D)\v3_net.obj $(OBJ_D)\v3_x509.obj \
	$(OBJ_D)\conf.obj $(OBJ_D)\conf_err.obj $(OBJ_D)\txt_db.obj \
	$(OBJ_D)\pk7_lib.obj $(OBJ_D)\pkcs7err.obj $(OBJ_D)\pk7_doit.obj \
	$(OBJ_D)\comp_lib.obj $(OBJ_D)\c_rle.obj $(OBJ_D)\c_zlib.obj

SSLOBJ=$(OBJ_D)\s2_meth.obj \
	$(OBJ_D)\s2_srvr.obj $(OBJ_D)\s2_clnt.obj $(OBJ_D)\s2_lib.obj \
	$(OBJ_D)\s2_enc.obj $(OBJ_D)\s2_pkt.obj $(OBJ_D)\s3_meth.obj \
	$(OBJ_D)\s3_srvr.obj $(OBJ_D)\s3_clnt.obj $(OBJ_D)\s3_lib.obj \
	$(OBJ_D)\s3_enc.obj $(OBJ_D)\s3_pkt.obj $(OBJ_D)\s3_both.obj \
	$(OBJ_D)\s23_meth.obj $(OBJ_D)\s23_srvr.obj $(OBJ_D)\s23_clnt.obj \
	$(OBJ_D)\s23_lib.obj $(OBJ_D)\s23_pkt.obj $(OBJ_D)\t1_meth.obj \
	$(OBJ_D)\t1_srvr.obj $(OBJ_D)\t1_clnt.obj $(OBJ_D)\t1_lib.obj \
	$(OBJ_D)\t1_enc.obj $(OBJ_D)\ssl_lib.obj $(OBJ_D)\ssl_err2.obj \
	$(OBJ_D)\ssl_cert.obj $(OBJ_D)\ssl_sess.obj $(OBJ_D)\ssl_ciph.obj \
	$(OBJ_D)\ssl_stat.obj $(OBJ_D)\ssl_rsa.obj $(OBJ_D)\ssl_asn1.obj \
	$(OBJ_D)\ssl_txt.obj $(OBJ_D)\ssl_algs.obj $(OBJ_D)\bio_ssl.obj \
	$(OBJ_D)\ssl_err.obj

RSAGLUEOBJ=$(OBJ_D)\rsaref.obj \
	$(OBJ_D)\rsar_err.obj

T_EXE=$(TEST_D)\md2test.exe \
	$(TEST_D)\md5test.exe $(TEST_D)\shatest.exe $(TEST_D)\sha1test.exe \
	$(TEST_D)\mdc2test.exe $(TEST_D)\hmactest.exe $(TEST_D)\rmdtest.exe \
	$(TEST_D)\destest.exe $(TEST_D)\rc2test.exe $(TEST_D)\rc4test.exe \
	$(TEST_D)\rc5test.exe $(TEST_D)\ideatest.exe $(TEST_D)\bftest.exe \
	$(TEST_D)\casttest.exe $(TEST_D)\bntest.exe $(TEST_D)\exptest.exe \
	$(TEST_D)\dsatest.exe $(TEST_D)\dhtest.exe $(TEST_D)\randtest.exe \
	$(TEST_D)\ssltest.exe

###################################################################
all: banner $(TMP_D) $(BIN_D) $(TEST_D) $(LIB_D) $(INC_D) headers lib exe

banner:


$(TMP_D):
	$(MKDIR) $(TMP_D)

$(BIN_D):
	$(MKDIR) $(BIN_D)

$(TEST_D):
	$(MKDIR) $(TEST_D)

$(LIB_D):
	$(MKDIR) $(LIB_D)

$(INC_D):
	$(MKDIR) $(INC_D)

headers: $(HEADER) $(EXHEADER)

lib: $(LIBS_DEP)

exe: $(T_EXE) $(BIN_D)\$(E_EXE).exe

install:
	$(MKDIR) $(INSTALLTOP)
	$(MKDIR) $(INSTALLTOP)\bin
	$(MKDIR) $(INSTALLTOP)\include
	$(MKDIR) $(INSTALLTOP)\lib
	$(CP) $(INC_D)\*.[ch] $(INSTALLTOP)\include
	$(CP) $(BIN_D)\$(E_EXE).exe $(INSTALLTOP)\bin
	$(CP) $(O_SSL) $(INSTALLTOP)\lib
	$(CP) $(O_CRYPTO) $(INSTALLTOP)\lib

clean:
	$(RM) $(TMP_D)\*.*

vclean:
	$(RM) $(TMP_D)\*.*
	$(RM) $(OUT_D)\*.*

$(INCL_D)\cryptlib.h: $(SRC_D)\crypto\cryptlib.h
	$(CP) $(SRC_D)\crypto\cryptlib.h $(INCL_D)\cryptlib.h

$(INCL_D)\date.h: $(SRC_D)\crypto\date.h
	$(CP) $(SRC_D)\crypto\date.h $(INCL_D)\date.h

$(INCL_D)\md5_locl.h: $(SRC_D)\crypto\md5\md5_locl.h
	$(CP) $(SRC_D)\crypto\md5\md5_locl.h $(INCL_D)\md5_locl.h

$(INCL_D)\sha_locl.h: $(SRC_D)\crypto\sha\sha_locl.h
	$(CP) $(SRC_D)\crypto\sha\sha_locl.h $(INCL_D)\sha_locl.h

$(INCL_D)\rmd_locl.h: $(SRC_D)\crypto\ripemd\rmd_locl.h
	$(CP) $(SRC_D)\crypto\ripemd\rmd_locl.h $(INCL_D)\rmd_locl.h

$(INCL_D)\rmdconst.h: $(SRC_D)\crypto\ripemd\rmdconst.h
	$(CP) $(SRC_D)\crypto\ripemd\rmdconst.h $(INCL_D)\rmdconst.h

$(INCL_D)\des_locl.h: $(SRC_D)\crypto\des\des_locl.h
	$(CP) $(SRC_D)\crypto\des\des_locl.h $(INCL_D)\des_locl.h

$(INCL_D)\rpc_des.h: $(SRC_D)\crypto\des\rpc_des.h
	$(CP) $(SRC_D)\crypto\des\rpc_des.h $(INCL_D)\rpc_des.h

$(INCL_D)\podd.h: $(SRC_D)\crypto\des\podd.h
	$(CP) $(SRC_D)\crypto\des\podd.h $(INCL_D)\podd.h

$(INCL_D)\sk.h: $(SRC_D)\crypto\des\sk.h
	$(CP) $(SRC_D)\crypto\des\sk.h $(INCL_D)\sk.h

$(INCL_D)\spr.h: $(SRC_D)\crypto\des\spr.h
	$(CP) $(SRC_D)\crypto\des\spr.h $(INCL_D)\spr.h

$(INCL_D)\des_ver.h: $(SRC_D)\crypto\des\des_ver.h
	$(CP) $(SRC_D)\crypto\des\des_ver.h $(INCL_D)\des_ver.h

$(INCL_D)\rc2_locl.h: $(SRC_D)\crypto\rc2\rc2_locl.h
	$(CP) $(SRC_D)\crypto\rc2\rc2_locl.h $(INCL_D)\rc2_locl.h

$(INCL_D)\rc4_locl.h: $(SRC_D)\crypto\rc4\rc4_locl.h
	$(CP) $(SRC_D)\crypto\rc4\rc4_locl.h $(INCL_D)\rc4_locl.h

$(INCL_D)\rc5_locl.h: $(SRC_D)\crypto\rc5\rc5_locl.h
	$(CP) $(SRC_D)\crypto\rc5\rc5_locl.h $(INCL_D)\rc5_locl.h

$(INCL_D)\idea_lcl.h: $(SRC_D)\crypto\idea\idea_lcl.h
	$(CP) $(SRC_D)\crypto\idea\idea_lcl.h $(INCL_D)\idea_lcl.h

$(INCL_D)\bf_pi.h: $(SRC_D)\crypto\bf\bf_pi.h
	$(CP) $(SRC_D)\crypto\bf\bf_pi.h $(INCL_D)\bf_pi.h

$(INCL_D)\bf_locl.h: $(SRC_D)\crypto\bf\bf_locl.h
	$(CP) $(SRC_D)\crypto\bf\bf_locl.h $(INCL_D)\bf_locl.h

$(INCL_D)\cast_s.h: $(SRC_D)\crypto\cast\cast_s.h
	$(CP) $(SRC_D)\crypto\cast\cast_s.h $(INCL_D)\cast_s.h

$(INCL_D)\cast_lcl.h: $(SRC_D)\crypto\cast\cast_lcl.h
	$(CP) $(SRC_D)\crypto\cast\cast_lcl.h $(INCL_D)\cast_lcl.h

$(INCL_D)\bn_lcl.h: $(SRC_D)\crypto\bn\bn_lcl.h
	$(CP) $(SRC_D)\crypto\bn\bn_lcl.h $(INCL_D)\bn_lcl.h

$(INCL_D)\bn_prime.h: $(SRC_D)\crypto\bn\bn_prime.h
	$(CP) $(SRC_D)\crypto\bn\bn_prime.h $(INCL_D)\bn_prime.h

$(INCL_D)\obj_dat.h: $(SRC_D)\crypto\objects\obj_dat.h
	$(CP) $(SRC_D)\crypto\objects\obj_dat.h $(INCL_D)\obj_dat.h

$(INCL_D)\conf_lcl.h: $(SRC_D)\crypto\conf\conf_lcl.h
	$(CP) $(SRC_D)\crypto\conf\conf_lcl.h $(INCL_D)\conf_lcl.h

$(INCL_D)\ssl_locl.h: $(SRC_D)\ssl\ssl_locl.h
	$(CP) $(SRC_D)\ssl\ssl_locl.h $(INCL_D)\ssl_locl.h

$(INCL_D)\apps.h: $(SRC_D)\apps\apps.h
	$(CP) $(SRC_D)\apps\apps.h $(INCL_D)\apps.h

$(INCL_D)\progs.h: $(SRC_D)\apps\progs.h
	$(CP) $(SRC_D)\apps\progs.h $(INCL_D)\progs.h

$(INCL_D)\s_apps.h: $(SRC_D)\apps\s_apps.h
	$(CP) $(SRC_D)\apps\s_apps.h $(INCL_D)\s_apps.h

$(INCL_D)\testdsa.h: $(SRC_D)\apps\testdsa.h
	$(CP) $(SRC_D)\apps\testdsa.h $(INCL_D)\testdsa.h

$(INCL_D)\testrsa.h: $(SRC_D)\apps\testrsa.h
	$(CP) $(SRC_D)\apps\testrsa.h $(INCL_D)\testrsa.h

$(INC_D)\e_os.h: $(SRC_D)\.\e_os.h
	$(CP) $(SRC_D)\.\e_os.h $(INC_D)\e_os.h

$(INC_D)\crypto.h: $(SRC_D)\crypto\crypto.h
	$(CP) $(SRC_D)\crypto\crypto.h $(INC_D)\crypto.h

$(INC_D)\cryptall.h: $(SRC_D)\crypto\cryptall.h
	$(CP) $(SRC_D)\crypto\cryptall.h $(INC_D)\cryptall.h

$(INC_D)\tmdiff.h: $(SRC_D)\crypto\tmdiff.h
	$(CP) $(SRC_D)\crypto\tmdiff.h $(INC_D)\tmdiff.h

$(INC_D)\md2.h: $(SRC_D)\crypto\md2\md2.h
	$(CP) $(SRC_D)\crypto\md2\md2.h $(INC_D)\md2.h

$(INC_D)\md5.h: $(SRC_D)\crypto\md5\md5.h
	$(CP) $(SRC_D)\crypto\md5\md5.h $(INC_D)\md5.h

$(INC_D)\sha.h: $(SRC_D)\crypto\sha\sha.h
	$(CP) $(SRC_D)\crypto\sha\sha.h $(INC_D)\sha.h

$(INC_D)\mdc2.h: $(SRC_D)\crypto\mdc2\mdc2.h
	$(CP) $(SRC_D)\crypto\mdc2\mdc2.h $(INC_D)\mdc2.h

$(INC_D)\hmac.h: $(SRC_D)\crypto\hmac\hmac.h
	$(CP) $(SRC_D)\crypto\hmac\hmac.h $(INC_D)\hmac.h

$(INC_D)\ripemd.h: $(SRC_D)\crypto\ripemd\ripemd.h
	$(CP) $(SRC_D)\crypto\ripemd\ripemd.h $(INC_D)\ripemd.h

$(INC_D)\des.h: $(SRC_D)\crypto\des\des.h
	$(CP) $(SRC_D)\crypto\des\des.h $(INC_D)\des.h

$(INC_D)\rc2.h: $(SRC_D)\crypto\rc2\rc2.h
	$(CP) $(SRC_D)\crypto\rc2\rc2.h $(INC_D)\rc2.h

$(INC_D)\rc4.h: $(SRC_D)\crypto\rc4\rc4.h
	$(CP) $(SRC_D)\crypto\rc4\rc4.h $(INC_D)\rc4.h

$(INC_D)\rc5.h: $(SRC_D)\crypto\rc5\rc5.h
	$(CP) $(SRC_D)\crypto\rc5\rc5.h $(INC_D)\rc5.h

$(INC_D)\idea.h: $(SRC_D)\crypto\idea\idea.h
	$(CP) $(SRC_D)\crypto\idea\idea.h $(INC_D)\idea.h

$(INC_D)\blowfish.h: $(SRC_D)\crypto\bf\blowfish.h
	$(CP) $(SRC_D)\crypto\bf\blowfish.h $(INC_D)\blowfish.h

$(INC_D)\cast.h: $(SRC_D)\crypto\cast\cast.h
	$(CP) $(SRC_D)\crypto\cast\cast.h $(INC_D)\cast.h

$(INC_D)\bn.h: $(SRC_D)\crypto\bn\bn.h
	$(CP) $(SRC_D)\crypto\bn\bn.h $(INC_D)\bn.h

$(INC_D)\rsa.h: $(SRC_D)\crypto\rsa\rsa.h
	$(CP) $(SRC_D)\crypto\rsa\rsa.h $(INC_D)\rsa.h

$(INC_D)\dsa.h: $(SRC_D)\crypto\dsa\dsa.h
	$(CP) $(SRC_D)\crypto\dsa\dsa.h $(INC_D)\dsa.h

$(INC_D)\dh.h: $(SRC_D)\crypto\dh\dh.h
	$(CP) $(SRC_D)\crypto\dh\dh.h $(INC_D)\dh.h

$(INC_D)\buffer.h: $(SRC_D)\crypto\buffer\buffer.h
	$(CP) $(SRC_D)\crypto\buffer\buffer.h $(INC_D)\buffer.h

$(INC_D)\bio.h: $(SRC_D)\crypto\bio\bio.h
	$(CP) $(SRC_D)\crypto\bio\bio.h $(INC_D)\bio.h

$(INC_D)\bss_file.c: $(SRC_D)\crypto\bio\bss_file.c
	$(CP) $(SRC_D)\crypto\bio\bss_file.c $(INC_D)\bss_file.c

$(INC_D)\stack.h: $(SRC_D)\crypto\stack\stack.h
	$(CP) $(SRC_D)\crypto\stack\stack.h $(INC_D)\stack.h

$(INC_D)\lhash.h: $(SRC_D)\crypto\lhash\lhash.h
	$(CP) $(SRC_D)\crypto\lhash\lhash.h $(INC_D)\lhash.h

$(INC_D)\rand.h: $(SRC_D)\crypto\rand\rand.h
	$(CP) $(SRC_D)\crypto\rand\rand.h $(INC_D)\rand.h

$(INC_D)\err.h: $(SRC_D)\crypto\err\err.h
	$(CP) $(SRC_D)\crypto\err\err.h $(INC_D)\err.h

$(INC_D)\objects.h: $(SRC_D)\crypto\objects\objects.h
	$(CP) $(SRC_D)\crypto\objects\objects.h $(INC_D)\objects.h

$(INC_D)\evp.h: $(SRC_D)\crypto\evp\evp.h
	$(CP) $(SRC_D)\crypto\evp\evp.h $(INC_D)\evp.h

$(INC_D)\pem.h: $(SRC_D)\crypto\pem\pem.h
	$(CP) $(SRC_D)\crypto\pem\pem.h $(INC_D)\pem.h

$(INC_D)\asn1.h: $(SRC_D)\crypto\asn1\asn1.h
	$(CP) $(SRC_D)\crypto\asn1\asn1.h $(INC_D)\asn1.h

$(INC_D)\asn1_mac.h: $(SRC_D)\crypto\asn1\asn1_mac.h
	$(CP) $(SRC_D)\crypto\asn1\asn1_mac.h $(INC_D)\asn1_mac.h

$(INC_D)\x509.h: $(SRC_D)\crypto\x509\x509.h
	$(CP) $(SRC_D)\crypto\x509\x509.h $(INC_D)\x509.h

$(INC_D)\x509_vfy.h: $(SRC_D)\crypto\x509\x509_vfy.h
	$(CP) $(SRC_D)\crypto\x509\x509_vfy.h $(INC_D)\x509_vfy.h

$(INC_D)\conf.h: $(SRC_D)\crypto\conf\conf.h
	$(CP) $(SRC_D)\crypto\conf\conf.h $(INC_D)\conf.h

$(INC_D)\txt_db.h: $(SRC_D)\crypto\txt_db\txt_db.h
	$(CP) $(SRC_D)\crypto\txt_db\txt_db.h $(INC_D)\txt_db.h

$(INC_D)\pkcs7.h: $(SRC_D)\crypto\pkcs7\pkcs7.h
	$(CP) $(SRC_D)\crypto\pkcs7\pkcs7.h $(INC_D)\pkcs7.h

$(INC_D)\comp.h: $(SRC_D)\crypto\comp\comp.h
	$(CP) $(SRC_D)\crypto\comp\comp.h $(INC_D)\comp.h

$(INC_D)\ssl.h: $(SRC_D)\ssl\ssl.h
	$(CP) $(SRC_D)\ssl\ssl.h $(INC_D)\ssl.h

$(INC_D)\ssl2.h: $(SRC_D)\ssl\ssl2.h
	$(CP) $(SRC_D)\ssl\ssl2.h $(INC_D)\ssl2.h

$(INC_D)\ssl3.h: $(SRC_D)\ssl\ssl3.h
	$(CP) $(SRC_D)\ssl\ssl3.h $(INC_D)\ssl3.h

$(INC_D)\ssl23.h: $(SRC_D)\ssl\ssl23.h
	$(CP) $(SRC_D)\ssl\ssl23.h $(INC_D)\ssl23.h

$(INC_D)\tls1.h: $(SRC_D)\ssl\tls1.h
	$(CP) $(SRC_D)\ssl\tls1.h $(INC_D)\tls1.h

$(INC_D)\rsaref.h: $(SRC_D)\rsaref\rsaref.h
	$(CP) $(SRC_D)\rsaref\rsaref.h $(INC_D)\rsaref.h

$(OBJ_D)\md2test.obj: $(SRC_D)\crypto\md2\md2test.c
	$(CC) /Fo$(OBJ_D)\md2test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\md2\md2test.c

$(OBJ_D)\md5test.obj: $(SRC_D)\crypto\md5\md5test.c
	$(CC) /Fo$(OBJ_D)\md5test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\md5\md5test.c

$(OBJ_D)\shatest.obj: $(SRC_D)\crypto\sha\shatest.c
	$(CC) /Fo$(OBJ_D)\shatest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\shatest.c

$(OBJ_D)\sha1test.obj: $(SRC_D)\crypto\sha\sha1test.c
	$(CC) /Fo$(OBJ_D)\sha1test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\sha1test.c

$(OBJ_D)\mdc2test.obj: $(SRC_D)\crypto\mdc2\mdc2test.c
	$(CC) /Fo$(OBJ_D)\mdc2test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\mdc2\mdc2test.c

$(OBJ_D)\hmactest.obj: $(SRC_D)\crypto\hmac\hmactest.c
	$(CC) /Fo$(OBJ_D)\hmactest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\hmac\hmactest.c

$(OBJ_D)\rmdtest.obj: $(SRC_D)\crypto\ripemd\rmdtest.c
	$(CC) /Fo$(OBJ_D)\rmdtest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\ripemd\rmdtest.c

$(OBJ_D)\destest.obj: $(SRC_D)\crypto\des\destest.c
	$(CC) /Fo$(OBJ_D)\destest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\des\destest.c

$(OBJ_D)\rc2test.obj: $(SRC_D)\crypto\rc2\rc2test.c
	$(CC) /Fo$(OBJ_D)\rc2test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2test.c

$(OBJ_D)\rc4test.obj: $(SRC_D)\crypto\rc4\rc4test.c
	$(CC) /Fo$(OBJ_D)\rc4test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4test.c

$(OBJ_D)\rc5test.obj: $(SRC_D)\crypto\rc5\rc5test.c
	$(CC) /Fo$(OBJ_D)\rc5test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rc5\rc5test.c

$(OBJ_D)\ideatest.obj: $(SRC_D)\crypto\idea\ideatest.c
	$(CC) /Fo$(OBJ_D)\ideatest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\idea\ideatest.c

$(OBJ_D)\bftest.obj: $(SRC_D)\crypto\bf\bftest.c
	$(CC) /Fo$(OBJ_D)\bftest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\bf\bftest.c

$(OBJ_D)\casttest.obj: $(SRC_D)\crypto\cast\casttest.c
	$(CC) /Fo$(OBJ_D)\casttest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\cast\casttest.c

$(OBJ_D)\bntest.obj: $(SRC_D)\crypto\bn\bntest.c
	$(CC) /Fo$(OBJ_D)\bntest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\bn\bntest.c

$(OBJ_D)\exptest.obj: $(SRC_D)\crypto\bn\exptest.c
	$(CC) /Fo$(OBJ_D)\exptest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\bn\exptest.c

$(OBJ_D)\dsatest.obj: $(SRC_D)\crypto\dsa\dsatest.c
	$(CC) /Fo$(OBJ_D)\dsatest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\dsa\dsatest.c

$(OBJ_D)\dhtest.obj: $(SRC_D)\crypto\dh\dhtest.c
	$(CC) /Fo$(OBJ_D)\dhtest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\dh\dhtest.c

$(OBJ_D)\randtest.obj: $(SRC_D)\crypto\rand\randtest.c
	$(CC) /Fo$(OBJ_D)\randtest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rand\randtest.c

$(OBJ_D)\ssltest.obj: $(SRC_D)\ssl\ssltest.c
	$(CC) /Fo$(OBJ_D)\ssltest.obj $(APP_CFLAGS) -c $(SRC_D)\ssl\ssltest.c

$(OBJ_D)\verify.obj: $(SRC_D)\apps\verify.c
	$(CC) /Fo$(OBJ_D)\verify.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\verify.c

$(OBJ_D)\asn1pars.obj: $(SRC_D)\apps\asn1pars.c
	$(CC) /Fo$(OBJ_D)\asn1pars.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\asn1pars.c

$(OBJ_D)\req.obj: $(SRC_D)\apps\req.c
	$(CC) /Fo$(OBJ_D)\req.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\req.c

$(OBJ_D)\dgst.obj: $(SRC_D)\apps\dgst.c
	$(CC) /Fo$(OBJ_D)\dgst.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dgst.c

$(OBJ_D)\dh.obj: $(SRC_D)\apps\dh.c
	$(CC) /Fo$(OBJ_D)\dh.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dh.c

$(OBJ_D)\enc.obj: $(SRC_D)\apps\enc.c
	$(CC) /Fo$(OBJ_D)\enc.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\enc.c

$(OBJ_D)\gendh.obj: $(SRC_D)\apps\gendh.c
	$(CC) /Fo$(OBJ_D)\gendh.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\gendh.c

$(OBJ_D)\errstr.obj: $(SRC_D)\apps\errstr.c
	$(CC) /Fo$(OBJ_D)\errstr.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\errstr.c

$(OBJ_D)\ca.obj: $(SRC_D)\apps\ca.c
	$(CC) /Fo$(OBJ_D)\ca.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ca.c

$(OBJ_D)\pkcs7.obj: $(SRC_D)\apps\pkcs7.c
	$(CC) /Fo$(OBJ_D)\pkcs7.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\pkcs7.c

$(OBJ_D)\crl2p7.obj: $(SRC_D)\apps\crl2p7.c
	$(CC) /Fo$(OBJ_D)\crl2p7.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\crl2p7.c

$(OBJ_D)\crl.obj: $(SRC_D)\apps\crl.c
	$(CC) /Fo$(OBJ_D)\crl.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\crl.c

$(OBJ_D)\rsa.obj: $(SRC_D)\apps\rsa.c
	$(CC) /Fo$(OBJ_D)\rsa.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\rsa.c

$(OBJ_D)\dsa.obj: $(SRC_D)\apps\dsa.c
	$(CC) /Fo$(OBJ_D)\dsa.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dsa.c

$(OBJ_D)\dsaparam.obj: $(SRC_D)\apps\dsaparam.c
	$(CC) /Fo$(OBJ_D)\dsaparam.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dsaparam.c

$(OBJ_D)\x509.obj: $(SRC_D)\apps\x509.c
	$(CC) /Fo$(OBJ_D)\x509.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\x509.c

$(OBJ_D)\genrsa.obj: $(SRC_D)\apps\genrsa.c
	$(CC) /Fo$(OBJ_D)\genrsa.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\genrsa.c

$(OBJ_D)\s_server.obj: $(SRC_D)\apps\s_server.c
	$(CC) /Fo$(OBJ_D)\s_server.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_server.c

$(OBJ_D)\s_client.obj: $(SRC_D)\apps\s_client.c
	$(CC) /Fo$(OBJ_D)\s_client.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_client.c

$(OBJ_D)\speed.obj: $(SRC_D)\apps\speed.c
	$(CC) /Fo$(OBJ_D)\speed.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\speed.c

$(OBJ_D)\s_time.obj: $(SRC_D)\apps\s_time.c
	$(CC) /Fo$(OBJ_D)\s_time.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_time.c

$(OBJ_D)\apps.obj: $(SRC_D)\apps\apps.c
	$(CC) /Fo$(OBJ_D)\apps.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\apps.c

$(OBJ_D)\s_cb.obj: $(SRC_D)\apps\s_cb.c
	$(CC) /Fo$(OBJ_D)\s_cb.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_cb.c

$(OBJ_D)\s_socket.obj: $(SRC_D)\apps\s_socket.c
	$(CC) /Fo$(OBJ_D)\s_socket.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_socket.c

$(OBJ_D)\version.obj: $(SRC_D)\apps\version.c
	$(CC) /Fo$(OBJ_D)\version.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\version.c

$(OBJ_D)\sess_id.obj: $(SRC_D)\apps\sess_id.c
	$(CC) /Fo$(OBJ_D)\sess_id.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\sess_id.c

$(OBJ_D)\ciphers.obj: $(SRC_D)\apps\ciphers.c
	$(CC) /Fo$(OBJ_D)\ciphers.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ciphers.c

$(OBJ_D)\ssleay.obj: $(SRC_D)\apps\ssleay.c
	$(CC) /Fo$(OBJ_D)\ssleay.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ssleay.c

crypto\bn\asm\bn-win32.obj: crypto\bn\asm\bn-win32.asm
	$(ASM) /Focrypto\bn\asm\bn-win32.obj $(SRC_D)\crypto\bn\asm\bn-win32.asm

crypto\des\asm\d-win32.obj: crypto\des\asm\d-win32.asm
	$(ASM) /Focrypto\des\asm\d-win32.obj $(SRC_D)\crypto\des\asm\d-win32.asm

crypto\des\asm\y-win32.obj: crypto\des\asm\y-win32.asm
	$(ASM) /Focrypto\des\asm\y-win32.obj $(SRC_D)\crypto\des\asm\y-win32.asm

crypto\bf\asm\b-win32.obj: crypto\bf\asm\b-win32.asm
	$(ASM) /Focrypto\bf\asm\b-win32.obj $(SRC_D)\crypto\bf\asm\b-win32.asm

crypto\cast\asm\c-win32.obj: crypto\cast\asm\c-win32.asm
	$(ASM) /Focrypto\cast\asm\c-win32.obj $(SRC_D)\crypto\cast\asm\c-win32.asm

crypto\rc4\asm\r4-win32.obj: crypto\rc4\asm\r4-win32.asm
	$(ASM) /Focrypto\rc4\asm\r4-win32.obj $(SRC_D)\crypto\rc4\asm\r4-win32.asm

crypto\rc5\asm\r5-win32.obj: crypto\rc5\asm\r5-win32.asm
	$(ASM) /Focrypto\rc5\asm\r5-win32.obj $(SRC_D)\crypto\rc5\asm\r5-win32.asm

crypto\md5\asm\m5-win32.obj: crypto\md5\asm\m5-win32.asm
	$(ASM) /Focrypto\md5\asm\m5-win32.obj $(SRC_D)\crypto\md5\asm\m5-win32.asm

crypto\sha\asm\s1-win32.obj: crypto\sha\asm\s1-win32.asm
	$(ASM) /Focrypto\sha\asm\s1-win32.obj $(SRC_D)\crypto\sha\asm\s1-win32.asm

crypto\ripemd\asm\rm-win32.obj: crypto\ripemd\asm\rm-win32.asm
	$(ASM) /Focrypto\ripemd\asm\rm-win32.obj $(SRC_D)\crypto\ripemd\asm\rm-win32.asm

$(OBJ_D)\cryptlib.obj: $(SRC_D)\crypto\cryptlib.c
	$(CC) /Fo$(OBJ_D)\cryptlib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cryptlib.c

$(OBJ_D)\mem.obj: $(SRC_D)\crypto\mem.c
	$(CC) /Fo$(OBJ_D)\mem.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\mem.c

$(OBJ_D)\cversion.obj: $(SRC_D)\crypto\cversion.c
	$(CC) /Fo$(OBJ_D)\cversion.obj  $(SHLIB_CFLAGS) -DCFLAGS="\"$(CC) $(CFLAG)\"" -DPLATFORM="\"$(PLATFORM)\"" -c $(SRC_D)\crypto\cversion.c

$(OBJ_D)\ex_data.obj: $(SRC_D)\crypto\ex_data.c
	$(CC) /Fo$(OBJ_D)\ex_data.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\ex_data.c

$(OBJ_D)\tmdiff.obj: $(SRC_D)\crypto\tmdiff.c
	$(CC) /Fo$(OBJ_D)\tmdiff.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\tmdiff.c

$(OBJ_D)\cpt_err.obj: $(SRC_D)\crypto\cpt_err.c
	$(CC) /Fo$(OBJ_D)\cpt_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cpt_err.c

$(OBJ_D)\md2_dgst.obj: $(SRC_D)\crypto\md2\md2_dgst.c
	$(CC) /Fo$(OBJ_D)\md2_dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\md2\md2_dgst.c

$(OBJ_D)\md2_one.obj: $(SRC_D)\crypto\md2\md2_one.c
	$(CC) /Fo$(OBJ_D)\md2_one.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\md2\md2_one.c

$(OBJ_D)\md5_dgst.obj: $(SRC_D)\crypto\md5\md5_dgst.c
	$(CC) /Fo$(OBJ_D)\md5_dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\md5\md5_dgst.c

$(OBJ_D)\md5_one.obj: $(SRC_D)\crypto\md5\md5_one.c
	$(CC) /Fo$(OBJ_D)\md5_one.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\md5\md5_one.c

$(OBJ_D)\sha_dgst.obj: $(SRC_D)\crypto\sha\sha_dgst.c
	$(CC) /Fo$(OBJ_D)\sha_dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha_dgst.c

$(OBJ_D)\sha1dgst.obj: $(SRC_D)\crypto\sha\sha1dgst.c
	$(CC) /Fo$(OBJ_D)\sha1dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha1dgst.c

$(OBJ_D)\sha_one.obj: $(SRC_D)\crypto\sha\sha_one.c
	$(CC) /Fo$(OBJ_D)\sha_one.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha_one.c

$(OBJ_D)\sha1_one.obj: $(SRC_D)\crypto\sha\sha1_one.c
	$(CC) /Fo$(OBJ_D)\sha1_one.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha1_one.c

$(OBJ_D)\mdc2dgst.obj: $(SRC_D)\crypto\mdc2\mdc2dgst.c
	$(CC) /Fo$(OBJ_D)\mdc2dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\mdc2\mdc2dgst.c

$(OBJ_D)\mdc2_one.obj: $(SRC_D)\crypto\mdc2\mdc2_one.c
	$(CC) /Fo$(OBJ_D)\mdc2_one.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\mdc2\mdc2_one.c

$(OBJ_D)\hmac.obj: $(SRC_D)\crypto\hmac\hmac.c
	$(CC) /Fo$(OBJ_D)\hmac.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\hmac\hmac.c

$(OBJ_D)\rmd_dgst.obj: $(SRC_D)\crypto\ripemd\rmd_dgst.c
	$(CC) /Fo$(OBJ_D)\rmd_dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\ripemd\rmd_dgst.c

$(OBJ_D)\rmd_one.obj: $(SRC_D)\crypto\ripemd\rmd_one.c
	$(CC) /Fo$(OBJ_D)\rmd_one.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\ripemd\rmd_one.c

$(OBJ_D)\set_key.obj: $(SRC_D)\crypto\des\set_key.c
	$(CC) /Fo$(OBJ_D)\set_key.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\set_key.c

$(OBJ_D)\ecb_enc.obj: $(SRC_D)\crypto\des\ecb_enc.c
	$(CC) /Fo$(OBJ_D)\ecb_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\ecb_enc.c

$(OBJ_D)\cbc_enc.obj: $(SRC_D)\crypto\des\cbc_enc.c
	$(CC) /Fo$(OBJ_D)\cbc_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc_enc.c

$(OBJ_D)\ecb3_enc.obj: $(SRC_D)\crypto\des\ecb3_enc.c
	$(CC) /Fo$(OBJ_D)\ecb3_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\ecb3_enc.c

$(OBJ_D)\cfb64enc.obj: $(SRC_D)\crypto\des\cfb64enc.c
	$(CC) /Fo$(OBJ_D)\cfb64enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb64enc.c

$(OBJ_D)\cfb64ede.obj: $(SRC_D)\crypto\des\cfb64ede.c
	$(CC) /Fo$(OBJ_D)\cfb64ede.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb64ede.c

$(OBJ_D)\cfb_enc.obj: $(SRC_D)\crypto\des\cfb_enc.c
	$(CC) /Fo$(OBJ_D)\cfb_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb_enc.c

$(OBJ_D)\ofb64ede.obj: $(SRC_D)\crypto\des\ofb64ede.c
	$(CC) /Fo$(OBJ_D)\ofb64ede.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb64ede.c

$(OBJ_D)\enc_read.obj: $(SRC_D)\crypto\des\enc_read.c
	$(CC) /Fo$(OBJ_D)\enc_read.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\enc_read.c

$(OBJ_D)\enc_writ.obj: $(SRC_D)\crypto\des\enc_writ.c
	$(CC) /Fo$(OBJ_D)\enc_writ.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\enc_writ.c

$(OBJ_D)\ofb64enc.obj: $(SRC_D)\crypto\des\ofb64enc.c
	$(CC) /Fo$(OBJ_D)\ofb64enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb64enc.c

$(OBJ_D)\ofb_enc.obj: $(SRC_D)\crypto\des\ofb_enc.c
	$(CC) /Fo$(OBJ_D)\ofb_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb_enc.c

$(OBJ_D)\str2key.obj: $(SRC_D)\crypto\des\str2key.c
	$(CC) /Fo$(OBJ_D)\str2key.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\str2key.c

$(OBJ_D)\pcbc_enc.obj: $(SRC_D)\crypto\des\pcbc_enc.c
	$(CC) /Fo$(OBJ_D)\pcbc_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\pcbc_enc.c

$(OBJ_D)\qud_cksm.obj: $(SRC_D)\crypto\des\qud_cksm.c
	$(CC) /Fo$(OBJ_D)\qud_cksm.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\qud_cksm.c

$(OBJ_D)\rand_key.obj: $(SRC_D)\crypto\des\rand_key.c
	$(CC) /Fo$(OBJ_D)\rand_key.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\rand_key.c

$(OBJ_D)\des_enc.obj: $(SRC_D)\crypto\des\des_enc.c
	$(CC) /Fo$(OBJ_D)\des_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\des_enc.c

$(OBJ_D)\fcrypt_b.obj: $(SRC_D)\crypto\des\fcrypt_b.c
	$(CC) /Fo$(OBJ_D)\fcrypt_b.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\fcrypt_b.c

$(OBJ_D)\read2pwd.obj: $(SRC_D)\crypto\des\read2pwd.c
	$(CC) /Fo$(OBJ_D)\read2pwd.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\read2pwd.c

$(OBJ_D)\fcrypt.obj: $(SRC_D)\crypto\des\fcrypt.c
	$(CC) /Fo$(OBJ_D)\fcrypt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\fcrypt.c

$(OBJ_D)\xcbc_enc.obj: $(SRC_D)\crypto\des\xcbc_enc.c
	$(CC) /Fo$(OBJ_D)\xcbc_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\xcbc_enc.c

$(OBJ_D)\read_pwd.obj: $(SRC_D)\crypto\des\read_pwd.c
	$(CC) /Fo$(OBJ_D)\read_pwd.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\read_pwd.c

$(OBJ_D)\rpc_enc.obj: $(SRC_D)\crypto\des\rpc_enc.c
	$(CC) /Fo$(OBJ_D)\rpc_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\rpc_enc.c

$(OBJ_D)\cbc_cksm.obj: $(SRC_D)\crypto\des\cbc_cksm.c
	$(CC) /Fo$(OBJ_D)\cbc_cksm.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc_cksm.c

$(OBJ_D)\supp.obj: $(SRC_D)\crypto\des\supp.c
	$(CC) /Fo$(OBJ_D)\supp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\des\supp.c

$(OBJ_D)\rc2_ecb.obj: $(SRC_D)\crypto\rc2\rc2_ecb.c
	$(CC) /Fo$(OBJ_D)\rc2_ecb.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_ecb.c

$(OBJ_D)\rc2_skey.obj: $(SRC_D)\crypto\rc2\rc2_skey.c
	$(CC) /Fo$(OBJ_D)\rc2_skey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_skey.c

$(OBJ_D)\rc2_cbc.obj: $(SRC_D)\crypto\rc2\rc2_cbc.c
	$(CC) /Fo$(OBJ_D)\rc2_cbc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_cbc.c

$(OBJ_D)\rc2cfb64.obj: $(SRC_D)\crypto\rc2\rc2cfb64.c
	$(CC) /Fo$(OBJ_D)\rc2cfb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2cfb64.c

$(OBJ_D)\rc2ofb64.obj: $(SRC_D)\crypto\rc2\rc2ofb64.c
	$(CC) /Fo$(OBJ_D)\rc2ofb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2ofb64.c

$(OBJ_D)\rc4_skey.obj: $(SRC_D)\crypto\rc4\rc4_skey.c
	$(CC) /Fo$(OBJ_D)\rc4_skey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4_skey.c

$(OBJ_D)\rc4_enc.obj: $(SRC_D)\crypto\rc4\rc4_enc.c
	$(CC) /Fo$(OBJ_D)\rc4_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4_enc.c

$(OBJ_D)\rc5_skey.obj: $(SRC_D)\crypto\rc5\rc5_skey.c
	$(CC) /Fo$(OBJ_D)\rc5_skey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc5\rc5_skey.c

$(OBJ_D)\rc5_ecb.obj: $(SRC_D)\crypto\rc5\rc5_ecb.c
	$(CC) /Fo$(OBJ_D)\rc5_ecb.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc5\rc5_ecb.c

$(OBJ_D)\rc5_enc.obj: $(SRC_D)\crypto\rc5\rc5_enc.c
	$(CC) /Fo$(OBJ_D)\rc5_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc5\rc5_enc.c

$(OBJ_D)\rc5cfb64.obj: $(SRC_D)\crypto\rc5\rc5cfb64.c
	$(CC) /Fo$(OBJ_D)\rc5cfb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc5\rc5cfb64.c

$(OBJ_D)\rc5ofb64.obj: $(SRC_D)\crypto\rc5\rc5ofb64.c
	$(CC) /Fo$(OBJ_D)\rc5ofb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rc5\rc5ofb64.c

$(OBJ_D)\i_cbc.obj: $(SRC_D)\crypto\idea\i_cbc.c
	$(CC) /Fo$(OBJ_D)\i_cbc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_cbc.c

$(OBJ_D)\i_cfb64.obj: $(SRC_D)\crypto\idea\i_cfb64.c
	$(CC) /Fo$(OBJ_D)\i_cfb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_cfb64.c

$(OBJ_D)\i_ofb64.obj: $(SRC_D)\crypto\idea\i_ofb64.c
	$(CC) /Fo$(OBJ_D)\i_ofb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_ofb64.c

$(OBJ_D)\i_ecb.obj: $(SRC_D)\crypto\idea\i_ecb.c
	$(CC) /Fo$(OBJ_D)\i_ecb.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_ecb.c

$(OBJ_D)\i_skey.obj: $(SRC_D)\crypto\idea\i_skey.c
	$(CC) /Fo$(OBJ_D)\i_skey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_skey.c

$(OBJ_D)\bf_skey.obj: $(SRC_D)\crypto\bf\bf_skey.c
	$(CC) /Fo$(OBJ_D)\bf_skey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_skey.c

$(OBJ_D)\bf_ecb.obj: $(SRC_D)\crypto\bf\bf_ecb.c
	$(CC) /Fo$(OBJ_D)\bf_ecb.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_ecb.c

$(OBJ_D)\bf_enc.obj: $(SRC_D)\crypto\bf\bf_enc.c
	$(CC) /Fo$(OBJ_D)\bf_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_enc.c

$(OBJ_D)\bf_cfb64.obj: $(SRC_D)\crypto\bf\bf_cfb64.c
	$(CC) /Fo$(OBJ_D)\bf_cfb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_cfb64.c

$(OBJ_D)\bf_ofb64.obj: $(SRC_D)\crypto\bf\bf_ofb64.c
	$(CC) /Fo$(OBJ_D)\bf_ofb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_ofb64.c

$(OBJ_D)\c_skey.obj: $(SRC_D)\crypto\cast\c_skey.c
	$(CC) /Fo$(OBJ_D)\c_skey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_skey.c

$(OBJ_D)\c_ecb.obj: $(SRC_D)\crypto\cast\c_ecb.c
	$(CC) /Fo$(OBJ_D)\c_ecb.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_ecb.c

$(OBJ_D)\c_enc.obj: $(SRC_D)\crypto\cast\c_enc.c
	$(CC) /Fo$(OBJ_D)\c_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_enc.c

$(OBJ_D)\c_cfb64.obj: $(SRC_D)\crypto\cast\c_cfb64.c
	$(CC) /Fo$(OBJ_D)\c_cfb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_cfb64.c

$(OBJ_D)\c_ofb64.obj: $(SRC_D)\crypto\cast\c_ofb64.c
	$(CC) /Fo$(OBJ_D)\c_ofb64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_ofb64.c

$(OBJ_D)\bn_add.obj: $(SRC_D)\crypto\bn\bn_add.c
	$(CC) /Fo$(OBJ_D)\bn_add.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_add.c

$(OBJ_D)\bn_div.obj: $(SRC_D)\crypto\bn\bn_div.c
	$(CC) /Fo$(OBJ_D)\bn_div.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_div.c

$(OBJ_D)\bn_exp.obj: $(SRC_D)\crypto\bn\bn_exp.c
	$(CC) /Fo$(OBJ_D)\bn_exp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_exp.c

$(OBJ_D)\bn_lib.obj: $(SRC_D)\crypto\bn\bn_lib.c
	$(CC) /Fo$(OBJ_D)\bn_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_lib.c

$(OBJ_D)\bn_mul.obj: $(SRC_D)\crypto\bn\bn_mul.c
	$(CC) /Fo$(OBJ_D)\bn_mul.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mul.c

$(OBJ_D)\bn_print.obj: $(SRC_D)\crypto\bn\bn_print.c
	$(CC) /Fo$(OBJ_D)\bn_print.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_print.c

$(OBJ_D)\bn_rand.obj: $(SRC_D)\crypto\bn\bn_rand.c
	$(CC) /Fo$(OBJ_D)\bn_rand.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_rand.c

$(OBJ_D)\bn_shift.obj: $(SRC_D)\crypto\bn\bn_shift.c
	$(CC) /Fo$(OBJ_D)\bn_shift.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_shift.c

$(OBJ_D)\bn_word.obj: $(SRC_D)\crypto\bn\bn_word.c
	$(CC) /Fo$(OBJ_D)\bn_word.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_word.c

$(OBJ_D)\bn_blind.obj: $(SRC_D)\crypto\bn\bn_blind.c
	$(CC) /Fo$(OBJ_D)\bn_blind.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_blind.c

$(OBJ_D)\bn_gcd.obj: $(SRC_D)\crypto\bn\bn_gcd.c
	$(CC) /Fo$(OBJ_D)\bn_gcd.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_gcd.c

$(OBJ_D)\bn_prime.obj: $(SRC_D)\crypto\bn\bn_prime.c
	$(CC) /Fo$(OBJ_D)\bn_prime.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_prime.c

$(OBJ_D)\bn_err.obj: $(SRC_D)\crypto\bn\bn_err.c
	$(CC) /Fo$(OBJ_D)\bn_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_err.c

$(OBJ_D)\bn_sqr.obj: $(SRC_D)\crypto\bn\bn_sqr.c
	$(CC) /Fo$(OBJ_D)\bn_sqr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_sqr.c

$(OBJ_D)\bn_asm.obj: $(SRC_D)\crypto\bn\bn_asm.c
	$(CC) /Fo$(OBJ_D)\bn_asm.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_asm.c

$(OBJ_D)\bn_recp.obj: $(SRC_D)\crypto\bn\bn_recp.c
	$(CC) /Fo$(OBJ_D)\bn_recp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_recp.c

$(OBJ_D)\bn_mont.obj: $(SRC_D)\crypto\bn\bn_mont.c
	$(CC) /Fo$(OBJ_D)\bn_mont.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mont.c

$(OBJ_D)\bn_mpi.obj: $(SRC_D)\crypto\bn\bn_mpi.c
	$(CC) /Fo$(OBJ_D)\bn_mpi.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mpi.c

$(OBJ_D)\bn_exp2.obj: $(SRC_D)\crypto\bn\bn_exp2.c
	$(CC) /Fo$(OBJ_D)\bn_exp2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_exp2.c

$(OBJ_D)\rsa_eay.obj: $(SRC_D)\crypto\rsa\rsa_eay.c
	$(CC) /Fo$(OBJ_D)\rsa_eay.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_eay.c

$(OBJ_D)\rsa_gen.obj: $(SRC_D)\crypto\rsa\rsa_gen.c
	$(CC) /Fo$(OBJ_D)\rsa_gen.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_gen.c

$(OBJ_D)\rsa_lib.obj: $(SRC_D)\crypto\rsa\rsa_lib.c
	$(CC) /Fo$(OBJ_D)\rsa_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_lib.c

$(OBJ_D)\rsa_sign.obj: $(SRC_D)\crypto\rsa\rsa_sign.c
	$(CC) /Fo$(OBJ_D)\rsa_sign.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_sign.c

$(OBJ_D)\rsa_saos.obj: $(SRC_D)\crypto\rsa\rsa_saos.c
	$(CC) /Fo$(OBJ_D)\rsa_saos.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_saos.c

$(OBJ_D)\rsa_err.obj: $(SRC_D)\crypto\rsa\rsa_err.c
	$(CC) /Fo$(OBJ_D)\rsa_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_err.c

$(OBJ_D)\rsa_pk1.obj: $(SRC_D)\crypto\rsa\rsa_pk1.c
	$(CC) /Fo$(OBJ_D)\rsa_pk1.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_pk1.c

$(OBJ_D)\rsa_ssl.obj: $(SRC_D)\crypto\rsa\rsa_ssl.c
	$(CC) /Fo$(OBJ_D)\rsa_ssl.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_ssl.c

$(OBJ_D)\rsa_none.obj: $(SRC_D)\crypto\rsa\rsa_none.c
	$(CC) /Fo$(OBJ_D)\rsa_none.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_none.c

$(OBJ_D)\dsa_gen.obj: $(SRC_D)\crypto\dsa\dsa_gen.c
	$(CC) /Fo$(OBJ_D)\dsa_gen.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_gen.c

$(OBJ_D)\dsa_key.obj: $(SRC_D)\crypto\dsa\dsa_key.c
	$(CC) /Fo$(OBJ_D)\dsa_key.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_key.c

$(OBJ_D)\dsa_lib.obj: $(SRC_D)\crypto\dsa\dsa_lib.c
	$(CC) /Fo$(OBJ_D)\dsa_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_lib.c

$(OBJ_D)\dsa_vrf.obj: $(SRC_D)\crypto\dsa\dsa_vrf.c
	$(CC) /Fo$(OBJ_D)\dsa_vrf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_vrf.c

$(OBJ_D)\dsa_sign.obj: $(SRC_D)\crypto\dsa\dsa_sign.c
	$(CC) /Fo$(OBJ_D)\dsa_sign.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_sign.c

$(OBJ_D)\dsa_err.obj: $(SRC_D)\crypto\dsa\dsa_err.c
	$(CC) /Fo$(OBJ_D)\dsa_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_err.c

$(OBJ_D)\dh_gen.obj: $(SRC_D)\crypto\dh\dh_gen.c
	$(CC) /Fo$(OBJ_D)\dh_gen.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_gen.c

$(OBJ_D)\dh_key.obj: $(SRC_D)\crypto\dh\dh_key.c
	$(CC) /Fo$(OBJ_D)\dh_key.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_key.c

$(OBJ_D)\dh_lib.obj: $(SRC_D)\crypto\dh\dh_lib.c
	$(CC) /Fo$(OBJ_D)\dh_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_lib.c

$(OBJ_D)\dh_check.obj: $(SRC_D)\crypto\dh\dh_check.c
	$(CC) /Fo$(OBJ_D)\dh_check.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_check.c

$(OBJ_D)\dh_err.obj: $(SRC_D)\crypto\dh\dh_err.c
	$(CC) /Fo$(OBJ_D)\dh_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_err.c

$(OBJ_D)\buffer.obj: $(SRC_D)\crypto\buffer\buffer.c
	$(CC) /Fo$(OBJ_D)\buffer.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\buffer\buffer.c

$(OBJ_D)\buf_err.obj: $(SRC_D)\crypto\buffer\buf_err.c
	$(CC) /Fo$(OBJ_D)\buf_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\buffer\buf_err.c

$(OBJ_D)\bio_lib.obj: $(SRC_D)\crypto\bio\bio_lib.c
	$(CC) /Fo$(OBJ_D)\bio_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bio_lib.c

$(OBJ_D)\bio_cb.obj: $(SRC_D)\crypto\bio\bio_cb.c
	$(CC) /Fo$(OBJ_D)\bio_cb.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bio_cb.c

$(OBJ_D)\bio_err.obj: $(SRC_D)\crypto\bio\bio_err.c
	$(CC) /Fo$(OBJ_D)\bio_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bio_err.c

$(OBJ_D)\bss_mem.obj: $(SRC_D)\crypto\bio\bss_mem.c
	$(CC) /Fo$(OBJ_D)\bss_mem.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_mem.c

$(OBJ_D)\bss_null.obj: $(SRC_D)\crypto\bio\bss_null.c
	$(CC) /Fo$(OBJ_D)\bss_null.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_null.c

$(OBJ_D)\bss_fd.obj: $(SRC_D)\crypto\bio\bss_fd.c
	$(CC) /Fo$(OBJ_D)\bss_fd.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_fd.c

$(OBJ_D)\bss_file.obj: $(SRC_D)\crypto\bio\bss_file.c
	$(CC) /Fo$(OBJ_D)\bss_file.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_file.c

$(OBJ_D)\bss_sock.obj: $(SRC_D)\crypto\bio\bss_sock.c
	$(CC) /Fo$(OBJ_D)\bss_sock.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_sock.c

$(OBJ_D)\bss_conn.obj: $(SRC_D)\crypto\bio\bss_conn.c
	$(CC) /Fo$(OBJ_D)\bss_conn.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_conn.c

$(OBJ_D)\bf_null.obj: $(SRC_D)\crypto\bio\bf_null.c
	$(CC) /Fo$(OBJ_D)\bf_null.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bf_null.c

$(OBJ_D)\bf_buff.obj: $(SRC_D)\crypto\bio\bf_buff.c
	$(CC) /Fo$(OBJ_D)\bf_buff.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bf_buff.c

$(OBJ_D)\b_print.obj: $(SRC_D)\crypto\bio\b_print.c
	$(CC) /Fo$(OBJ_D)\b_print.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\b_print.c

$(OBJ_D)\b_dump.obj: $(SRC_D)\crypto\bio\b_dump.c
	$(CC) /Fo$(OBJ_D)\b_dump.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\b_dump.c

$(OBJ_D)\b_sock.obj: $(SRC_D)\crypto\bio\b_sock.c
	$(CC) /Fo$(OBJ_D)\b_sock.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\b_sock.c

$(OBJ_D)\bss_acpt.obj: $(SRC_D)\crypto\bio\bss_acpt.c
	$(CC) /Fo$(OBJ_D)\bss_acpt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_acpt.c

$(OBJ_D)\bf_nbio.obj: $(SRC_D)\crypto\bio\bf_nbio.c
	$(CC) /Fo$(OBJ_D)\bf_nbio.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\bio\bf_nbio.c

$(OBJ_D)\stack.obj: $(SRC_D)\crypto\stack\stack.c
	$(CC) /Fo$(OBJ_D)\stack.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\stack\stack.c

$(OBJ_D)\lhash.obj: $(SRC_D)\crypto\lhash\lhash.c
	$(CC) /Fo$(OBJ_D)\lhash.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\lhash\lhash.c

$(OBJ_D)\lh_stats.obj: $(SRC_D)\crypto\lhash\lh_stats.c
	$(CC) /Fo$(OBJ_D)\lh_stats.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\lhash\lh_stats.c

$(OBJ_D)\md_rand.obj: $(SRC_D)\crypto\rand\md_rand.c
	$(CC) /Fo$(OBJ_D)\md_rand.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rand\md_rand.c

$(OBJ_D)\randfile.obj: $(SRC_D)\crypto\rand\randfile.c
	$(CC) /Fo$(OBJ_D)\randfile.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rand\randfile.c

$(OBJ_D)\rand_lib.obj: $(SRC_D)\crypto\rand\rand_lib.c
	$(CC) /Fo$(OBJ_D)\rand_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_lib.c

$(OBJ_D)\err.obj: $(SRC_D)\crypto\err\err.c
	$(CC) /Fo$(OBJ_D)\err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\err\err.c

$(OBJ_D)\err_all.obj: $(SRC_D)\crypto\err\err_all.c
	$(CC) /Fo$(OBJ_D)\err_all.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\err\err_all.c

$(OBJ_D)\err_prn.obj: $(SRC_D)\crypto\err\err_prn.c
	$(CC) /Fo$(OBJ_D)\err_prn.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\err\err_prn.c

$(OBJ_D)\o_names.obj: $(SRC_D)\crypto\objects\o_names.c
	$(CC) /Fo$(OBJ_D)\o_names.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\objects\o_names.c

$(OBJ_D)\obj_dat.obj: $(SRC_D)\crypto\objects\obj_dat.c
	$(CC) /Fo$(OBJ_D)\obj_dat.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_dat.c

$(OBJ_D)\obj_lib.obj: $(SRC_D)\crypto\objects\obj_lib.c
	$(CC) /Fo$(OBJ_D)\obj_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_lib.c

$(OBJ_D)\obj_err.obj: $(SRC_D)\crypto\objects\obj_err.c
	$(CC) /Fo$(OBJ_D)\obj_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_err.c

$(OBJ_D)\encode.obj: $(SRC_D)\crypto\evp\encode.c
	$(CC) /Fo$(OBJ_D)\encode.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\encode.c

$(OBJ_D)\digest.obj: $(SRC_D)\crypto\evp\digest.c
	$(CC) /Fo$(OBJ_D)\digest.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\digest.c

$(OBJ_D)\evp_enc.obj: $(SRC_D)\crypto\evp\evp_enc.c
	$(CC) /Fo$(OBJ_D)\evp_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_enc.c

$(OBJ_D)\evp_key.obj: $(SRC_D)\crypto\evp\evp_key.c
	$(CC) /Fo$(OBJ_D)\evp_key.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_key.c

$(OBJ_D)\e_ecb_d.obj: $(SRC_D)\crypto\evp\e_ecb_d.c
	$(CC) /Fo$(OBJ_D)\e_ecb_d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_d.c

$(OBJ_D)\e_cbc_d.obj: $(SRC_D)\crypto\evp\e_cbc_d.c
	$(CC) /Fo$(OBJ_D)\e_cbc_d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_d.c

$(OBJ_D)\e_cfb_d.obj: $(SRC_D)\crypto\evp\e_cfb_d.c
	$(CC) /Fo$(OBJ_D)\e_cfb_d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_d.c

$(OBJ_D)\e_ofb_d.obj: $(SRC_D)\crypto\evp\e_ofb_d.c
	$(CC) /Fo$(OBJ_D)\e_ofb_d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_d.c

$(OBJ_D)\e_ecb_i.obj: $(SRC_D)\crypto\evp\e_ecb_i.c
	$(CC) /Fo$(OBJ_D)\e_ecb_i.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_i.c

$(OBJ_D)\e_cbc_i.obj: $(SRC_D)\crypto\evp\e_cbc_i.c
	$(CC) /Fo$(OBJ_D)\e_cbc_i.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_i.c

$(OBJ_D)\e_cfb_i.obj: $(SRC_D)\crypto\evp\e_cfb_i.c
	$(CC) /Fo$(OBJ_D)\e_cfb_i.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_i.c

$(OBJ_D)\e_ofb_i.obj: $(SRC_D)\crypto\evp\e_ofb_i.c
	$(CC) /Fo$(OBJ_D)\e_ofb_i.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_i.c

$(OBJ_D)\e_ecb_3d.obj: $(SRC_D)\crypto\evp\e_ecb_3d.c
	$(CC) /Fo$(OBJ_D)\e_ecb_3d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_3d.c

$(OBJ_D)\e_cbc_3d.obj: $(SRC_D)\crypto\evp\e_cbc_3d.c
	$(CC) /Fo$(OBJ_D)\e_cbc_3d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_3d.c

$(OBJ_D)\e_rc4.obj: $(SRC_D)\crypto\evp\e_rc4.c
	$(CC) /Fo$(OBJ_D)\e_rc4.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_rc4.c

$(OBJ_D)\names.obj: $(SRC_D)\crypto\evp\names.c
	$(CC) /Fo$(OBJ_D)\names.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\names.c

$(OBJ_D)\e_cfb_3d.obj: $(SRC_D)\crypto\evp\e_cfb_3d.c
	$(CC) /Fo$(OBJ_D)\e_cfb_3d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_3d.c

$(OBJ_D)\e_ofb_3d.obj: $(SRC_D)\crypto\evp\e_ofb_3d.c
	$(CC) /Fo$(OBJ_D)\e_ofb_3d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_3d.c

$(OBJ_D)\e_xcbc_d.obj: $(SRC_D)\crypto\evp\e_xcbc_d.c
	$(CC) /Fo$(OBJ_D)\e_xcbc_d.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_xcbc_d.c

$(OBJ_D)\e_ecb_r2.obj: $(SRC_D)\crypto\evp\e_ecb_r2.c
	$(CC) /Fo$(OBJ_D)\e_ecb_r2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_r2.c

$(OBJ_D)\e_cbc_r2.obj: $(SRC_D)\crypto\evp\e_cbc_r2.c
	$(CC) /Fo$(OBJ_D)\e_cbc_r2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_r2.c

$(OBJ_D)\e_cfb_r2.obj: $(SRC_D)\crypto\evp\e_cfb_r2.c
	$(CC) /Fo$(OBJ_D)\e_cfb_r2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_r2.c

$(OBJ_D)\e_ofb_r2.obj: $(SRC_D)\crypto\evp\e_ofb_r2.c
	$(CC) /Fo$(OBJ_D)\e_ofb_r2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_r2.c

$(OBJ_D)\e_ecb_bf.obj: $(SRC_D)\crypto\evp\e_ecb_bf.c
	$(CC) /Fo$(OBJ_D)\e_ecb_bf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_bf.c

$(OBJ_D)\e_cbc_bf.obj: $(SRC_D)\crypto\evp\e_cbc_bf.c
	$(CC) /Fo$(OBJ_D)\e_cbc_bf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_bf.c

$(OBJ_D)\e_cfb_bf.obj: $(SRC_D)\crypto\evp\e_cfb_bf.c
	$(CC) /Fo$(OBJ_D)\e_cfb_bf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_bf.c

$(OBJ_D)\e_ofb_bf.obj: $(SRC_D)\crypto\evp\e_ofb_bf.c
	$(CC) /Fo$(OBJ_D)\e_ofb_bf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_bf.c

$(OBJ_D)\e_ecb_c.obj: $(SRC_D)\crypto\evp\e_ecb_c.c
	$(CC) /Fo$(OBJ_D)\e_ecb_c.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_c.c

$(OBJ_D)\e_cbc_c.obj: $(SRC_D)\crypto\evp\e_cbc_c.c
	$(CC) /Fo$(OBJ_D)\e_cbc_c.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_c.c

$(OBJ_D)\e_cfb_c.obj: $(SRC_D)\crypto\evp\e_cfb_c.c
	$(CC) /Fo$(OBJ_D)\e_cfb_c.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_c.c

$(OBJ_D)\e_ofb_c.obj: $(SRC_D)\crypto\evp\e_ofb_c.c
	$(CC) /Fo$(OBJ_D)\e_ofb_c.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_c.c

$(OBJ_D)\e_ecb_r5.obj: $(SRC_D)\crypto\evp\e_ecb_r5.c
	$(CC) /Fo$(OBJ_D)\e_ecb_r5.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_r5.c

$(OBJ_D)\e_cbc_r5.obj: $(SRC_D)\crypto\evp\e_cbc_r5.c
	$(CC) /Fo$(OBJ_D)\e_cbc_r5.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_r5.c

$(OBJ_D)\e_cfb_r5.obj: $(SRC_D)\crypto\evp\e_cfb_r5.c
	$(CC) /Fo$(OBJ_D)\e_cfb_r5.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_r5.c

$(OBJ_D)\e_ofb_r5.obj: $(SRC_D)\crypto\evp\e_ofb_r5.c
	$(CC) /Fo$(OBJ_D)\e_ofb_r5.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_r5.c

$(OBJ_D)\m_null.obj: $(SRC_D)\crypto\evp\m_null.c
	$(CC) /Fo$(OBJ_D)\m_null.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_null.c

$(OBJ_D)\m_md2.obj: $(SRC_D)\crypto\evp\m_md2.c
	$(CC) /Fo$(OBJ_D)\m_md2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md2.c

$(OBJ_D)\m_md5.obj: $(SRC_D)\crypto\evp\m_md5.c
	$(CC) /Fo$(OBJ_D)\m_md5.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md5.c

$(OBJ_D)\m_sha.obj: $(SRC_D)\crypto\evp\m_sha.c
	$(CC) /Fo$(OBJ_D)\m_sha.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_sha.c

$(OBJ_D)\m_sha1.obj: $(SRC_D)\crypto\evp\m_sha1.c
	$(CC) /Fo$(OBJ_D)\m_sha1.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_sha1.c

$(OBJ_D)\m_dss.obj: $(SRC_D)\crypto\evp\m_dss.c
	$(CC) /Fo$(OBJ_D)\m_dss.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_dss.c

$(OBJ_D)\m_dss1.obj: $(SRC_D)\crypto\evp\m_dss1.c
	$(CC) /Fo$(OBJ_D)\m_dss1.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_dss1.c

$(OBJ_D)\m_mdc2.obj: $(SRC_D)\crypto\evp\m_mdc2.c
	$(CC) /Fo$(OBJ_D)\m_mdc2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_mdc2.c

$(OBJ_D)\m_ripemd.obj: $(SRC_D)\crypto\evp\m_ripemd.c
	$(CC) /Fo$(OBJ_D)\m_ripemd.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_ripemd.c

$(OBJ_D)\p_open.obj: $(SRC_D)\crypto\evp\p_open.c
	$(CC) /Fo$(OBJ_D)\p_open.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_open.c

$(OBJ_D)\p_seal.obj: $(SRC_D)\crypto\evp\p_seal.c
	$(CC) /Fo$(OBJ_D)\p_seal.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_seal.c

$(OBJ_D)\p_sign.obj: $(SRC_D)\crypto\evp\p_sign.c
	$(CC) /Fo$(OBJ_D)\p_sign.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_sign.c

$(OBJ_D)\p_verify.obj: $(SRC_D)\crypto\evp\p_verify.c
	$(CC) /Fo$(OBJ_D)\p_verify.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_verify.c

$(OBJ_D)\p_lib.obj: $(SRC_D)\crypto\evp\p_lib.c
	$(CC) /Fo$(OBJ_D)\p_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_lib.c

$(OBJ_D)\p_enc.obj: $(SRC_D)\crypto\evp\p_enc.c
	$(CC) /Fo$(OBJ_D)\p_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_enc.c

$(OBJ_D)\p_dec.obj: $(SRC_D)\crypto\evp\p_dec.c
	$(CC) /Fo$(OBJ_D)\p_dec.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_dec.c

$(OBJ_D)\bio_md.obj: $(SRC_D)\crypto\evp\bio_md.c
	$(CC) /Fo$(OBJ_D)\bio_md.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_md.c

$(OBJ_D)\bio_b64.obj: $(SRC_D)\crypto\evp\bio_b64.c
	$(CC) /Fo$(OBJ_D)\bio_b64.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_b64.c

$(OBJ_D)\bio_enc.obj: $(SRC_D)\crypto\evp\bio_enc.c
	$(CC) /Fo$(OBJ_D)\bio_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_enc.c

$(OBJ_D)\evp_err.obj: $(SRC_D)\crypto\evp\evp_err.c
	$(CC) /Fo$(OBJ_D)\evp_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_err.c

$(OBJ_D)\e_null.obj: $(SRC_D)\crypto\evp\e_null.c
	$(CC) /Fo$(OBJ_D)\e_null.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_null.c

$(OBJ_D)\c_all.obj: $(SRC_D)\crypto\evp\c_all.c
	$(CC) /Fo$(OBJ_D)\c_all.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\c_all.c

$(OBJ_D)\evp_lib.obj: $(SRC_D)\crypto\evp\evp_lib.c
	$(CC) /Fo$(OBJ_D)\evp_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_lib.c

$(OBJ_D)\pem_sign.obj: $(SRC_D)\crypto\pem\pem_sign.c
	$(CC) /Fo$(OBJ_D)\pem_sign.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_sign.c

$(OBJ_D)\pem_seal.obj: $(SRC_D)\crypto\pem\pem_seal.c
	$(CC) /Fo$(OBJ_D)\pem_seal.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_seal.c

$(OBJ_D)\pem_info.obj: $(SRC_D)\crypto\pem\pem_info.c
	$(CC) /Fo$(OBJ_D)\pem_info.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_info.c

$(OBJ_D)\pem_lib.obj: $(SRC_D)\crypto\pem\pem_lib.c
	$(CC) /Fo$(OBJ_D)\pem_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_lib.c

$(OBJ_D)\pem_all.obj: $(SRC_D)\crypto\pem\pem_all.c
	$(CC) /Fo$(OBJ_D)\pem_all.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_all.c

$(OBJ_D)\pem_err.obj: $(SRC_D)\crypto\pem\pem_err.c
	$(CC) /Fo$(OBJ_D)\pem_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_err.c

$(OBJ_D)\a_object.obj: $(SRC_D)\crypto\asn1\a_object.c
	$(CC) /Fo$(OBJ_D)\a_object.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_object.c

$(OBJ_D)\a_bitstr.obj: $(SRC_D)\crypto\asn1\a_bitstr.c
	$(CC) /Fo$(OBJ_D)\a_bitstr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bitstr.c

$(OBJ_D)\a_utctm.obj: $(SRC_D)\crypto\asn1\a_utctm.c
	$(CC) /Fo$(OBJ_D)\a_utctm.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_utctm.c

$(OBJ_D)\a_int.obj: $(SRC_D)\crypto\asn1\a_int.c
	$(CC) /Fo$(OBJ_D)\a_int.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_int.c

$(OBJ_D)\a_octet.obj: $(SRC_D)\crypto\asn1\a_octet.c
	$(CC) /Fo$(OBJ_D)\a_octet.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_octet.c

$(OBJ_D)\a_print.obj: $(SRC_D)\crypto\asn1\a_print.c
	$(CC) /Fo$(OBJ_D)\a_print.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_print.c

$(OBJ_D)\a_type.obj: $(SRC_D)\crypto\asn1\a_type.c
	$(CC) /Fo$(OBJ_D)\a_type.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_type.c

$(OBJ_D)\a_set.obj: $(SRC_D)\crypto\asn1\a_set.c
	$(CC) /Fo$(OBJ_D)\a_set.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_set.c

$(OBJ_D)\a_dup.obj: $(SRC_D)\crypto\asn1\a_dup.c
	$(CC) /Fo$(OBJ_D)\a_dup.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_dup.c

$(OBJ_D)\a_d2i_fp.obj: $(SRC_D)\crypto\asn1\a_d2i_fp.c
	$(CC) /Fo$(OBJ_D)\a_d2i_fp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_d2i_fp.c

$(OBJ_D)\a_i2d_fp.obj: $(SRC_D)\crypto\asn1\a_i2d_fp.c
	$(CC) /Fo$(OBJ_D)\a_i2d_fp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_i2d_fp.c

$(OBJ_D)\a_bmp.obj: $(SRC_D)\crypto\asn1\a_bmp.c
	$(CC) /Fo$(OBJ_D)\a_bmp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bmp.c

$(OBJ_D)\a_sign.obj: $(SRC_D)\crypto\asn1\a_sign.c
	$(CC) /Fo$(OBJ_D)\a_sign.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_sign.c

$(OBJ_D)\a_digest.obj: $(SRC_D)\crypto\asn1\a_digest.c
	$(CC) /Fo$(OBJ_D)\a_digest.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_digest.c

$(OBJ_D)\a_verify.obj: $(SRC_D)\crypto\asn1\a_verify.c
	$(CC) /Fo$(OBJ_D)\a_verify.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_verify.c

$(OBJ_D)\x_algor.obj: $(SRC_D)\crypto\asn1\x_algor.c
	$(CC) /Fo$(OBJ_D)\x_algor.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_algor.c

$(OBJ_D)\x_val.obj: $(SRC_D)\crypto\asn1\x_val.c
	$(CC) /Fo$(OBJ_D)\x_val.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_val.c

$(OBJ_D)\x_pubkey.obj: $(SRC_D)\crypto\asn1\x_pubkey.c
	$(CC) /Fo$(OBJ_D)\x_pubkey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_pubkey.c

$(OBJ_D)\x_sig.obj: $(SRC_D)\crypto\asn1\x_sig.c
	$(CC) /Fo$(OBJ_D)\x_sig.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_sig.c

$(OBJ_D)\x_req.obj: $(SRC_D)\crypto\asn1\x_req.c
	$(CC) /Fo$(OBJ_D)\x_req.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_req.c

$(OBJ_D)\x_attrib.obj: $(SRC_D)\crypto\asn1\x_attrib.c
	$(CC) /Fo$(OBJ_D)\x_attrib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_attrib.c

$(OBJ_D)\x_name.obj: $(SRC_D)\crypto\asn1\x_name.c
	$(CC) /Fo$(OBJ_D)\x_name.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_name.c

$(OBJ_D)\x_cinf.obj: $(SRC_D)\crypto\asn1\x_cinf.c
	$(CC) /Fo$(OBJ_D)\x_cinf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_cinf.c

$(OBJ_D)\x_x509.obj: $(SRC_D)\crypto\asn1\x_x509.c
	$(CC) /Fo$(OBJ_D)\x_x509.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_x509.c

$(OBJ_D)\x_crl.obj: $(SRC_D)\crypto\asn1\x_crl.c
	$(CC) /Fo$(OBJ_D)\x_crl.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_crl.c

$(OBJ_D)\x_info.obj: $(SRC_D)\crypto\asn1\x_info.c
	$(CC) /Fo$(OBJ_D)\x_info.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_info.c

$(OBJ_D)\x_spki.obj: $(SRC_D)\crypto\asn1\x_spki.c
	$(CC) /Fo$(OBJ_D)\x_spki.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_spki.c

$(OBJ_D)\d2i_r_pr.obj: $(SRC_D)\crypto\asn1\d2i_r_pr.c
	$(CC) /Fo$(OBJ_D)\d2i_r_pr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_r_pr.c

$(OBJ_D)\i2d_r_pr.obj: $(SRC_D)\crypto\asn1\i2d_r_pr.c
	$(CC) /Fo$(OBJ_D)\i2d_r_pr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_r_pr.c

$(OBJ_D)\d2i_r_pu.obj: $(SRC_D)\crypto\asn1\d2i_r_pu.c
	$(CC) /Fo$(OBJ_D)\d2i_r_pu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_r_pu.c

$(OBJ_D)\i2d_r_pu.obj: $(SRC_D)\crypto\asn1\i2d_r_pu.c
	$(CC) /Fo$(OBJ_D)\i2d_r_pu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_r_pu.c

$(OBJ_D)\d2i_s_pr.obj: $(SRC_D)\crypto\asn1\d2i_s_pr.c
	$(CC) /Fo$(OBJ_D)\d2i_s_pr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_s_pr.c

$(OBJ_D)\i2d_s_pr.obj: $(SRC_D)\crypto\asn1\i2d_s_pr.c
	$(CC) /Fo$(OBJ_D)\i2d_s_pr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_s_pr.c

$(OBJ_D)\d2i_s_pu.obj: $(SRC_D)\crypto\asn1\d2i_s_pu.c
	$(CC) /Fo$(OBJ_D)\d2i_s_pu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_s_pu.c

$(OBJ_D)\i2d_s_pu.obj: $(SRC_D)\crypto\asn1\i2d_s_pu.c
	$(CC) /Fo$(OBJ_D)\i2d_s_pu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_s_pu.c

$(OBJ_D)\d2i_pu.obj: $(SRC_D)\crypto\asn1\d2i_pu.c
	$(CC) /Fo$(OBJ_D)\d2i_pu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_pu.c

$(OBJ_D)\d2i_pr.obj: $(SRC_D)\crypto\asn1\d2i_pr.c
	$(CC) /Fo$(OBJ_D)\d2i_pr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_pr.c

$(OBJ_D)\i2d_pu.obj: $(SRC_D)\crypto\asn1\i2d_pu.c
	$(CC) /Fo$(OBJ_D)\i2d_pu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_pu.c

$(OBJ_D)\i2d_pr.obj: $(SRC_D)\crypto\asn1\i2d_pr.c
	$(CC) /Fo$(OBJ_D)\i2d_pr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_pr.c

$(OBJ_D)\t_req.obj: $(SRC_D)\crypto\asn1\t_req.c
	$(CC) /Fo$(OBJ_D)\t_req.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_req.c

$(OBJ_D)\t_x509.obj: $(SRC_D)\crypto\asn1\t_x509.c
	$(CC) /Fo$(OBJ_D)\t_x509.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_x509.c

$(OBJ_D)\t_pkey.obj: $(SRC_D)\crypto\asn1\t_pkey.c
	$(CC) /Fo$(OBJ_D)\t_pkey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_pkey.c

$(OBJ_D)\p7_i_s.obj: $(SRC_D)\crypto\asn1\p7_i_s.c
	$(CC) /Fo$(OBJ_D)\p7_i_s.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_i_s.c

$(OBJ_D)\p7_signi.obj: $(SRC_D)\crypto\asn1\p7_signi.c
	$(CC) /Fo$(OBJ_D)\p7_signi.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_signi.c

$(OBJ_D)\p7_signd.obj: $(SRC_D)\crypto\asn1\p7_signd.c
	$(CC) /Fo$(OBJ_D)\p7_signd.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_signd.c

$(OBJ_D)\p7_recip.obj: $(SRC_D)\crypto\asn1\p7_recip.c
	$(CC) /Fo$(OBJ_D)\p7_recip.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_recip.c

$(OBJ_D)\p7_enc_c.obj: $(SRC_D)\crypto\asn1\p7_enc_c.c
	$(CC) /Fo$(OBJ_D)\p7_enc_c.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_enc_c.c

$(OBJ_D)\p7_evp.obj: $(SRC_D)\crypto\asn1\p7_evp.c
	$(CC) /Fo$(OBJ_D)\p7_evp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_evp.c

$(OBJ_D)\p7_dgst.obj: $(SRC_D)\crypto\asn1\p7_dgst.c
	$(CC) /Fo$(OBJ_D)\p7_dgst.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_dgst.c

$(OBJ_D)\p7_s_e.obj: $(SRC_D)\crypto\asn1\p7_s_e.c
	$(CC) /Fo$(OBJ_D)\p7_s_e.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_s_e.c

$(OBJ_D)\p7_enc.obj: $(SRC_D)\crypto\asn1\p7_enc.c
	$(CC) /Fo$(OBJ_D)\p7_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_enc.c

$(OBJ_D)\p7_lib.obj: $(SRC_D)\crypto\asn1\p7_lib.c
	$(CC) /Fo$(OBJ_D)\p7_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_lib.c

$(OBJ_D)\f_int.obj: $(SRC_D)\crypto\asn1\f_int.c
	$(CC) /Fo$(OBJ_D)\f_int.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\f_int.c

$(OBJ_D)\f_string.obj: $(SRC_D)\crypto\asn1\f_string.c
	$(CC) /Fo$(OBJ_D)\f_string.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\f_string.c

$(OBJ_D)\i2d_dhp.obj: $(SRC_D)\crypto\asn1\i2d_dhp.c
	$(CC) /Fo$(OBJ_D)\i2d_dhp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_dhp.c

$(OBJ_D)\i2d_dsap.obj: $(SRC_D)\crypto\asn1\i2d_dsap.c
	$(CC) /Fo$(OBJ_D)\i2d_dsap.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_dsap.c

$(OBJ_D)\d2i_dhp.obj: $(SRC_D)\crypto\asn1\d2i_dhp.c
	$(CC) /Fo$(OBJ_D)\d2i_dhp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_dhp.c

$(OBJ_D)\d2i_dsap.obj: $(SRC_D)\crypto\asn1\d2i_dsap.c
	$(CC) /Fo$(OBJ_D)\d2i_dsap.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_dsap.c

$(OBJ_D)\n_pkey.obj: $(SRC_D)\crypto\asn1\n_pkey.c
	$(CC) /Fo$(OBJ_D)\n_pkey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\n_pkey.c

$(OBJ_D)\a_hdr.obj: $(SRC_D)\crypto\asn1\a_hdr.c
	$(CC) /Fo$(OBJ_D)\a_hdr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_hdr.c

$(OBJ_D)\x_pkey.obj: $(SRC_D)\crypto\asn1\x_pkey.c
	$(CC) /Fo$(OBJ_D)\x_pkey.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_pkey.c

$(OBJ_D)\a_bool.obj: $(SRC_D)\crypto\asn1\a_bool.c
	$(CC) /Fo$(OBJ_D)\a_bool.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bool.c

$(OBJ_D)\x_exten.obj: $(SRC_D)\crypto\asn1\x_exten.c
	$(CC) /Fo$(OBJ_D)\x_exten.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_exten.c

$(OBJ_D)\asn1_par.obj: $(SRC_D)\crypto\asn1\asn1_par.c
	$(CC) /Fo$(OBJ_D)\asn1_par.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_par.c

$(OBJ_D)\asn1_lib.obj: $(SRC_D)\crypto\asn1\asn1_lib.c
	$(CC) /Fo$(OBJ_D)\asn1_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_lib.c

$(OBJ_D)\asn1_err.obj: $(SRC_D)\crypto\asn1\asn1_err.c
	$(CC) /Fo$(OBJ_D)\asn1_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_err.c

$(OBJ_D)\a_meth.obj: $(SRC_D)\crypto\asn1\a_meth.c
	$(CC) /Fo$(OBJ_D)\a_meth.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_meth.c

$(OBJ_D)\a_bytes.obj: $(SRC_D)\crypto\asn1\a_bytes.c
	$(CC) /Fo$(OBJ_D)\a_bytes.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bytes.c

$(OBJ_D)\evp_asn1.obj: $(SRC_D)\crypto\asn1\evp_asn1.c
	$(CC) /Fo$(OBJ_D)\evp_asn1.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\asn1\evp_asn1.c

$(OBJ_D)\x509_def.obj: $(SRC_D)\crypto\x509\x509_def.c
	$(CC) /Fo$(OBJ_D)\x509_def.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_def.c

$(OBJ_D)\x509_d2.obj: $(SRC_D)\crypto\x509\x509_d2.c
	$(CC) /Fo$(OBJ_D)\x509_d2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_d2.c

$(OBJ_D)\x509_r2x.obj: $(SRC_D)\crypto\x509\x509_r2x.c
	$(CC) /Fo$(OBJ_D)\x509_r2x.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_r2x.c

$(OBJ_D)\x509_cmp.obj: $(SRC_D)\crypto\x509\x509_cmp.c
	$(CC) /Fo$(OBJ_D)\x509_cmp.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_cmp.c

$(OBJ_D)\x509_obj.obj: $(SRC_D)\crypto\x509\x509_obj.c
	$(CC) /Fo$(OBJ_D)\x509_obj.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_obj.c

$(OBJ_D)\x509_req.obj: $(SRC_D)\crypto\x509\x509_req.c
	$(CC) /Fo$(OBJ_D)\x509_req.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_req.c

$(OBJ_D)\x509_vfy.obj: $(SRC_D)\crypto\x509\x509_vfy.c
	$(CC) /Fo$(OBJ_D)\x509_vfy.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_vfy.c

$(OBJ_D)\x509_set.obj: $(SRC_D)\crypto\x509\x509_set.c
	$(CC) /Fo$(OBJ_D)\x509_set.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_set.c

$(OBJ_D)\x509rset.obj: $(SRC_D)\crypto\x509\x509rset.c
	$(CC) /Fo$(OBJ_D)\x509rset.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509rset.c

$(OBJ_D)\x509_err.obj: $(SRC_D)\crypto\x509\x509_err.c
	$(CC) /Fo$(OBJ_D)\x509_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_err.c

$(OBJ_D)\x509name.obj: $(SRC_D)\crypto\x509\x509name.c
	$(CC) /Fo$(OBJ_D)\x509name.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509name.c

$(OBJ_D)\x509_v3.obj: $(SRC_D)\crypto\x509\x509_v3.c
	$(CC) /Fo$(OBJ_D)\x509_v3.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_v3.c

$(OBJ_D)\x509_ext.obj: $(SRC_D)\crypto\x509\x509_ext.c
	$(CC) /Fo$(OBJ_D)\x509_ext.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_ext.c

$(OBJ_D)\x509pack.obj: $(SRC_D)\crypto\x509\x509pack.c
	$(CC) /Fo$(OBJ_D)\x509pack.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509pack.c

$(OBJ_D)\x509type.obj: $(SRC_D)\crypto\x509\x509type.c
	$(CC) /Fo$(OBJ_D)\x509type.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509type.c

$(OBJ_D)\x509_lu.obj: $(SRC_D)\crypto\x509\x509_lu.c
	$(CC) /Fo$(OBJ_D)\x509_lu.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_lu.c

$(OBJ_D)\x_all.obj: $(SRC_D)\crypto\x509\x_all.c
	$(CC) /Fo$(OBJ_D)\x_all.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x_all.c

$(OBJ_D)\x509_txt.obj: $(SRC_D)\crypto\x509\x509_txt.c
	$(CC) /Fo$(OBJ_D)\x509_txt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_txt.c

$(OBJ_D)\by_file.obj: $(SRC_D)\crypto\x509\by_file.c
	$(CC) /Fo$(OBJ_D)\by_file.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\by_file.c

$(OBJ_D)\by_dir.obj: $(SRC_D)\crypto\x509\by_dir.c
	$(CC) /Fo$(OBJ_D)\by_dir.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\by_dir.c

$(OBJ_D)\v3_net.obj: $(SRC_D)\crypto\x509\v3_net.c
	$(CC) /Fo$(OBJ_D)\v3_net.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\v3_net.c

$(OBJ_D)\v3_x509.obj: $(SRC_D)\crypto\x509\v3_x509.c
	$(CC) /Fo$(OBJ_D)\v3_x509.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\x509\v3_x509.c

$(OBJ_D)\conf.obj: $(SRC_D)\crypto\conf\conf.c
	$(CC) /Fo$(OBJ_D)\conf.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf.c

$(OBJ_D)\conf_err.obj: $(SRC_D)\crypto\conf\conf_err.c
	$(CC) /Fo$(OBJ_D)\conf_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_err.c

$(OBJ_D)\txt_db.obj: $(SRC_D)\crypto\txt_db\txt_db.c
	$(CC) /Fo$(OBJ_D)\txt_db.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\txt_db\txt_db.c

$(OBJ_D)\pk7_lib.obj: $(SRC_D)\crypto\pkcs7\pk7_lib.c
	$(CC) /Fo$(OBJ_D)\pk7_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_lib.c

$(OBJ_D)\pkcs7err.obj: $(SRC_D)\crypto\pkcs7\pkcs7err.c
	$(CC) /Fo$(OBJ_D)\pkcs7err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pkcs7err.c

$(OBJ_D)\pk7_doit.obj: $(SRC_D)\crypto\pkcs7\pk7_doit.c
	$(CC) /Fo$(OBJ_D)\pk7_doit.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_doit.c

$(OBJ_D)\comp_lib.obj: $(SRC_D)\crypto\comp\comp_lib.c
	$(CC) /Fo$(OBJ_D)\comp_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\comp\comp_lib.c

$(OBJ_D)\c_rle.obj: $(SRC_D)\crypto\comp\c_rle.c
	$(CC) /Fo$(OBJ_D)\c_rle.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\comp\c_rle.c

$(OBJ_D)\c_zlib.obj: $(SRC_D)\crypto\comp\c_zlib.c
	$(CC) /Fo$(OBJ_D)\c_zlib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\crypto\comp\c_zlib.c

$(OBJ_D)\s2_meth.obj: $(SRC_D)\ssl\s2_meth.c
	$(CC) /Fo$(OBJ_D)\s2_meth.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s2_meth.c

$(OBJ_D)\s2_srvr.obj: $(SRC_D)\ssl\s2_srvr.c
	$(CC) /Fo$(OBJ_D)\s2_srvr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s2_srvr.c

$(OBJ_D)\s2_clnt.obj: $(SRC_D)\ssl\s2_clnt.c
	$(CC) /Fo$(OBJ_D)\s2_clnt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s2_clnt.c

$(OBJ_D)\s2_lib.obj: $(SRC_D)\ssl\s2_lib.c
	$(CC) /Fo$(OBJ_D)\s2_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s2_lib.c

$(OBJ_D)\s2_enc.obj: $(SRC_D)\ssl\s2_enc.c
	$(CC) /Fo$(OBJ_D)\s2_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s2_enc.c

$(OBJ_D)\s2_pkt.obj: $(SRC_D)\ssl\s2_pkt.c
	$(CC) /Fo$(OBJ_D)\s2_pkt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s2_pkt.c

$(OBJ_D)\s3_meth.obj: $(SRC_D)\ssl\s3_meth.c
	$(CC) /Fo$(OBJ_D)\s3_meth.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_meth.c

$(OBJ_D)\s3_srvr.obj: $(SRC_D)\ssl\s3_srvr.c
	$(CC) /Fo$(OBJ_D)\s3_srvr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_srvr.c

$(OBJ_D)\s3_clnt.obj: $(SRC_D)\ssl\s3_clnt.c
	$(CC) /Fo$(OBJ_D)\s3_clnt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_clnt.c

$(OBJ_D)\s3_lib.obj: $(SRC_D)\ssl\s3_lib.c
	$(CC) /Fo$(OBJ_D)\s3_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_lib.c

$(OBJ_D)\s3_enc.obj: $(SRC_D)\ssl\s3_enc.c
	$(CC) /Fo$(OBJ_D)\s3_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_enc.c

$(OBJ_D)\s3_pkt.obj: $(SRC_D)\ssl\s3_pkt.c
	$(CC) /Fo$(OBJ_D)\s3_pkt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_pkt.c

$(OBJ_D)\s3_both.obj: $(SRC_D)\ssl\s3_both.c
	$(CC) /Fo$(OBJ_D)\s3_both.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s3_both.c

$(OBJ_D)\s23_meth.obj: $(SRC_D)\ssl\s23_meth.c
	$(CC) /Fo$(OBJ_D)\s23_meth.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s23_meth.c

$(OBJ_D)\s23_srvr.obj: $(SRC_D)\ssl\s23_srvr.c
	$(CC) /Fo$(OBJ_D)\s23_srvr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s23_srvr.c

$(OBJ_D)\s23_clnt.obj: $(SRC_D)\ssl\s23_clnt.c
	$(CC) /Fo$(OBJ_D)\s23_clnt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s23_clnt.c

$(OBJ_D)\s23_lib.obj: $(SRC_D)\ssl\s23_lib.c
	$(CC) /Fo$(OBJ_D)\s23_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s23_lib.c

$(OBJ_D)\s23_pkt.obj: $(SRC_D)\ssl\s23_pkt.c
	$(CC) /Fo$(OBJ_D)\s23_pkt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\s23_pkt.c

$(OBJ_D)\t1_meth.obj: $(SRC_D)\ssl\t1_meth.c
	$(CC) /Fo$(OBJ_D)\t1_meth.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\t1_meth.c

$(OBJ_D)\t1_srvr.obj: $(SRC_D)\ssl\t1_srvr.c
	$(CC) /Fo$(OBJ_D)\t1_srvr.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\t1_srvr.c

$(OBJ_D)\t1_clnt.obj: $(SRC_D)\ssl\t1_clnt.c
	$(CC) /Fo$(OBJ_D)\t1_clnt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\t1_clnt.c

$(OBJ_D)\t1_lib.obj: $(SRC_D)\ssl\t1_lib.c
	$(CC) /Fo$(OBJ_D)\t1_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\t1_lib.c

$(OBJ_D)\t1_enc.obj: $(SRC_D)\ssl\t1_enc.c
	$(CC) /Fo$(OBJ_D)\t1_enc.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\t1_enc.c

$(OBJ_D)\ssl_lib.obj: $(SRC_D)\ssl\ssl_lib.c
	$(CC) /Fo$(OBJ_D)\ssl_lib.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_lib.c

$(OBJ_D)\ssl_err2.obj: $(SRC_D)\ssl\ssl_err2.c
	$(CC) /Fo$(OBJ_D)\ssl_err2.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_err2.c

$(OBJ_D)\ssl_cert.obj: $(SRC_D)\ssl\ssl_cert.c
	$(CC) /Fo$(OBJ_D)\ssl_cert.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_cert.c

$(OBJ_D)\ssl_sess.obj: $(SRC_D)\ssl\ssl_sess.c
	$(CC) /Fo$(OBJ_D)\ssl_sess.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_sess.c

$(OBJ_D)\ssl_ciph.obj: $(SRC_D)\ssl\ssl_ciph.c
	$(CC) /Fo$(OBJ_D)\ssl_ciph.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_ciph.c

$(OBJ_D)\ssl_stat.obj: $(SRC_D)\ssl\ssl_stat.c
	$(CC) /Fo$(OBJ_D)\ssl_stat.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_stat.c

$(OBJ_D)\ssl_rsa.obj: $(SRC_D)\ssl\ssl_rsa.c
	$(CC) /Fo$(OBJ_D)\ssl_rsa.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_rsa.c

$(OBJ_D)\ssl_asn1.obj: $(SRC_D)\ssl\ssl_asn1.c
	$(CC) /Fo$(OBJ_D)\ssl_asn1.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_asn1.c

$(OBJ_D)\ssl_txt.obj: $(SRC_D)\ssl\ssl_txt.c
	$(CC) /Fo$(OBJ_D)\ssl_txt.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_txt.c

$(OBJ_D)\ssl_algs.obj: $(SRC_D)\ssl\ssl_algs.c
	$(CC) /Fo$(OBJ_D)\ssl_algs.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_algs.c

$(OBJ_D)\bio_ssl.obj: $(SRC_D)\ssl\bio_ssl.c
	$(CC) /Fo$(OBJ_D)\bio_ssl.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\bio_ssl.c

$(OBJ_D)\ssl_err.obj: $(SRC_D)\ssl\ssl_err.c
	$(CC) /Fo$(OBJ_D)\ssl_err.obj  $(SHLIB_CFLAGS) -c $(SRC_D)\ssl\ssl_err.c

$(OBJ_D)\rsaref.obj: $(SRC_D)\rsaref\rsaref.c
	$(CC) /Fo$(OBJ_D)\rsaref.obj  $(LIB_CFLAGS) -c $(SRC_D)\rsaref\rsaref.c

$(OBJ_D)\rsar_err.obj: $(SRC_D)\rsaref\rsar_err.c
	$(CC) /Fo$(OBJ_D)\rsar_err.obj  $(LIB_CFLAGS) -c $(SRC_D)\rsaref\rsar_err.c

$(TEST_D)\md2test.exe: $(OBJ_D)\md2test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\md2test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\md2test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\md5test.exe: $(OBJ_D)\md5test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\md5test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\md5test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\shatest.exe: $(OBJ_D)\shatest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\shatest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\shatest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\sha1test.exe: $(OBJ_D)\sha1test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\sha1test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\sha1test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\mdc2test.exe: $(OBJ_D)\mdc2test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\mdc2test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\mdc2test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\hmactest.exe: $(OBJ_D)\hmactest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\hmactest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\hmactest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\rmdtest.exe: $(OBJ_D)\rmdtest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\rmdtest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\rmdtest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\destest.exe: $(OBJ_D)\destest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\destest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\destest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\rc2test.exe: $(OBJ_D)\rc2test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\rc2test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\rc2test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\rc4test.exe: $(OBJ_D)\rc4test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\rc4test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\rc4test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\rc5test.exe: $(OBJ_D)\rc5test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\rc5test.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\rc5test.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\ideatest.exe: $(OBJ_D)\ideatest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\ideatest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\ideatest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\bftest.exe: $(OBJ_D)\bftest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\bftest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\bftest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\casttest.exe: $(OBJ_D)\casttest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\casttest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\casttest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\bntest.exe: $(OBJ_D)\bntest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\bntest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\bntest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\exptest.exe: $(OBJ_D)\exptest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\exptest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\exptest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\dsatest.exe: $(OBJ_D)\dsatest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\dsatest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\dsatest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\dhtest.exe: $(OBJ_D)\dhtest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\dhtest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\dhtest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\randtest.exe: $(OBJ_D)\randtest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\randtest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\randtest.obj $(L_LIBS) $(EX_LIBS)
<<

$(TEST_D)\ssltest.exe: $(OBJ_D)\ssltest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(TEST_D)\ssltest.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\ssltest.obj $(L_LIBS) $(EX_LIBS)
<<

$(O_SSL): $(SSLOBJ)
	$(LINK) $(MLFLAGS) /out:$(O_SSL) /def:ms/SSLEAY32.def @<<
  $(SHLIB_EX_OBJ) $(SSLOBJ)  $(L_CRYPTO) wsock32.lib gdi32.lib
<<

$(O_RSAGLUE): $(RSAGLUEOBJ)
	$(MKLIB) /out:$(O_RSAGLUE) @<<
  $(RSAGLUEOBJ)
<<

$(O_CRYPTO): $(CRYPTOOBJ)
	$(LINK) $(MLFLAGS) /out:$(O_CRYPTO) /def:ms/LIBEAY32.def @<<
  $(SHLIB_EX_OBJ) $(CRYPTOOBJ)  wsock32.lib gdi32.lib
<<

$(BIN_D)\$(E_EXE).exe: $(E_OBJ) $(LIBS_DEP)
  $(LINK) $(LFLAGS) /out:$(BIN_D)\$(E_EXE).exe @<<
  $(APP_EX_OBJ) $(E_OBJ) $(L_LIBS) $(EX_LIBS)
<<

