/*
 # $Id: callbacks.c,v 1.5 1998/03/10 11:39:42 fbm Exp fbm $
 # Copyright (C) 1997,1998 Farrell McKay
 # All rights reserved.
 #
 # This file is part of the Fortify distribution, a toolkit for
 # upgrading the cryptographic strength of the Netscape Navigator
 # web browser, authored by Farrell McKay.
 #
 # This toolkit is provided to the recipient under the
 # following terms and conditions:-
 #   1.  This copyright notice must not be removed or modified.
 #   2.  This toolkit may not be reproduced or included in any commercial
 #       media distribution, or commercial publication (for example CD-ROM,
 #       disk, book, magazine, journal) without first obtaining the author's
 #       express permission.
 #   3.  This toolkit, or any component of this toolkit, may not be
 #       used, resold, redeveloped, rewritten, enhanced or otherwise
 #       employed by a commercial organisation, or as part of a commercial
 #       venture, without first obtaining the author's express permission.
 #   4.  Subject to the above conditions being observed (1-3), this toolkit
 #       may be freely reproduced or redistributed.
 #   5.  To the extent permitted by applicable law, this software is
 #       provided "as-is", without warranty of any kind, including
 #       without limitation, the warrantees of merchantability,
 #       freedom from defect, non-infringment, and fitness for
 #       purpose.  In no event shall the author be liable for any
 #       direct, indirect or consequential damages however arising
 #       and however caused.
 #   6.  Subject to the above conditions being observed (1-5),
 #       this toolkit may be used at no cost to the recipient.
 #
 # Farrell McKay
 # Wayfarer Systems Pty Ltd		contact@fortify.net
 */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "options.h"
#include "callbacks.h"
#include "log.h"

#define MSGSIZE		8192

static char		msg[MSGSIZE];

int
confirm(const char *format, ...)
{
        char    buf[8];
	va_list args;

	va_start(args, format);
	vsprintf(msg, format, args);
	va_end(args);

        for (;;) {
		if (!Log_toStdout()) {
			Log(0, "t0>> ");
			Log(0, msg);
		}
		fputs(msg, stdout);

		if (options_noprompts()) {
			strcpy(buf, "yes\n");
			fputs(buf, stdout);
		}
		else
			fgets(buf, sizeof(buf), stdin);

		if (!Log_toStdout())
			Log(0, buf);

                if (buf[0] == 'q' || buf[0] == 'Q')
                        exit(0);
                if (buf[0] == 'n' || buf[0] == 'N')
                        return 0;
                if (buf[0] == 'y' || buf[0] == 'Y')
                        return 1;
        }
}

void
report(int severity, const char *format, ...)
{
        va_list		args;

        va_start(args, format);
        vsprintf(msg, format, args);
        va_end(args);

	if (!Log_toStdout()) {
		if (msg[0] != '\n')
			Log(0, "t0>> ");
		Log(0, msg);
	}
        fputs(msg, stdout);

        if (severity == R_FATAL)
                exit(1);
}

char *
syserr(void)
{
#ifdef SYS_ERRLIST
	extern char *sys_errlist[];

	return sys_errlist[errno];		/* SunOS has no strerror() function */
#else
	return strerror(errno);
#endif
}
