.TH xwafetel 1
.SH NAME
.PP
xwafetel \- an X-based oracle front\-end for a telephone database 

.ad
.SH SYNOPSIS
.PP
\f3xwafetel\f1 [\f3-c \f2colormode\f1] 
[\f3-3\f1] 
[\f3-d\f2 database\f1] 
[\f3-a\f1] 
[\f3-v\f1] 

.SH DESCRIPTION
.PP

xwafetel establishes the connection to an Oracle database and allows
the user to perform search operations for certain records and
displays the found entries.

.SH OPTIONS
.PP
In addition to the standard toolkit options 
such as -display, -name, -geometry, -iconic, -xrm etc. (see manual
page X) xwafetel accepts the following options:

.TP
\f3-c \f2colormode\f1
start xwafetel using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-3\f1
do not use 3 dimensional widgets. This option depends of the configuration 
in the system.waferc file (see manual page wafeapp).

.TP
\f3-d\f2 userid/passwd@T:machine:oracleId\f1
this option allows the user to specify a different Oracle server and database
name to which xwafetel will try to connect.

.TP
\f3-a\f1
use the alternative host/database combination from the system.waferc or 
your local .waferc file.

.TP
\f3-v\f1
Print all SQL statements, which are submitted to the oracle server.

.SH "LAYOUT and INTERACTION" 

xwafetel consists of three input fields, one for each corresponding
field of the database. The active text widget, which receives all
keyboard input, can be recognized by a different background color (if
it was not started with -colormode mono) and the insertion caret. The
input field can be changed with the <Tab> key.  The user can start the
searching process by typing the begin of the field and <Return>. For
the search only the content of the current active input field is
considered.  xwafetel will display all entries, which partly or
completely match the specified string. If more then one record is
found, the user can view the other matches with the keys <arrow up>
and <arrow down> or <page up> and <page down>. The application can be
terminated using the "quit" button.

.SH "KEY BINDINGS"
.TP 13
<Key>Up
show previous entry
.TP
<Key>Down
show next entry
.TP
<Key>Prior
show previous entry
.TP
<Key>Next
show next entry

.TP
<Key>Return
start a search

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$wafetelDB
specifies the default database
.TP
$wafetelDBalt
specifies the alternative default database
.TP
$normalFont
used to display the current record
.TP
$boldFont
used to display the names of the fields.
.TP
$buttonFont
typically used as font for buttons
.TP
$buttonAtts
attributes used for buttons
.TP
$background
background color
.TP
$roColors
attributes for non emphasized text (typically colors)
.TP
$highLight
attributes for emphasized text portions (typically colors)
.TP
%textResources
default resources for text widgets
.TP
@textActions
default actions for text widgets

.SH "FILES" 
.PP
.EX 0
$WAFELIB/system.waferc
$HOME/.waferc
.EE

.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
    Wirtschaftsuniversitaet Wien, 
    Abteilung fuer Wirtschaftsinformatik
    Augasse 2-6, 
    A-1090 Vienna, Austria
    neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
