/* 
 * tclTest.c --
 *
 *	Test driver for TCL.
 *
 * Copyright 1987-1991 Regents of the University of California
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/* This file has been heavily modified for use with the tkWWW.server
 * program.
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <tcl.h>

/* Get prototypes */
#ifdef __STDC__
#include <stdlib.h>
#define _PROTO(x)  x
#else
extern int exit();
#define _PROTO(x)  ()
#endif

/* Recognize init_tkWWW */
extern void init_tkWWW _PROTO((Tcl_Interp *));
int quitFlag = 0;

int main()
{
  char line[1000], *cmd;
  int result, gotPartial;
  char *prompt = "tkWWW:";

  /* Intialize interpreter and buffer */
  Tcl_Interp *interp = Tcl_CreateInterp();
  Tcl_CmdBuf buffer = Tcl_CreateCmdBuf();

  /* Add tkWWW commands */
  init_tkWWW(interp);

  /* Put out the header */
  printf("tkWWW Server Version %s\n", SERVER_VERSION);

  gotPartial = 0;
  while (1) {
    clearerr(stdin);
    if (!gotPartial) {
      puts(prompt);
      fflush(stdout);
    }
    if (fgets(line, 1000, stdin) == NULL) {
      if (!gotPartial) 
	exit(0);
      line[0] = 0;
    }
    cmd = Tcl_AssembleCmd(buffer, line);
    if (!cmd) {
      gotPartial = 1;
      continue;
    }

    gotPartial = 0;
    result = Tcl_RecordAndEval(interp, cmd, 0);
    if (result == TCL_OK) {
      if (*interp->result)
	puts(interp->result);

      if (quitFlag) {
	Tcl_DeleteInterp(interp);
	Tcl_DeleteCmdBuf(buffer);
	exit(0);
      }
    } else {
      fputs("Error", stdout);
      if (result != TCL_ERROR) 
	printf(" %d", result);
	
      if (*interp->result) {
	fputs(": ", stdout);
	fputs(interp->result, stdout);
      }
      fputs("\n", stdout);
    }
  }
}
