/*
 * $Id: wishgdbm.c,v 1.2 1994/04/27 07:05:13 lindig Exp $
 */

#include "tk.h"
#include "gdbmcmd.h"

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tk library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tk and Tcl with it).
 */

extern int main();
int *tclDummyMainPtr = (int *) main;

/*
 * The Tcl_AppInit() function as suggested by J. Ousterhout
 */

int 
Tcl_AppInit(interp)
Tcl_Interp *interp ;

{

    Tk_Window main;
    main = Tk_MainWindow(interp);

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    
    /*
     * initialize GDBM package
     */

    if (tcl_gdbm_init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }


    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    tcl_RcFileName = "~/.wishgdbmrc";
    return TCL_OK;
}
