# ----------------------------- -*- Mode: Tcl -*- -----------------------------
# getrecords.tcl - Retrieve records from a Postgres table.
# 
# %W%
# 
# Written by
# Robin J. Maxwell
# Open Systems Solutions, Inc
# Collaboration Software Group.
# 
# Copyright (c) 1992 Open Systems Solutions, Inc
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  
# Open Systems Solutions, Inc. and Robin J. Maxwell make no representations
# about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.
#
# 
# Author          : Robin J. Maxwell
# Created On      : Wed Oct 28 13:54:29 1992
# Last Modified By: Robin J. Maxwell
# Last Modified On: Wed Oct 28 15:26:02 1992
# Update Count    : 19
# Status          : Unknown, Use with caution!
# ----------------------------------------------------------------------------

#
# These procs assume the existence of a Test database.
# You should adjust the name as you need.

proc retrieve_records {dbname query} {
    PQsetdb $dbname
    set res [PQexec $query]
    set records ""
    if {[string range $res 0 0] == "E"} {
	puts stderr [format "%s\nretrieve_record failed" $res]
	return
    }
    if {[string range $res 0 0] != "P"} {
	puts stderr [format "retrieve_record: no portal?!?\n"]
	return
    }
    set portalname [string range $res 1 end]
    set hportal [PQparray $portalname]
    set ngroups [PQngroups $hportal]
    loop grpno 0 $ngroups 1 {
	set ntups [PQntuplesGroup $hportal $grpno]
	set nfields [PQnfieldsGroup $hportal $grpno]
	loop tupno 0 $ntups 1 {
	    loop fldno 0 $nfields 1 {
		set fldname [PQfnameGroup $hportal $grpno $fldno]
		set fldvalue [PQgetvalue $hportal $tupno $fldno]
		keylset record $fldname $fldvalue
	    }
	    lappend records $record
	}
    }
    PQfinish
    return $records
}

proc CreateTable {} {
    PQsetdb Test
    PQexec {create test_table (name=text)}
    PQexec {addattr (phone=text) to test_table}
    PQexec {addattr (emailid=text) to test_table}
}

proc BuildTable {} {
    PQsetdb Test
    PQexec {append test_table (name="Robin J. Maxwell", phone="(408)456-7281",emailid="rmaxwell@ossi.com")}
    PQexec {append test_table (name="Fred Derf", phone="(408)111-2222",emailid="fderf@big.com")}
}

proc GetRecords {} {
    set query "retrieve (TT.all) from TT in test_table sort by name"
    echo $query
    set record [retrieve_records Test $query]
    return $record
}


