// ---------------------------- -*- Mode: C++ -*- ----------------------------
// PQTcl.hpp - Tcl extensions for Postgres.
// 
// %W%
// 
// Written by
// Robin J. Maxwell
// Open Systems Solutions, Inc
// Collaboration Software Group.
// 
// Copyright (c) 1992 Open Systems Solutions, Inc
// 
// Permission to use, copy, modify, and distribute this software and its
// documentation for any purpose and without fee is hereby granted, provided
// that the above copyright notice appear in all copies.  
// Open Systems Solutions, Inc. and Robin J. Maxwell make no representations
// about the suitability of this software for any purpose.
// It is provided "as is" without express or implied warranty.
//
// Author          : Robin J. Maxwell
// Created On      : Wed Jul 29 10:53:02 1992
// Last Modified By: Robin J. Maxwell
// Last Modified On: Wed Oct 28 11:27:07 1992
// Update Count    : 11
// Status          : Tested.
// ---------------------------------------------------------------------------


#ifndef _PQTCL_HPP
#define _PQTCL_HPP

#include "tcl++.hpp"
extern "C" {
#include "libpq-fe.h"
}

#ifndef MAXPORTALS
#define MAXPORTALS 10
#endif

// typedef char * PortalBuffer;
typedef PortalBuffer **PBuffer_pt;

class PQTcl
{
    TclInterp_cl &Interp;
    TclHandleTbl_cl handles;
    char *dbname;

public:
    PQTcl(TclInterp_cl &tclI);
    ~PQTcl();
    //
    // Extension commands.
    int PQsetdbCmd(int argc, char *argv[]);
    static int PQsetdbCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQdbCmd(int, char**){Interp.SetResult(dbname); return TCL_OK;}
    static int PQdbCmd_S(ClientData, Tcl_Interp *, int, char*argv[]);

    int PQresetCmd(int, char**){PQreset(); return TCL_OK;}
    static int PQresetCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQFinishCmd(int, char **){PQfinish(); return TCL_OK;}
    static int PQFinishCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQexecCmd(int argc, char *argv[]);
    static int PQexecCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQnportalsCmd(int argc, char *argv[]);
    static int PQnportalsCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQnamesCmd(int argc, char *argv[]);
    static int PQnamesCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQparrayCmd(int argc, char *argv[]);
    static int PQparrayCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQclearCmd(int argc, char *argv[]);
    static int PQclearCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQrulepCmd(int argc, char *argv[]);
    static int PQrulepCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQntuplesCmd(int argc,char *argv[]);
    static int PQntuplesCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQngroupsCmd(int argc,char *argv[]);
    static int PQngroupsCmd_S(ClientData, Tcl_Interp *, int,char *argv[]);

    int PQntuplesGroupCmd(int argc, char *argv[]);
    static int PQntuplesGroupCmd_S(ClientData, Tcl_Interp *, int, 
				   char *argv[]);

    int PQnfieldsGroupCmd(int argc, char *argv[]);
    static int PQnfieldsGroupCmd_S(ClientData, Tcl_Interp *, int, 
				   char *argv[]);

    int PQfnameGroupCmd(int argc, char *argv[]);
    static int PQfnameGroupCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQfnumberGroupCmd(int, char *argv[]);
    static int PQfnumberGroupCmd_S(ClientData, Tcl_Interp *, int, 
				   char *argv[]);

    int PQgetgroupCmd(int argc, char *argv[]);
    static int PQgetgroupCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQnfieldsCmd(int argc, char *argv[]);
    static int PQnfieldsCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQfnumberCmd(int argc, char *argv[]);
    static int PQfnumberCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQfnameCmd(int argc, char *argv[]);
    static int PQfnameCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQftypeCmd(int argc, char *argv[]);
    static int PQftypeCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQsametypeCmd(int argc, char *argv[]);
    static int PQsametypeCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQgetvalueCmd(int argc, char *argv[]);
    static int PQgetvalueCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQtraceCmd(int, char **){PQtrace(); return TCL_OK;}
    static int PQtraceCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

    int PQuntraceCmd(int, char **){PQuntrace(); return TCL_OK;}
    static int PQuntraceCmd_S(ClientData, Tcl_Interp *, int, char *argv[]);

private:
    int AppendArgCountError(const char *cname, const char *arglist);
    int AppendHandleError(const char *cname, const char *handle);
};

#endif // _PQTCL_HPP
