/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

@XmlType(name="AbstractGeneralOperationParameterType", propOrder={"nonDefaultMinimumOccurs", "nonDefaultMaximumOccurs"})
@XmlSeeAlso(value={DefaultParameterDescriptor.class, DefaultParameterDescriptorGroup.class})
public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -4346475760810353590L;
    private short minimumOccurs;
    private short maximumOccurs;

    protected AbstractParameterDescriptor(Map<String, ?> map, int n, int n2) {
        super(map);
        this.minimumOccurs = (short)n;
        this.maximumOccurs = (short)n2;
        if (n < 0 || n > n2 || n2 == 0) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)60, n, n2));
        }
        if (n2 > 65534 && n2 != Integer.MAX_VALUE) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)130, 65534, super.getName().getCode()));
        }
    }

    protected AbstractParameterDescriptor(GeneralParameterDescriptor generalParameterDescriptor) {
        super(generalParameterDescriptor);
        this.minimumOccurs = AbstractParameterDescriptor.crop(generalParameterDescriptor.getMinimumOccurs());
        this.maximumOccurs = AbstractParameterDescriptor.crop(generalParameterDescriptor.getMaximumOccurs());
    }

    private static short crop(int n) {
        return (short)Math.max(0, Math.min(65535, n));
    }

    public Class<? extends GeneralParameterDescriptor> getInterface() {
        return GeneralParameterDescriptor.class;
    }

    @Override
    public int getMinimumOccurs() {
        return this.minimumOccurs & 0xFFFF;
    }

    @Override
    public int getMaximumOccurs() {
        return this.maximumOccurs != -1 ? this.maximumOccurs & 0xFFFF : Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractParameterDescriptor abstractParameterDescriptor = (AbstractParameterDescriptor)object;
                    return this.minimumOccurs == abstractParameterDescriptor.minimumOccurs && this.maximumOccurs == abstractParameterDescriptor.maximumOccurs;
                }
            }
            GeneralParameterDescriptor generalParameterDescriptor = (GeneralParameterDescriptor)object;
            return this.getMinimumOccurs() == generalParameterDescriptor.getMinimumOccurs() && this.getMaximumOccurs() == generalParameterDescriptor.getMaximumOccurs();
        }
        return false;
    }

    @Override
    public String toString() {
        if (this instanceof ParameterDescriptorGroup) {
            return ParameterFormat.sharedFormat(this);
        }
        return super.toString();
    }

    @Override
    public void print() {
        if (this instanceof ParameterDescriptorGroup) {
            ParameterFormat.print(this);
        } else {
            super.print();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.setInvalidWKT(this, null);
        if (this instanceof ParameterDescriptorGroup) {
            for (GeneralParameterDescriptor generalParameterDescriptor : ((ParameterDescriptorGroup)((Object)this)).descriptors()) {
                void abstractParameterDescriptor;
                if (!(generalParameterDescriptor instanceof FormattableObject)) {
                    if (generalParameterDescriptor instanceof ParameterDescriptor) {
                        DefaultParameterDescriptor defaultParameterDescriptor = new DefaultParameterDescriptor((ParameterDescriptor)generalParameterDescriptor);
                    } else {
                        if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup)) continue;
                        DefaultParameterDescriptorGroup defaultParameterDescriptorGroup = new DefaultParameterDescriptorGroup((ParameterDescriptorGroup)generalParameterDescriptor);
                    }
                }
                formatter.newLine();
                formatter.append((FormattableObject)abstractParameterDescriptor);
            }
            return "ParameterGroup";
        }
        if (this instanceof ParameterDescriptor) {
            Object t = ((ParameterDescriptor)((Object)this)).getDefaultValue();
            if (t != null) {
                formatter.appendAny(t);
            }
            formatter.append(((ParameterDescriptor)((Object)this)).getUnit());
        }
        return "Parameter";
    }

    AbstractParameterDescriptor() {
        super(NilReferencingObject.INSTANCE);
        this.minimumOccurs = 1;
        this.maximumOccurs = 1;
    }

    @XmlElement(name="minimumOccurs")
    @XmlSchemaType(name="nonNegativeInteger")
    private Integer getNonDefaultMinimumOccurs() {
        int n = this.getMinimumOccurs();
        return n != 1 ? Integer.valueOf(n) : null;
    }

    @XmlElement(name="maximumOccurs")
    @XmlSchemaType(name="nonNegativeInteger")
    private Integer getNonDefaultMaximumOccurs() {
        int n = this.getMaximumOccurs();
        return n != 1 ? Integer.valueOf(n) : null;
    }

    private void setNonDefaultMinimumOccurs(Integer n) {
        this.minimumOccurs = n != null ? AbstractParameterDescriptor.crop(n) : (short)1;
    }

    private void setNonDefaultMaximumOccurs(Integer n) {
        this.maximumOccurs = n != null ? AbstractParameterDescriptor.crop(n) : (short)1;
    }
}

