/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.Vector;
import org.apache.sis.util.collection.IntegerList;
import org.apache.sis.util.resources.Errors;

final class PackedVector
extends ArrayVector<Long> {
    private static final long serialVersionUID = 5097586732924434042L;
    static final int MINIMAL_SIZE = 8;
    private final IntegerList data;
    private final long increment;
    private final long offset;

    private PackedVector(Vector vector, long l, long l2, int n) {
        this.increment = l;
        this.offset = l2;
        int n2 = vector.size();
        this.data = new IntegerList(n2, n, true);
        for (int i = 0; i < n2; ++i) {
            this.data.setInt(i, JDK8.toIntExact((vector.longValue(i) - l2) / l));
        }
    }

    static PackedVector compress(Vector vector, long l, long l2) {
        long l3 = l2 - l;
        if (l3 > 0L) {
            long l4 = l3;
            int n = vector.size();
            if (n >= 8) {
                for (int i = 0; i < n; ++i) {
                    long l5;
                    long l6 = vector.longValue(i) - l;
                    if (l6 < 0L) {
                        return null;
                    }
                    if (l6 % l4 == 0L) continue;
                    do {
                        l5 = l4 % l6;
                        l4 = l6;
                    } while ((l6 = l5) != 0L);
                    if (l4 != 1L) continue;
                    l5 = Long.highestOneBit(l3);
                    if ((l5 & 0x8000000080008080L) == 0L) break;
                    long l7 = l5 - 1L;
                    if (l >= 0L && (l7 |= l5) < 0L) {
                        return null;
                    }
                    if (l2 > l7 || l < (l7 ^ 0xFFFFFFFFFFFFFFFFL)) break;
                    return null;
                }
                if ((l3 /= l4) > Integer.MAX_VALUE) {
                    return null;
                }
                return new PackedVector(vector, l4, l, (int)l3);
            }
        }
        return null;
    }

    @Override
    public Class<Long> getElementType() {
        return Long.class;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public double doubleValue(int n) {
        return this.longValue(n);
    }

    @Override
    public float floatValue(int n) {
        return this.longValue(n);
    }

    @Override
    public long longValue(int n) {
        return (long)this.data.getInt(n) * this.increment + this.offset;
    }

    @Override
    public String stringValue(int n) {
        return Long.toString(this.longValue(n));
    }

    @Override
    public Number get(int n) {
        return this.longValue(n);
    }

    @Override
    public Number set(int n, Number number) {
        this.verifyType(number.getClass(), (byte)6);
        long l = number.longValue();
        if (l >= this.offset && (l -= this.offset) % this.increment == 0L && (l /= this.increment) <= (long)this.data.maximalValue()) {
            Number number2 = this.get(n);
            this.data.setInt(n, (int)l);
            ++this.modCount;
            return number2;
        }
        throw new IllegalArgumentException(Errors.format((short)175, number));
    }
}

