/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import java.util.Arrays;
import java.util.List;

public class TwoSecondIntersectionFinder
implements FragmentIntersectionFinder {
    protected long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }

    public int[] sampleNumbers(Track track, Movie movie) {
        List<TimeToSampleBox.Entry> entries = track.getDecodingTimeEntries();
        double trackLength = 0.0;
        for (Track thisTrack : movie.getTracks()) {
            double thisTracksLength = this.getDuration(thisTrack) / thisTrack.getTrackMetaData().getTimescale();
            if (!(trackLength < thisTracksLength)) continue;
            trackLength = thisTracksLength;
        }
        int[] fragments = new int[(int)Math.ceil(trackLength / 2.0) - 1];
        Arrays.fill(fragments, -1);
        fragments[0] = 0;
        long time = 0L;
        int samples = 0;
        block1: for (TimeToSampleBox.Entry entry : entries) {
            int i = 0;
            while ((long)i < entry.getCount()) {
                int currentFragment = (int)(time / track.getTrackMetaData().getTimescale() / 2L) + 1;
                if (currentFragment >= fragments.length) continue block1;
                fragments[currentFragment] = samples++;
                time += entry.getDelta();
                ++i;
            }
        }
        int last = samples;
        int i = fragments.length - 1;
        while (i >= 0) {
            if (fragments[i] == -1) {
                fragments[i] = last;
            }
            last = fragments[i];
            --i;
        }
        return fragments;
    }
}

