/*
 * $Id: udres.h,v 2.10 1991/08/29 18:39:17 steve Exp $
 *
 * $__Header$
 */

#ifndef UD_UDRES_H_INCLUDED
#define UD_UDRES_H_INCLUDED

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#ifndef	PROTO
#   if defined(__STDC__) || defined(__GNUC__) || defined(__cplusplus) || defined(c_plusplus)
#	define	PROTO(a)	a
#   else
#	define	PROTO(a)	()
#   endif
#endif

#ifndef	VOIDP
#   define	VOIDP		void*
#endif

/*
 * Environment variable whose value is a list of resource files to
 * merge into the resource database:
 */
#define UDRESPATH "UDRESPATH"


/*
 * The suffix of a resource file, as in "Myresourcefile.suffix"
 * If non empty, then it should contain the dot or other separator.
 */
#define URES_SUFFIX ".res"


/*
 * The function-prototype argument-list for converter-functions:
 */
#define UD_CONVERTER_PROTOTYPE	PROTO(( \
    VOIDP	string,		/* Use depends on mode: \
				 *   UD_MNEMONIC:  place to put pointer to \
				 *	mnemonic string (char**); \
				 *   UD_POINTER:   pointer to binary object, \
				 *	e.g. (float*); \
				 *   UD_BIN_SIZE:  not used; \
				 *   UD_TO_STRING: place to put pointer to \
				 *	string (char**); \
				 *   UD_TO_BINARY: pointer to string to be \
				 *	decoded (char*). \
				 */ \
    VOIDP	bin,		/* Use depends on mode: \
				 *   UD_MNEMONIC:  not used; \
				 *   UD_POINTER:   place to put pointer to \
				 *	binary object, e.g. (float**); \
				 *   UD_BIN_SIZE:  not used; \
				 *   UD_TO_STRING: pointer to binary object, \
				 *	e.g. (float*); \
				 *   UD_TO_BINARY: pointer to binary object, \
				 *	e.g. (float*); \
				 */ \
    int		mode		/* The action to be performed */ \
))


/*
 * Modes for the binary-to-and-from-string converters:
 */
#define	UD_TO_STRING	1	/* Convert from binary representation to string
				 * representation */
#define	UD_TO_BINARY	2	/* Convert from string representation to binary
				 * representation */
#define	UD_MNEMONIC	3
#define	UD_POINTER	4
#define	UD_BIN_SIZE	5
#define	UD_FROM_STRING	UD_TO_BINARY
#define	UD_FROM_BINARY	UD_TO_STRING


/*
 * Converter-function type:
 */
typedef int	UdConverter	UD_CONVERTER_PROTOTYPE;

#define	UDARB	-999	
#define	UDOPT	1
#define	UDREQ	2

/*
 * The type of an entry in the keyed-parameter table:
 */
typedef struct {
    char	*name;		/* Name of the key */
    int		nval;		/* Number of expected values: 
				 *    =0 => same as 1 (so just a ',' works)
				 *    >0 =>  number of values
				 *    UDARB => arbitrary number of values */
    UdConverter	*funct;		/* Converter function. Nil => no type 
				 * checking.  */
    VOIDP	where;		/* Destination for values. Nil => not used.
				 * If `nval' == UDARB, then the converter-
				 * function will allocate storage for the 
				 * values and *`where' shall point to the first
				 * value. If `nval' != UDARB, then `where' 
				 * shall point to user-allocated space 
				 * sufficient to hold the binary values.  */
    int		*count;		/* Actual number of values decoded:
				 *    NULL => exactly "nval" expected;
				 *    non-NULL => up to "nval" expected. */
    int		required;	/* UDREQ => required; UDOPT => optional; 
				 * default = optional. */
}   UdKeyEntry;

typedef UdKeyEntry	UdKeyTab[];


/*
 * The type of an entry in the positional-parameter table:
 */
typedef struct {
    char	*name;		/* Name of the positional-parameter */
    int		nval;		/* Number of expected values: 
				 *    =0 => same as 1 (so just a ',' works)
				 *    >0 =>  number of values
				 *    UDARB => arbitrary number of values */
    UdConverter	*funct;		/* Converter function. Nil => no type 
				 * checking. */
    VOIDP	where;		/* Destination for values. Nil => not used.
				 * If `nval' == UDARB, then the converter-
				 * function will allocate storage for the 
				 * values and *`where' shall point to the first
				 * value.  If `nval' != UDARB, then `where'
				 * shall point to user-allocated space
				 * sufficient to hold the values. */
    int		*count;		/* Actual number of values decoded:
				 *    NULL => exactly "nval" expected;
				 *    non-NULL => up to "nval" expected. */
    int		required;	/* UDREQ => required; UDOPT => optional; 
				 * default = required. */
}   UdPosEntry;

typedef UdPosEntry	UdPosTab[];


/*
 * Last entry of UdOption tables, so user need not count entries:
 */
#define UDENDOFTABLE { 0 }


/*
 * Converter-functions:
 */
extern int	UdString	UD_CONVERTER_PROTOTYPE;
extern int	UdInFile	UD_CONVERTER_PROTOTYPE;
extern int	UdOutFile	UD_CONVERTER_PROTOTYPE;
extern int	UdInDir		UD_CONVERTER_PROTOTYPE;
extern int	UdOutDir	UD_CONVERTER_PROTOTYPE;
extern int	UdBool		UD_CONVERTER_PROTOTYPE;
extern int	UdChar		UD_CONVERTER_PROTOTYPE;
extern int	UdShort		UD_CONVERTER_PROTOTYPE;
extern int	UdInt		UD_CONVERTER_PROTOTYPE;
extern int	UdLong		UD_CONVERTER_PROTOTYPE;
extern int	UdFloat		UD_CONVERTER_PROTOTYPE;
extern int	UdDouble	UD_CONVERTER_PROTOTYPE;


/*
 * The following function creates a Unidata applications resource database, 
 * stores default resources into the database, and parses the command line --
 * storing any recognized parameters which will, consequently, override Unidata
 * resources specified external to the program.  It returns 0 on failure
 * and 1 on success.
 */
extern int	udinit		PROTO((
    UdKeyEntry	*KeyTab,	/* Command-line keyed-parameter table.  See
				 * the definition of `UdKeyEntry' above. */

    UdPosEntry	*PosTab,	/* Command-line positional-parameter table.
				 * See the definition of `UdPosEntry' above. */

    int		*argc,		/* Number of words in command-line */

    char	**argv,		/* Words of command-line */

    char	*ProgName,	/* Name of program.  Used to obtain
                                 * application-specific resources specified
				 * external to this program.  Any leading 
				 * components of a pathname will be stripped so
				 * argv[0] could be used, for example.  NULL =>
				 * use argv[0]. */

    char	*ClassName	/* Name of program class.  Used to obtain
                                 * class-specific resources specified external
				 * to this program.  NULL => use program
				 * name with 1st letter capitalized. */
));


/*
 * The following function converts the value-string of a resource in the 
 * resource database created by udinit() to a binary representation.  It 
 * returns the number of converted values.  It also prepends the program name
 * and program class (as set in the previous udinit() call) to the given name
 * and class specifiers.
 */
extern int	udgetval	PROTO((
    char	*name,		/* Resource name (excluding program name) */

    char	*rclass,	/* Resource class (excluding program class).
				 * NULL <=> use resource name with the first 
				 * letter of each component capitalized */

    int		nwant,		/* Desired number of values or UDARB (=> 
				 * arbitrary number of values).
				 * NB: For boolean resource types, `nwant' 
				 * shall be 1 because one resource string
				 * must be converted (it could be "false").
				 * Consequently, a user-supplied value of zero 
				 * is somewhat meaningless. */

    UdConverter	*funct,		/* Converter-function */

    VOIDP	where,		/* Destination for values.  For resources with
				 * a fixed or maximum number of values, `where'
				 * is the location of user-supplied storage.
				 * For resources with an arbitrary number of
				 * values, `*where' will receive the location
				 * of malloc'ed space containing the values. */

    int		*count		/* Number of values decoded:
				 *   NULL => exactly "nwant" expected; 
				 *   non-NULL => up to "nwant" expected. */
));


/*
 * The following function returns the value-string of a resource contained in 
 * the Unidata database created by udinit().  It returns a nil-pointer if the
 * resource couldn't be obtained.  Do not modify the returned string.
 */
extern char*	udgetres	PROTO((
    char	*name,		/* Resource name-key.  This can be a simple 
				 * option name or a fully qualified list of
				 * names separated by ".".  The program name
				 * will be prepended before searching. */

    char	*rclass		/* Resource class-key (excluding program
				 * class).  NULL <=> use resource name with the
				 * first letter of each component capitalized.
				 */
));

/*
 * The following short-cut macro gets a resource value-string using a
 * valid resource-name but a nil class-name.  See `udgetres()' above.
 */
#define	udgetdef(name)		udgetres(name, (char*)NULL)


/*
 * The following function adds a resource to the database created by udinit()
 * or redefines an already existing resource.  It returns 0 if and only if the 
 * resource could not be placed in the database.
 */
extern int	udputval	PROTO((
    char	*key,		/* Partial storage-key.  Program name will be
				 * prepended. */

    int		nval,		/* Number of values to be converted into a
				 * resource value-string. */

    UdConverter	*funct,		/* Converter function */

    VOIDP	where		/* Source of the binary values */
));


/*
 * The following function adds a resource specified as a value-string to the
 * resource database created by udinit().  It returns 0 if and only if the
 * resource could not be placed in the database.
 */
extern int	udputres	PROTO((
    char	*key,		/* Partial storage-key.  Program name will be
				 * prepended. */

    char	*value		/* The resource value-string */
));


/*
 * The following function prints a usage message.  udinit() must have been 
 * called first.
 */
extern void	udusage		PROTO(());

/*
 * The following function returns true if and only if an error occurred.
 */
extern int	udreserr	PROTO(());

#endif	/* !UD_UDRES_H_INCLUDED */
