/*
 * $Id: signal.h,v 1.1 1991/09/05 15:33:32 steve Exp $
 *
 * UDPOSIX header-file for the UNICOS 5.1.11 version of <signal.h>.
 */

#ifndef UDPOSIX_H_INCLUDED
#   include "/usr//include//stdc//signal.h"
#else

#ifndef UD_SIGNAL_H_INCLUDED
#define	UD_SIGNAL_H_INCLUDED

/*
 * Include the system-supplied header-file.
 */
#include "/usr//include//stdc//signal.h"

/*
 * Define/declare missing items:
 */
#define SIG_BLOCK	0
#define SIG_UNBLOCK	1
#define SIG_SETMASK	2

typedef unsigned long	sigset_t;

struct sigaction {
    void	(*sa_handler)();
    sigset_t	sa_mask;
    int		sa_flags;
};

extern int	sigaction	PROTO((
    int				sig,
    const struct sigaction	*act,
    struct sigaction		*oact
));

extern int	sigaddset	PROTO((
    sigset_t	*mask,
    int		num
));

extern int	sigdelset	PROTO((
    sigset_t	*mask,
    int		num
));

extern int	sigemptyset	PROTO((
    sigset_t	*mask
));

extern int	sigprocmask	PROTO((
    int			action,
    const sigset_t	*in_mask,
    sigset_t		*out_mask
));

extern int	sigsuspend	PROTO((
    const sigset_t	*mask
));

#endif	/* UD_SIGNAL_H_INCLUDED not defined*/

#endif	/* UDPOSIX_H_INCLUDED defined */
