/*
 * <sys/utsname.h> functions for NeXTOS.
 *
 */

#ifndef lint
    static char	rcsid[]	= "$Id: utsname.c,v 1.2 1991/08/27 19:03:51 steve Exp $";
#endif

/*
 * POSIX declarations:
 */
#include "udposix.h"
#include <sys/utsname.h>	/* for struct utsname */

/*
 * Non-POSIX declarations:
 */
extern int	gethostname	PROTO((char *name, int namelen));


/*
 * uname()
 */
    int
uname(name)
    struct utsname	*name;
{
    name->sysname[0]	= 0;
    name->release[0]	= 0;
    name->version[0]	= 0;
    name->machine[0]	= 0;

    name->nodename[sizeof(name->nodename)-1]	= 0;
    return gethostname(name->nodename, sizeof(name->nodename)-1);
}
