/*
 * $Id: uderrmsg.h,v 1.6 1991/08/30 15:34:42 mschmidt Exp $
 *
 * $__Header$
 */

#ifndef UD_ERROR_H_INCLUDED
#define UD_ERROR_H_INCLUDED

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#ifndef	PROTO
#   if defined(__STDC__) || defined(__GNUC__) || defined(__cplusplus) || defined(c_plusplus)
#	define	PROTO(a)	a
#   else
#	define	PROTO(a)	()
#   endif
#endif

extern int	uderrmode	PROTO((const int mode));
extern char*	uderrname	PROTO((const char *name));
extern void	uderror		PROTO((const char *fmt, ...));
extern void	udadvise	PROTO((const char *fmt, ...));


/*
 * Global options variable. Used to determine behavior of error handler.
 *  Initialized in lerror.c
 */
#define	UD_FATAL	1
#define	UD_VERBOSE	2


#endif	/* !UD_ERROR_H_INCLUDED */
