		name	V320x400
		title	Standard VGA - 320 x 400 image display.
		page	132,60


		.model	LARGE,c

;==============================================================
;
; These routines (with minor changes) are from the column:
;
;	"On Graphics", in the Programmer's Journal, by Micheal Abrash.
;
; The text:
;
;	"Power Graphics Programming" by Micheal Abrash,
;	Que Corporation (Carmel, Indiana), 1989.
;
; is a collection of articles from the "On graphics" column in the
; Programmer's Journal and contains lots of useful info on EGAs and VGAs.
;

VGA_SEGMENT	equ	0a000h
SC_INDEX	equ	3c4h	;Sequence Controller Index register
GC_INDEX	equ	3ceh	;Graphics Controller Index register
CRTC_INDEX	equ	3d4h	;CRT Controller Index register
MAP_MASK	equ	2	;Map Mask register index in SC
MEMORY_MODE	equ	4	;Memory Mode register index in SC
MAX_SCAN_LINE	equ	9	;Maximum Scan Line reg index in CRTC
START_ADDRESS_HIGH equ	0ch	;Start Address High reg index in CRTC
UNDERLINE	equ	14h	;Underline Location reg index in CRTC
MODE_CONTROL	equ	17h	;Mode Control register index in CRTC
GRAPHICS_MODE	equ	5	;Graphics Mode register index in GC
MISCELLANEOUS	equ	6	;Miscellaneous register index in GC
SCREEN_WIDTH	equ	320	;# of pixels across screen
SCREEN_HEIGHT	equ	400	;# of scan lines on screen
WORD_OUTS_OK	equ	1	;set to 0 to assemble for
				; computers that can't handle
				; word outs to indexed VGA registers


;
; Macro to output a word value to a port.
;
OUT_WORD	macro
if WORD_OUTS_OK
	out	dx,ax
else
	out	dx,al
	inc	dx
	xchg	ah,al
	out	dx,al
	dec	dx
	xchg	ah,al
endif
	endm


;
; Macro to output a constant value to an indexed VGA register.
;
CONSTANT_TO_INDEXED_REGISTER	macro	ADDRESS, INDEX, VALUE
	mov	dx,ADDRESS
	mov	ax,(VALUE shl 8) + INDEX
	OUT_WORD
	endm


		.code stuff



;=================================================
; Sets up 320x400 256-color modes.
;
; Input: none
;
; Output: none
;
;=================================================

Set320x400Mode	proc	uses di es

;
; First, go to normal 320x200 256-color mode, which is really a
; 320x400 256-color mode with each line scanned twice.
;
	mov	ax,0013h  ;AH = 0 means mode set, AL = 13h selects
			; 256-color graphics mode
	int	10h	;BIOS video interrupt
;
; Change CPU addressing of video memory to linear (not odd/even,
; chain, or chain 4), to allow us to access all 256K of display
; memory. When this is done, VGA memory will look just like memory
; in modes 10h and 12h, except that each byte of display memory will
; control one 256-color pixel, with 4 adjacent pixels at any given
; address, one pixel per plane.
;
	mov	dx,SC_INDEX
	mov	al,MEMORY_MODE
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 08h	;turn off chain 4
	or	al,04h		;turn off odd/even
	out	dx,al
	mov	dx,GC_INDEX
	mov	al,GRAPHICS_MODE
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 10h	;turn off odd/even
	out	dx,al
	dec	dx
	mov	al,MISCELLANEOUS
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 02h	;turn off chain
	out	dx,al
;
; Now clear the whole screen, since the mode 13h mode set only
; cleared 64K out of the 256K of display memory. Do this before
; we switch the CRTC out of mode 13h, so we don't see garbage
; on the screen when we make the switch.
;
	CONSTANT_TO_INDEXED_REGISTER SC_INDEX,MAP_MASK,0fh
				;enable writes to all planes, so
				; we can clear 4 pixels at a time
	mov	ax,VGA_SEGMENT
	mov	es,ax
	sub	di,di
	mov	ax,di
	mov	cx,8000h	;# of words in 64K
	cld
	rep	stosw		;clear all of display memory
;
; Tweak the mode to 320x400 256-color mode by not scanning each
; line twice.
;
	mov	dx,CRTC_INDEX
	mov	al,MAX_SCAN_LINE
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 1fh	;set maximum scan line = 0
	out	dx,al
	dec	dx
;
; Change CRTC scanning from doubleword mode to byte mode, allowing
; the CRTC to scan more than 64K of video data.
;
	mov	al,UNDERLINE
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 40h	;turn off doubleword
	out	dx,al
	dec	dx
	mov	al,MODE_CONTROL
	out	dx,al
	inc	dx
	in	al,dx
	or	al,40h	;turn on the byte mode bit, so memory is
			; scanned for video data in a purely
			; linear way, just as in modes 10h and 12h
	out	dx,al
	xor	ax,ax
	ret
Set320x400Mode	endp



;=================================================
; Displays page 0 or 1 of the video buffer.
;
; Input:
;	pg:	== 0 - page 0
;		!= 0 - page 1
;
; Output: none
;
;=================================================

Page320x400	proc	uses si di ds es, pg:word
		cmp	pg,0
		jz	Page320x400_1
				; Set the Start Address High register
				; to 80h, for a start address of 8000h
		CONSTANT_TO_INDEXED_REGISTER CRTC_INDEX,START_ADDRESS_HIGH,80h
		jmp	short Page320x400_2
Page320x400_1:
				; Set the Start Address High register
				; to 00h, for a start address of 0000h
		CONSTANT_TO_INDEXED_REGISTER CRTC_INDEX,START_ADDRESS_HIGH,00h
Page320x400_2:
		ret
Page320x400	endp



;=================================================
; Outputs a line to the video buffer.
;
; Input:
;	line:	y co-ord
;	l:	pointer to line
;	len:	number of bytes to output
;	pg:	== 0 - page 0
;		!= 0 - page 1
;
; Output: none
;
;=================================================

Out320x400Line	proc	uses si di ds es, line:word, l:ptr, len:word, pg:word

		mov	ax,VGA_SEGMENT
		mov	es,ax
		mov	ax,line
		mov	dx,80
		mul	dx
		mov	di,ax
		cmp	pg,0
		jz	UsePage0
		add	di,8000H		; Use page 1 (starts at offset 8000H)
UsePage0:
		if	@datasize
		 lds	si,l
		else
		 mov	si,l
		endif

		mov	dx,SC_INDEX
		mov	al,MAP_MASK
		out	dx,al
		inc	dx

		mov	cx,len
		push	cx

		shr	cx,1
		shr	cx,1
		mov	ah,1
next_plane:
		push	cx
		push	di
		xor	bx,bx

		mov	al,ah		; Select plane
		out	dx,al

out_line:				; Output all bytes in line for this plane
		mov	al,ds:[si+bx]
		mov	es:[di],al
		inc	di
		add	bx,4
		loop	out_line

		pop	di
		pop	cx

		inc	si

		shl	ah,1
		cmp	ah,16
		jne	next_plane

		pop	cx
		xor	ax,ax
		ret
Out320x400Line	endp




Stuff		ends



		end

