SRC=/usr/local/devel/postgres

DEST=/private/src/postgres

#
# Check for update flag, which allows to reinstall new sources
# over an existing tree
#
UFLAG=
VERIFY=
case $1 in 
"-u")	# update an existing tree
	UFLAG=true
	shift
	;;
"-v")	# noexec - don't do anything, just report on new files
	UFLAG=true
	VERIFY=-v
	shift
	;;
esac

#
# first optional argument is where to install the new tree
#
[ -n "$1" ] && DEST="$1"

#
# If the destination is a relative pathname, make it absolute
# becuase we'll be moving around with cd(1)
#
case $DEST in
/*)	: ;;
*)	DEST=`pwd`/$DEST ;;
esac


if [ -d "$DEST" -a -z "$UFLAG" ]
then
	echo "pg_copytree: Warning: $DEST appears to already exist." 1>&2
	echo 'Use "pg_copytree -u" to update an existing tree' 1>&2
	exit 1
fi

cd $SRC || exit

DIRS="src Makefile"


#
# Copy directory structure and all current files
#
case "$VERIFY" in
"")	echo "Copying current files..." ;;
*)	echo "Comparing $SRC with $DEST..." ;;
esac

rdist $VERIFY -w -y -f - <<EOF
($DIRS) -> localhost
	except_pat ( /RCS\\$ /TAGS\\$ /core\\$ /doc\\$ /obj\\$ /old_doc\\$ /ref\\$ /tags\\$ );
	install $DEST;
EOF
case $? in
0)	: ;; # ok
*)	echo "rdist failed..." 1>&2
	exit
	;;
esac

case "$VERIFY" in
"")	: ;;
*)	exit 0 ;;
esac

#
# Create RCS links
#
echo "Creating RCS links..."
find $DIRS -name RCS -print |
egrep -v '/(doc|old_doc|ref)/' |
	while read file
	do
		#
		# assumes -d returns true for symbolic links, which it
		# does on the test's i tested.  too bad test doesn't have
		# the -e operator (existence)
		#
		[ ! -d "$DEST/$file" ] && ln -s $SRC/$file $DEST/$file
	done

#
# Making local object direcotries
#
echo "Creating local object directories..."
cd $DEST/src
bmake localobj

#
# Installing local Makefile.global
#
if [ ! -f obj/Makefile.global ]
then
	echo "Installing src/obj/Makefile.global to override default settings"
	cat > obj/Makefile.global <<EOF
POSTGRESDIR=	$DEST
EOF
fi
