#ifndef	ExcIncluded
#define ExcIncluded	1 /* %W% (serge) %G% */ /* $Header: /usr/local/devel/postgres/src/backend/utils/RCS/exception.h,v 1.3 1993/01/01 00:43:17 marc Exp $ */

#include <setjmp.h>

typedef char*		ExcMsg;

typedef struct {
	ExcMsg	msg;
} Exception;

typedef jmp_buf		ExcContext;
typedef Exception*	ExcId;
typedef long		ExcDetail;
typedef char*		ExcData;

typedef struct ExcFrame {
	struct ExcFrame	*link;
	ExcContext	context;
	ExcId		id;
	ExcDetail	detail;
	ExcData		data;
	ExcMsg		msg;
} ExcFrame;

extern	ExcFrame*	ExcCurFrameP;

#define	ExcBegin()							\
	{								\
		ExcFrame	exception;				\
									\
		exception.link = ExcCurFrameP; 				\
		if (setjmp(exception.context) == 0) {			\
			ExcCurFrameP = &exception;			\
			{
#define	ExcExcept()							\
			}						\
			ExcCurFrameP = exception.link;			\
		} else {						\
			{
#define	ExcEnd()							\
			}						\
		}							\
	}


#define raise4(x, t, d, msg) \
	ExcRaise(&(x), (ExcDetail)(t), (ExcData)(d), (ExcMsg)(msg))

#define	reraise() \
	raise4(exception.id, exception.detail, exception.data, exception.msg)

typedef	void	ExcProc(/* Exception*, ExcDetail, ExcData, ExcMsg */);

extern	void	ExcRaise(/* Exception*, ExcDetail, ExcData, ExcMsg */);

extern	ExcProc	*ExcGetUnCaught();
extern	ExcProc	*ExcSetUnCaught(/* ExcProc * */);

extern	void	ExcUnCaught(/* Exception*, ExcDetail, ExcData, ExcMsg */);

extern	void	ExcPrint(/* Exception*, ExcDetail, ExcData, ExcMsg */);
extern	char*	ProgramName;

extern	void	ExcAbort(/* Exception*, ExcDetail, ExcData, ExcMsg */);

#endif	/* !defined(ExcIncluded) */
