/***********************************************************************
 ** *   Recursion Header (#2) (recursion.h)                         * **
 ** *           Jimmy Bell                                          * **
 ** *                                                               * **
 ***********************************************************************
 *	Definitions of types used throughout recursive query processing.
 *
 *      $Header: /usr/local/devel/postgres/src/backend/executor/RCS/recursion.h,v 1.2 1990/08/17 08:52:31 cimarron Exp $
 */

#ifndef RecursionIncluded
#define RecursionIncluded

#include "nodes/plannodes.h"

typedef LispValue	UtilityRequest;

typedef union PlanOrUtility {
        Plan            plan;
        UtilityRequest  utility;
} PlanOrUtility;

typedef struct GeneralPlan {
	bool		isUtility;
	PlanOrUtility	planOrUtility;
} GeneralPlan;

#endif /* RecursionIncluded */

