.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/define_index.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /usr/local/devel/postgres/ref/postquel/RCS/define_index.cmdsrc,v 1.10 1993/02/17 02:25:58 olson Exp $
.TH "DEFINE INDEX" COMMANDS 02/08/93
.XA 2 "Define Index"
.SH NAME
define index \(em construct a secondary index
.SH SYNOPSIS
.(l M
\fBdefine\fR [\fBarchive\fR] \fBindex\fR index-name
	\fBon\fR classname \fBusing\fR am-name
	\fB(\fR attname\-1 type_class\-1 { , attname\-i type_class\-i } \fB)\fR
	[\fBwhere\fR qual]
.)l
.SH DESCRIPTION
This command constructs an index called
.IR index-name.
If the
.BR archive
keyword is absent,
the
.IR classname
class is indexed.  When
.BR archive
is present, an index is created on the archive class associated with
the
.IR classname
class.
.PP
.IR Am-name
is the name of the access method which is used for the index.
.PP
The key fields for the index are specified as a collection of
attribute names and associated
.IR "operator classes" .
An operator class is used to specify the operators to be used for a
particular index.  For example, a btree index on four-byte integers
would use the
.IR int4_ops
class; this operator class includes comparison functions for four-byte
integers.
.PP
If a
.IR qual
is given, the index will be a
.IR "partial index" ,
which will index only those instances in
.IR classname
for which the predicate specified by
.IR qual
is true.  Note that the predicate may only refer to attributes
of the indexed class,
.IR classname .
\*(PG may use a partial index as an access path only for
queries that include a restriction that implies that the predicate is true.
For example, if the index predicate is
.(C
emp.age < 30
.)C
then the index can be used for a query with the restriction
.(C
\fBwhere\fR emp.age < 25
.)C
but not for a query with the restriction
.(C
\fBwhere\fR emp.age < 40
.)C
and so forth.  Although partial indexes cannot be used to satisfy as wide
a range of queries as complete indexes, they can be constructed more quickly
and extended incrementally (see the \fBextend index\fR command).
.PP
\*(PG Version \*(PV provides btree and rtree access methods for
secondary indices.  The operator classes defined on btrees are
.(C
int2_ops	char_ops
int4_ops	char16_ops
int24_ops	oid_ops
int42_ops	text_ops
float4_ops	abstime_ops
float8_ops
.)C
The
.IR int24_ops
operator class is useful for constructing indices on int2 data, and
doing comparisons against int4 data in query qualifications.
Similarly,
.IR int42_ops
support indices on int4 data that is to be compared against int2 data
in queries.
.PP
The \*(PG query optimizer will consider using btree indices in a scan
whenever an indexed attribute is involved in a comparison using one of
.(C
<    <=    =    >=    >
.)C
.PP
The operator classes defined on rtrees are
.(C
box_ops
bigbox_ops
poly_ops
.)C
Both box classes support indices on the
.q box
datatype in \*(PG.  The difference between them is that
.IR bigbox_ops
scales box coordinates down, to avoid floating point exceptions from
doing multiplication, addition, and subtraction on very large
floating-point coordinates.  If the field on which your rectangles lie
is about 20,000 units square or larger, you should use
.IR bigbox_ops .
The
.IR poly_ops
operator class supports rtree indices on
.q polygon
data.
.PP
The \*(PG query optimizer will consider using an rtree index whenever
an indexed attribute is involved in a comparison using one of
.(C
<<    &<    &>    >>    @    ~=    &&
.)C
.SH EXAMPLES
.(C
/*
 * Create a btree index on the emp class using the age attribute.
 */
define index empindex on emp using btree (age int4_ops)
.)C
.(C
/*
 * Create a btree index on employee name.
 */
define index empname
	on emp using btree (name char16_ops)
.)C
.(C
/*
 * Create an rtree index on the bounding rectangle of cities.
 */
define index cityrect
	on city using rtree (boundbox box_ops)
.)C
.(C
/*
 * Create a partial btree index on employee salaries for
 *   employees over age 50
 */
define index empsal
	on emp using btree (salary int4_ops) where emp.age > 49
.)C
Note: if the partial-index predicate refers to an attribute of a
discrete-valued type (such as integers), it is slightly preferable to
express the predicate as, e.g., "emp.age > 49" rather than as "emp.age >= 50",
because even though both indexes would, in theory, be equally usable, \*(PG
would only be able to use a partial index with the former predicate in the
event of a query that had the exact restriction "emp.age > 49".
.SH BUGS
Archive indices are not supported in Version \*(PV.
.PP
There should be an access method designer's guide.
.PP
Indices may only be defined on a single key.  This can be hacked
around by defining composite types and using the \*(PG support for
indices on functional values of attributes.
.PP
The only kind of partial index predicates \*(PG Version \*(PV
understands are those made up of boolean combinations of simple
clauses of the form
.(C
ATTR OP CONST
.)C
where ATTR is a single attribute of the indexed class, and OP is
an operator in a btree operator class defined on the types of
ATTR and CONST.  If some other form of predicate is specified,
Version \*(PV will never use the resulting partial index.
