.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/define_function.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/src/ref/postquel/RCS/define_function.cmdsrc,v 1.9 1993/03/15 20:21:12 aoki Exp $
.TH "DEFINE FUNCTION" COMMANDS 01/23/93
.XA 2 "Define Function"
.SH "NAME"
define function \(em define a new function
.SH "SYNOPSIS"
.(l M
\fBdefine function\fP function_name \fB(\fP
	\fBlanguage =\fP {"c" | "postquel"}\fB,\fP
	\fBreturntype =\fP type-r
	[ \fB, iscachable\fP ]
.\"	[ \fB, trusted\fP ]
	[ \fB, percall_cpu =\fP \fB"costly\fR{\fB!\fR*}\fB"\fR ]
	[ \fB, perbyte_cpu =\fP \fB"costly\fR{\fB!\fR*}\fB"\fR ]
	[ \fB, outin_ratio = \fP percentage ]
	[ \fB, byte_pct = \fP percentage ]
	\fB)\fP
    [ \fBarg is (\fP type-1  { \fB,\fP type-n } \fB)\fP ]
    \fBas\fP {"/full/path/to/objectfile" | "list-of-postquel-queries"}
.)l
.SH "DESCRIPTION"
With this command, a \*(PG user can register a function with \*(PG.
Subsequently, this user is treated as the owner of the function.
.PP
When defining a function with arguments, the input data types,
.IR type-1 ,
.IR type-2 ,
\&...,
.IR type-n ,
and the return data type,
.IR type-r
must be specified, along with the language, which may be
.IR "\*(lqc\*(rq"
or
.IR "\*(lqpostquel\*(rq" .
(The
.IR "arg is"
clause may be left out if the function has no arguments.)
The input types may be base or complex types.  The output type may be
specified as a base type, complex type, or 
.IR "setof <type>".
The 
.IR setof
modifier indicates that the function will return a set of items,
rather than a single item.
The
.IR as
clause of the command is treated differently for C and \*(PQ
functions, as explained below.
.SH "C FUNCTIONS"
Functions written in C can be defined to \*(PG, which will dynamically
load them into its address space.  The loading happens either using
.IR load (commands)
or automatically the first time the function is necessary for
execution. Repeated execution of a function will cause negligible
additional overhead, as the function will remain in a main memory
cache.
.PP
The 
.BR iscachable
flag indicates to the system that the return value of the function can
be associatively cached.
.PP
The 
.BR trusted
flag specifies that the function can run inside the \*(PG server's
address space with the user-id of the \*(PG super-user.  If this flag
is not specified, the function will be run in a separate process.
.PP
The 
.BR percall_cpu ,
.BR perbyte_cpu ,
.BR outin_ratio ,
and
.BR byte_pct
flags are provided for C functions to give a rough estimate of the
function's running time, allowing the query optimizer to postpone
applying expensive functions used in a query's
.BR where
clause.  The 
.BR percall_cpu
flag captures the overhead of the function's invocation (regardless of
input size), while the
.BR perbyte_cpu
flag captures the sensitivity of the function's running time to the
size of its inputs.  The magnitude of these two parameters is
determined by the number of exclamation points appearing after the
word
.BR costly :
specifically, each exclamation point can be thought of as another
order of magnitude in cost, i.e.,
.ie t \{
.(C
cost = 10\s-2\unumber-of-exclamation-points\d\s0
.)C
\}
.el \{
.(C
cost = 10 ** number-of-exclamation-points
.)C
\}
The default value for 
.BR percall_cpu
and
.BR perbyte_cpu
is 0.  Examples of reasonable cost values may be found in the system
catalog \*(lqpg_proc\*(rq; most simple functions on base types have
costs of 0.
.PP
The
.IR outin_ratio
is provided for functions which return variable-length types, such as
.IR text
or
.IR bytea.
It should be set to the size of the function's output as a percentage
of the size of the input.  For example, a function which compresses
its operands by 2 should have
.BR "outin_ratio" " = 50."
The default value is 100.
.PP
The
.BR byte_pct
flag should be set to the percentage of the bytes of the arguments
that actually need to be examined in order to compute the function.
This flag is particularly useful for functions which generally take a
large object as an argument, but only examine a small fixed portion of
the object.  The default value is 100.
.PP
The body of a C function following 
.BR as
should be the
.BR "FULL PATH"
of the object code (.o file) for the function, bracketed by quotation
marks.  (\*(PG will not compile a function automatically \(em it must
be compiled before it is used in a
.BR "define function"
command.)
.PP
C functions with base type arguments can be written in a
straightforward fashion.  The C equivalents of built-in \*(PG types
are accessible in a C file if 
.(C
\&.../src/backend/utils/builtins.h
.)C
is included as a header file.  This can be achieved by having
.(C
\&#include <utils/builtins.h>
.)C
at the top of the C source file and by compiling all C files with the
following include options:
.(C
-I.../src/backend
-I.../src/backend/port/<portname>
-I.../src/backend/obj
.)C
before any \*(lq.c\*(rq programs in the 
.IR cc
command line, e.g.:
.(C
cc -I.../src/backend \e
   -I.../src/backend/port/<portname> \e
   -I.../src/backend/obj \e
   -c progname.c
.)C
where \*(lq...\*(rq is the path to the installed \*(PG source tree and
\*(lq<portname>\*(rq is the name of the port for which the source tree
has been built.
.PP
The convention for passing arguments to and from the user's C
functions is to use pass-by-value for data types that are 32 bits (4
bytes) or smaller, and pass-by-reference for data types that require
more than 32 bits.
.if t \{
The following table gives the C type required for parameters in the C
functions that will be loaded into \*(PG.  The \*(lqDefined In\*(rq
column gives the actual header file (in the
.(C
\&.../src/backend
.)C
directory) that the equivalent C type is defined.  However, if you
include \*(lqutils/builtins.h\*(rq, these files will automatically be
included.
.SH "Equivalent C Types for Built-In \*(PG Types"
.PP
.TS
center;
l l l
l l l.
\fBBuilt-In Type\fP	\fBC Type\fP	\fBDefined In\fP
_
abstime 	AbsoluteTime	utils/nabstime.h
bool	bool	tmp/c.h
box	(BOX *) 	utils/geo-decls.h
bytea	(bytea *)	tmp/postgres.h
char	char	N/A
char16	Char16 or (char16 *)	tmp/postgres.h
cid	CID	tmp/postgres.h
int2	int2	tmp/postgres.h
int28	(int28 *)	tmp/postgres.h
int4	int4	tmp/postgres.h
float4	float32 or (float4 *)	tmp/c.h or tmp/postgres.h
float8	float64 or (float8 *)	tmp/c.h or tmp/postgres.h
lseg	(LSEG *)	tmp/geo-decls.h
oid	oid	tmp/postgres.h
oid8	(oid8 *)	tmp/postgres.h
path	(PATH *)	utils/geo-decls.h
point	(POINT *)	utils/geo-decls.h
regproc 	regproc or REGPROC	tmp/postgres.h
reltime 	RELTIME 	tmp/postgres.h
text	(text *)	tmp/postgres.h
tid	ItemPointer	storage/itemptr.h
tinterval	TimeInterval	tmp/nabstime.h
uint2	uint16	tmp/c.h
uint4	uint32	tmp/c.h
xid	(XID *) 	tmp/postgres.h
.TE
\}
.PP
Complex arguments to C functions are passed into the C function as a
special C type, TUPLE, defined in
.(C
\&.../src/libpq/libpq-fe.h.
.)C
Given a variable 
.IR t
of this type, the C function may extract attributes from the function
using the function call:
.(C
GetAttributeByName(t, "fieldname", &isnull)
.)C
where 
.IR isnull
is a pointer to a 
.IR bool ,
which the function sets to
.IR true
if the field is null.  The result of this function should be cast
appropriately as shown in the examples below.
.SH "POSTQUEL FUNCTIONS"
\*(PQ functions execute an arbitrary list of \*(PQ queries, returning
the results of the last query in the list.  \*(PQ functions in general
return sets.  If their returntype is not specified as a
.IR setof ,
then an arbitrary element of the last query's result will be returned.
The expensive function parameters
.BR percall_cpu,
.BR perbyte_cpu,
.BR outin_ratio,
and
.BR byte_pct
are not used for \*(PQ functions; their costs are determined
dynamically by the query optimizer.
.PP
The body of a \*(PQ function following
.BR as
should be a list of queries separated by whitespace characters and
bracketed within quotation marks.  Note that quotation marks used in
the queries must be escaped, by preceding them with two backslashes
(i.e. \e\e").
.PP
Arguments to the \*(PQ function may be referenced in the queries using
a $n syntax: $1 refers to the first argument, $2 to the second, and so
on.  If an argument is complex, then a \*(lqdot\*(rq notation may be
used to access attributes of the argument (e.g. \*(lq$1.emp\*(rq), or
to invoke functions via a nested-dot syntax.
.SH "EXAMPLES: C Functions"
The following command defines a C function, overpaid, of two basetype
arguments.
.(C
define function overpaid
        (language = "c", returntype = bool)
        arg is (float8, int4)
        as "/usr/postgres/src/adt/overpaid.o"
.)C
The C file "overpaid.c" might look something like:
.(C
#include <utils/builtins.h>

bool overpaid(salary, age)
        float8 *salary;
        int4    age;
{
        if (*salary > 200000.00)
                return(TRUE);
        if ((age < 30) && (*salary > 100000.00))
                return(TRUE);
        return(FALSE)
}
.)C
The overpaid function can be used in a query, e.g:
.(C
retrieve (EMP.name)
    where overpaid(EMP.salary, EMP.age)
.)C
One can also write this as a function of a single argument of type
EMP:
.(C
define function overpaid_2
        (language = "c", returntype = bool)
        arg is (EMP)
        as "/usr/postgres/src/adt/overpaid_2.o"
.)C
The following query is now accepted:
.(C
retrieve (EMP.name) where overpaid_2(EMP) 
.)C
In this case, in the body of the overpaid_2 function, the fields in the EMP
record must be extracted.  The C file "overpaid_2.c" might look
something like:
.(C
#include <utils/builtins.h>
#include <tmp/libpq-fe.h>

bool overpaid_2(t)
TUPLE t;
{
    float8 *salary;
    int4    age;
    bool    salnull, agenull;

    salary = (float8 *)GetAttributeByName(t, "salary",
                                          &salnull);
    age = (int4)GetAttributeByName(t, "age", &agenull);
    if (!salnull && *salary > 200000.00)
        return(TRUE);
    if (!agenull && (age<30) && (*salary > 100000.00))
        return(TRUE);
    return(FALSE)
}
.)C
.SH "EXAMPLES: \*(PQ Functions"
To illustrate a simple \*(PQ function, consider the following,
which might be used to debit a bank account:
.(C
define function TP1
        (language = "postquel", returntype = int4)
        arg is (int4, float8)
        as "replace BANK (balance = BANK.balance - $2)
              where BANK.accountno = $1
            retrieve(x = 1)"
.)C
A user could execute this function to debit account 17 by $100.00 as
follows:
.(C
retrieve (x = TP1( 17,100.0))
.)C
The following more interesting examples take a single argument of type
EMP, and retrieve multiple results:
.(C
define function hobbies
    (language = "postquel", returntype = setof HOBBIES)
    arg is (EMP)
    as "retrieve (HOBBIES.all)
          where $1.name = HOBBIES.person"

define function children
    (language = "postquel", returntype = setof KIDS)
    arg is (EMP)
    as "retrieve (KIDS.all)
          where $1.name = KIDS.dad
             or $1.name = KIDS.mom"
.)C
Then the following query retrieves overpaid employees, their hobbies, and
their children:
.(C
retrieve (name=name(EMP), hobby=name(hobbies(EMP)),
	kid=name(children(EMP)))
    where overpaid_2(EMP)
.)C
Note that attributes can be projected using function syntax (e.g.
name(EMP)), as well as the traditional dot syntax (e.g. EMP.name).
.PP
An equivalent expression of the previous query is:
.(C
retrieve (EMP.name, hobby=EMP.hobbies.name,
	kid=EMP.children.name)
    where overpaid_2(EMP)
.)C
This "nested dot" notation for functions can be used to cascade
functions of single arguments.  Note that the function after a dot
must have only one argument, of the type returned by the function
before the dot.
.PP
\*(PG 
.IR flattens
the target list of the queries above.  That is, it produces the
cross-product of the hobbies and the children of the employees.  For
example, given the schema:
.(C
create BANK (accountno = int4, balance = float8) 
append BANK (accountno = 17,
             balance = "10000.00"::float8)
create EMP (name = char16, salary = float8,
            dept = char16, age = int4)
create HOBBIES (name = char16, person = char16) 
create KIDS (name = char16, dad = char16, mom = char16) 
append EMP (name = "joey", salary = "100000.01"::float8,
            dept = "toy", age = 24) 
append EMP (name = "jeff", salary = "100000.01"::float8,
            dept = "shoe", age = 23)
append EMP (name = "wei", salary = "100000"::float8,
            dept = "tv", age = 30) 
append EMP (name = "mike", salary = "500000"::float8,
            dept = "appliances", age = 30) 
append HOBBIES (name = "biking", person = "jeff" ) 
append HOBBIES (name = "jamming", person = "joey" ) 
append HOBBIES (name = "basketball", person = "wei") 
append HOBBIES (name = "swimming", person = "mike") 
append HOBBIES (name = "philately", person = "mike") 
append KIDS (name = "matthew", dad = "mike",
             mom = "teresa")
append KIDS (name = "calvin", dad = "mike",
             mom = "teresa")
.)C
The query above returns
.if n .ta 1.5i +1.5i +1.5i
.if n .ta 15n +15n +15n
.(C
\fBname	hobby	kid\fP

jeff	biking	(null)
joey	jamming	(null)
mike	swimming	matthew
mike	philately	matthew
mike	swimming	calvin
mike	philately	calvin
.)C
Note that flattening preserves the name and hobby fields even when the
\*(lqkid\*(rq field is null.
.SH "SEE ALSO"
information(unix), load(commands), remove function(commands).
.SH "NOTES"
The 
.BR percall_cpu
and
.BR perbyte_cpu
flags can take integers surrounded by quotes instead of the 
.BR """costly{!*}"""
syntax described above.  This allows a finer grain of distinction
between function costs, but is not encouraged since such distinctions
are difficult to estimate accurately.
.PP
Under Ultrix, all object files that \*(PG is expected to load
dynamically must be compiled under
.IR /bin/cc
with the \*(lq-G 0\*(rq option turned on.
.SH "RESTRICTIONS"
The name of the C function must be a legal C function name, and the
name of the function in C code must be exactly the same as the name
used in
.BR "define function" .
.SH "BUGS"
Function names must be unique per database, except for the fact that
there may be attributes of the same name as a function.  In the case
that a there is an ambiguity between a function on a complex type and
an attribute of the complex type, the attribute will always be used.
.PP
The
.BR iscachable
flag does not do anything in Version \*(PV.
.PP
Untrusted functions cannot make any function calls using access
methods or built-in functions that have not been loaded into the
untrusted-function process.
.PP
Untrusted functions must be explicitly designated as such in a
separate query, e.g.:
.(C
replace pg_proc (proistrusted = "f"::bool)
	where pg_proc.proname = "mynewfunction"
.)C
Untrusted functions will become the default in a future release.
.PP
C functions cannot return a set of values.
.PP
The dynamic loader for DECstation Ultrix is very slow.
