.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/create_version.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/create_version.cmdsrc,v 1.9 1993/01/26 02:43:13 aoki Exp $
.TH "CREATE VERSION" COMMANDS 01/23/93
.XA 2 "Create Version"
.SH NAME
create version \(em construct a version class 
.SH SYNOPSIS
.(l M
\fBcreate version\fP classname1 \fBfrom\fP classname2 [\fB[\fPabstime\fB]\fP]
.)l
.SH DESCRIPTION
This command creates a version class
.IR classname1
which is related
to its parent class,
.IR classname2 .
Initially,
.IR classname1
has the same contents as
.IR classname2.
As updates to 
.IR classname1 
occur, however,
the content of
.IR classname1
diverges from
.IR classname2.
On the other hand, any updates to
.IR classname2
show transparently through to
.IR classname1 ,
unless the instance in question has already been updated in
.IR classname1 .  
.PP
If the optional
.IR abstime
clause is specified, then the version is constructed relative to a
.BR snapshot
of
.IR classname2
as of the time specified.
.PP
\*(PG uses the query rewrite rule system to ensure that 
.IR classname1
is differentially encoded relative to
.IR classname2.  
Moreover, 
.IR classname1
is automatically constructed to have the same indexes as
.IR classname2 .
It is legal to cascade versions arbitrarily, so a tree of versions can
ultimately result.  The algorithms that control versions are explained
in [ONG90].
.SH EXAMPLE
.(C
/*
 * create a version foobar from a snapshot of
 * barfoo as of January 17, 1990
 */
create version foobar from barfoo [ "Jan 17 1990" ]
.)C
.SH "SEE ALSO"
define view(commands), merge(commands), postquel(commands).
.SH "BUGS"
Snapshots (i.e., the optional 
.IR abstime 
clause) are not implemented in Version \*(PV.
