#!/usr/local/bin/perl
# ^
# Ensure that perl is really in that location...
#
# Small example of how to query and output
# the results of an mSQL rq. Requires the mSQL/Perl
# adaptor.
#
$version="1.00b";
#
# (c) 1995 Dirk-Willem van Gulik
#	   Dirk.vanGulik@jrc.it
#	   http://me-www.jrc.it/~dirkx
#
# Developed at/by:
#	   The European Service Exchange
#	   a project of The Center for Earth Observation
#	   of the European Commission.
#
#	   http://ewse.ceo.org, http://www.ceo.org
#	   
# Please give credit, where credits are due; it keeps us
# helping you !
#
$prog="test.pl";


# Some default vriables:

# $host="host-with-msql-server

$test_dbase="www_test";
$test_table="password_table";

# NOTE:
# Leave $host undefined if you are on the same machine, will
# ensure that /dev/msql is used rather than the slow
# tcp/ip connection.
#


# # # # # # #
#

# Announce html coming up
#
print "Content-type: text/html\n\n";


# ensure we have the PerlMsql adaptor switched on..
#
&Exit("Could not Initialize/find the PerlMsql adaptor $@")
	if (eval("use Msql"));


# Ensure the connection (this can be done more effectively,
# but this illustrates things better....
#
&Exit("Could not connect to mSQL server")
	unless ($dbh=Connect Msql $host );

# Find out what is there...
#

&Exit("Could not get a list of dbases ")
	unless( @dbase = $dbh -> ListDBs);

# and make an html overview..
#

# Note: We are outputting to a variable, rather than
# 	directly to the std-out, to ensure that if there
#	is an error, we do not get crap prefixing it, i.e.
#	a 'cannot...' in the middle of a nicely formatted
#	table. !

# Make a header...
#
$overview=qq|
<h2>Tables, overview of the structure</h2>
<ul>
|;

# For each of the databases
#
for $dbase (@dbase) {

	# announce what database we are talking of
	#
	$overview .= "<li>dBase: $dbase<ul>";

	# make sure we are taking to that database
	#
	&Exit("Could not select mSQL dbase '$dbase'")
		unless (Msql::SelectDB($dbh,$dbase));

	# find out what tables it has, and loop round
	#
	for $table ( Msql::ListTables($dbh) ) {
		# A header for this table
		#
		$overview .= "<li>Table: <b>$table</b><ul>";

		# work out what fields we have, if any
		#
		&Exit("Could not get a list of Fields for $table")
			unless ($sth = Msql::ListFields( $dbh,$table ));

		# if there are any fields, then loop round,
		# or ginve a no fields message
		#
		if ($sth->numfields) {

			# loop round the fields there are
			#
			foreach $field ( @{$sth->name} ) {

				# and output them all...
				#
				$overview .="<li> Field: <b>$field</b>";
				};
			} else {

			# apolegetic message
			#
			$overview .="<li> No fields";
			};

		# end of field list
		#
		$overview .="</ul><p>";
		};

	# end of table list
	$overview .="</ul><hr>";
	};

# end of databases list
$overview .="</ul><hr><p>";


# Now get down to the real work, and get into the test table
#
&Exit("Could not get a list of Fields for $test_table")
	unless ($sth = Msql::ListFields( $dbh,$test_table ));

# if there are any fields
#
if ($sth->numfields) {

	# get yerself a list
	#
	@fields=(@{$sth->table});
	} else {

	# if not barf seriously...
	#	
	&Exit("No fields in the test table: $test_table");
	};
	
# Now try to query the table we came for..
#
&Exit("Could not select mSQL dbase '$test_dbase'")
	unless (Msql::SelectDB($dbh,$test_dbase));


# Build a query string (usually you would use form
# arguments of course...
#
$qstring="select * from $test_table";

&Exit("Could not do query '$qstring'")
	unless ($sth = Msql::Query( $dbh ,$qstring ));

# Prepare the output...
#
$results=qq|
<h3>Results</h3>
of the query $qstring<br>
<p>
|;

# And output the results...
#
if ($sth->numrows) {
	# we have results, so...	
	#

	# null a results/row counter
	#
	$i=0;

	# create a header for the table
	#
	$results .="<table border><tr><th>#</th>";
	for $field (@fields) {
		$results .="<th>$field</th>";
		};
	$results .="</tr>";

	# and loop over each of the rows in the results
	#
	while (@row=FetchRow $sth ) {

		# and count them toooo...
		#
		$i++;
		$results .="<tr><td>$i</td>";

		# loop over the fields in each row
		for $r (@row) {
			$results .= "<td>$r</td>";
			};
		$results .="</tr>";
		};

	$results .="</table>";

	# be suspicious, and check if we got all we
	# wher promised ?!
	#
	&Exit("Not all values received")
		if ($i != $sth->numrows);
	
	} else {

	# and if there is nothing, be nice...
	#
	$results .="<b>NO</b> results... :-(";
	};

# Right, ready ?! we can now output it as we are sure that we
# will not have any more nasty errors... at least not errors
# we want to tell the user about..
#
print qq|<html>
<head>
<title>mSQL Example</title>
</head>
<body>
<center><h1><hr>mSQL Query Example Script</h1>
|.&contact().qq|
</center>
<hr>
<p>
$results
<p>
$overview
<p>
<hr>
Generated: $prog Version: $version Contact: |.&contact().qq|
</body>
</html>
|;

exit;


# Terminating error message, bit primitive really
#
sub Exit { 
local ($errmsg)=@_;
print qq|<html>
<head><title>mSQL; Failure</title></head><body>
<center><h1><hr>mSQL Script Failure</h1>
|.&contact().qq|
</center>
<h2>$errmsg</h2>
<h3>$@ $Msql::db_errstr</h3>
<p>
<hr>
Generated: $prog Version: $version Contact: |.&contact().qq|
</body>
</html>
|;
exit;
};


# The EWSE compulsore :-)
#
sub contact {
return qq|
<i>
<a href="http://me-www.jrc.it/~dirkx">Dirk-Willem van Gulik</a> 
-
<code><a href="mailto:Dirk.vanGulik\@jrc.it">&lt;Dirk.vanGulik\@jrc.it&gt;</a></code>
-
<a href="http://ewse.ceo.org">EWSE</a>
-
a <a href="http://www.ceo.org">CEO</a> project
</i>
|;
};

