#ifndef MP_MATHPAD_H
#define MP_MATHPAD_H
/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
********************************************************************/
/* mathpad.h */
/* Various odds and ends that are useful in most of the system */

typedef unsigned int Index;
typedef int Offset;

typedef enum Opkind { None, Prefix, Postfix,
                      Infix, LeftBinding, RightBinding
                    } Opkind;

typedef unsigned short int Char;

#define Newline     0xFFFF
#define Settab      0xFFFE
#define Rtab        0xFFFD
#define Ltab        0xFFFC
#define Tabplus     0xFFFB
#define Tabminus    0xFFFA
#define Pushtabs    0xFFF9
#define Poptabs     0xFFF8
#define SoftNewline 0xFFF7
#define AskText     0xFFF6
#define InText      0xFFF5
#define InMath      0xFFF4
#define InDisp      0xFFF3
#define CloseStack  0xFFF2
#define StartHide   0xFFF1
#define PopSize     0xFFF0
#define OpenTop     0xFFEF
#define CloseTop    0xFFEE
#define OpenBottom  0xFFED
#define CloseBottom 0xFFEC
#define OpenGap     0xFFEB
#define CloseGap    0xFFEA
#define GlueSpace   0xFFE9
#define GlueLine    0xFFE8
#define GlueStipple 0xFFE7
#define StackB      0xFFE6
#define StackC      0xFFE5
#define TopGap      0xFFE4
#define GapBottom   0xFFE3
#define StackClose  0xFFE2
#define EndHide     0xFFE1
#define TabOpen     0xFFE0
#define TabClose    0xFFDF
#define DisplayOpen 0xFFDE
#define DisplayClose 0xFFDD
#define VerLine     0xFFDC
#define ThinSpace   0xFFDB
#define AskMath     0xFFDA
#define AskBoth     0xFFD9
#define PlName      0xFFD8
#define PlNameEnd   0xFFD7
#define TabCodes    0xFFD0
#define Expr        0xFF00
#define Op          0xFF10
#define Id          0xFF20
#define Var         0xFF30
#define Text        0xFF40
#define List        0xFF50
#define Disp        0xFF60
#define NodeCode    0xFF00
#define SpaceCode   0xFE00

#define SpaceFont   0xFE
#define StackFont   0xFD
#define FontFont    0xFC
#define SizeFont    0xFB
#define PopFont     0xFA


#define IsTab(c) (TabCodes <= (c))
#define IsNewline(c) ((c)==Newline || (c)==SoftNewline)
#define Num2Tab(c) ((c)^0xFFFF)

typedef enum { Normal, Reverse, Xor } TextMode;
#define SecondSel 0x1
#define ThirdSel  0x2
#define PrimSel   0x4

#define MaxPrecedence 20

#define Ph(c) ((c) & 0xFFF0)
#define Num(c) ((c) & 0xF)
#define PhNum2Char(p,n) ((p) | (n))
#define IsPh(c) (NodeCode <= (c) && (c) < TabCodes)
#define Char2Node(c) (IsPh(c) ? NodeCode : (c))
#define Char2Ph(c) (IsPh(c) ? Ph(c) : (c))

#define Ph2Num(c) (((Char)((c) & 0xF0)) >> 4)
#define Num2Ph(c) (((c) << 4) | NodeCode)

#define Opspace(c) ((c) | SpaceCode)
#define IsOpspace(c) (((c) & SpaceCode) == SpaceCode)

#define Font2Char(f,as) (((f) << 8) | ((as) & 0xFF))
#define Char2Font(c) ((c) >> 8)
#define Char2ASCII(c) ((c) & 0xFF)

#ifndef Bool
#define Bool int
#define True 1
#define False 0
#endif

#define LDEFMODE 0
#define LTEXTMODE 1
#define LMATHMODE 2
#define LBOTHMODE 3

/* for parsing default added "templates" (E), $E$, \mbox{T} */
#define INTERNAL_BRACES 0xffff
#define INTERNAL_EXPRESSION 0xfffe
#define INTERNAL_DISPLAY 0xfffd
#define INTERNAL_TEXT 0xfffc

typedef void (*Cpfv)(void);

#endif
