#ifndef MP_FLEX_H
#define MP_FLEX_H
/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
********************************************************************/
typedef
struct { void *arr;
	 int nr;
	 int max;
	 int size;
	 int (*comp)(void*,void*);
     } FLEXARRAY;

extern int  fx_contains(FLEXARRAY *fl, void *item);
extern void fx_remove(FLEXARRAY *fl, void *item);
extern void fx_add(FLEXARRAY *fl, void *item);
/*extern void fx_insert(FLEXARRAY *fl, int pos, void *item);*/
extern int  fx_switch(FLEXARRAY *fl, void *olditem, void *newitem);
extern void fx_init(FLEXARRAY *fl, int sz, int (*cmp)(void*,void*));
extern void fx_clear(FLEXARRAY *fl);
extern int  fx_set(FLEXARRAY *fl, int pos, void *item);

#define fx_item(A,B) (((char*)(A)->arr) + (B)*((A)->size))

#define fx_max(A) ((A)->nr)


extern int int_cmp(void *a, void *b);


#define int_contains(A,B) fx_contains(&(A), (void*) &(B))
#define int_remove(A,B)   fx_remove(&(A), (void*) &(B))
#define int_add(A,B)      fx_add(&(A),(void*) &(B))
/*#define int_insert(A,B,C) fx_insert(&(A),(B), (void*) &(C))*/
#define int_switch(A,B,C) fx_switch(&(A), (void*) &(B), (void*) &(C))
#define int_init(A)       fx_init(&(A), sizeof(int), int_cmp)
#define int_clear(A)      fx_clear(&(A))
#define int_set(A,B,C)    fx_set(&(A), (B), &(C))
#define int_item(A,B)     (*((int*) fx_item(&(A),B))) 
#define int_max(A)        fx_max(&(A))

/* other types possible */

#endif
